/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.improvingsteppercentage;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.File;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.optaplanner.benchmark.impl.ProblemBenchmark;
import org.optaplanner.benchmark.impl.SingleBenchmark;
import org.optaplanner.benchmark.impl.statistic.AbstractProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.MillisecondsSpendNumberFormat;
import org.optaplanner.benchmark.impl.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.statistic.SingleStatistic;
import org.optaplanner.benchmark.impl.statistic.improvingsteppercentage.ImprovingStepPercentageSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.improvingsteppercentage.ImprovingStepPercentageSingleStatisticPoint;
import org.optaplanner.core.impl.move.Move;

public class ImprovingStepPercentageProblemStatistic
extends AbstractProblemStatistic {
    protected Map<Class<? extends Move>, File> graphStatisticFileMap = null;

    public ImprovingStepPercentageProblemStatistic(ProblemBenchmark problemBenchmark) {
        super(problemBenchmark, ProblemStatisticType.IMPROVING_STEP_PERCENTAGE);
    }

    @Override
    public SingleStatistic createSingleStatistic() {
        return new ImprovingStepPercentageSingleStatistic();
    }

    public Collection<Class<? extends Move>> getMoveClasses() {
        return this.graphStatisticFileMap.keySet();
    }

    public String getGraphFilePath(Class<? extends Move> moveClass) {
        return this.toFilePath(this.graphStatisticFileMap.get(moveClass));
    }

    @Override
    protected void writeCsvStatistic() {
    }

    @Override
    protected void writeGraphStatistic() {
        HashMap<Class, XYPlot> plots = new HashMap<Class, XYPlot>();
        int seriesIndex = 0;
        for (SingleBenchmark singleBenchmark : this.problemBenchmark.getSingleBenchmarkList()) {
            HashMap<Class<? extends Move>, XYSeries> seriesMap = new HashMap<Class<? extends Move>, XYSeries>();
            XYStepRenderer renderer = new XYStepRenderer();
            if (singleBenchmark.isSuccess()) {
                ImprovingStepPercentageSingleStatistic singleStatistic = (ImprovingStepPercentageSingleStatistic)singleBenchmark.getSingleStatistic(this.problemStatisticType);
                for (Map.Entry<Class<? extends Move>, List<ImprovingStepPercentageSingleStatisticPoint>> entry : singleStatistic.getPointLists().entrySet()) {
                    Class<? extends Move> moveClass = entry.getKey();
                    if (!seriesMap.containsKey(moveClass)) {
                        seriesMap.put(moveClass, new XYSeries((Comparable)((Object)singleBenchmark.getSolverBenchmark().getNameWithFavoriteSuffix())));
                    }
                    XYSeries series = (XYSeries)seriesMap.get(moveClass);
                    for (ImprovingStepPercentageSingleStatisticPoint point : entry.getValue()) {
                        long timeMillisSpend = point.getTimeMillisSpend();
                        double ratio = point.getRatio();
                        series.add((double)timeMillisSpend, ratio);
                    }
                }
            }
            if (singleBenchmark.getSolverBenchmark().isFavorite()) {
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
            }
            for (Map.Entry entry : seriesMap.entrySet()) {
                Class moveClass = (Class)entry.getKey();
                if (!plots.containsKey(moveClass)) {
                    plots.put(moveClass, this.createPlot(moveClass));
                }
                ((XYPlot)plots.get(moveClass)).setDataset(seriesIndex, (XYDataset)new XYSeriesCollection((XYSeries)entry.getValue()));
                ((XYPlot)plots.get(moveClass)).setRenderer(seriesIndex, (XYItemRenderer)renderer);
            }
            for (int i = 0; i < seriesMap.size(); ++i) {
            }
            ++seriesIndex;
        }
        this.graphStatisticFileMap = new LinkedHashMap<Class<? extends Move>, File>(plots.size());
        for (Map.Entry entry : plots.entrySet()) {
            Class moveClass = (Class)entry.getKey();
            JFreeChart chart = new JFreeChart(this.problemBenchmark.getName() + " improving step percentage " + moveClass.getSimpleName() + " statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)entry.getValue(), true);
            this.graphStatisticFileMap.put(moveClass, this.writeChartToImageFile(chart, this.problemBenchmark.getName() + "ImprovingStepPercentageStatistic-" + moveClass.getCanonicalName()));
        }
    }

    private XYPlot createPlot(Class<? extends Move> moveClass) {
        Locale locale = this.problemBenchmark.getPlannerBenchmark().getBenchmarkReport().getLocale();
        NumberAxis xAxis = new NumberAxis("Time spend");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpendNumberFormat(locale));
        NumberAxis yAxis = new NumberAxis("Percentage that improve the score");
        yAxis.setNumberFormatOverride(NumberFormat.getPercentInstance(locale));
        yAxis.setRange(0.0, 1.0);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }
}

