/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.cloner.PlanningCloneable;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.InstitutionParametrization;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.PeriodPenalty;
import org.optaplanner.examples.examination.domain.Room;
import org.optaplanner.examples.examination.domain.RoomPenalty;
import org.optaplanner.examples.examination.domain.Student;
import org.optaplanner.examples.examination.domain.Topic;
import org.optaplanner.examples.examination.domain.solver.TopicConflict;
import org.optaplanner.persistence.xstream.XStreamScoreConverter;

@PlanningSolution
@XStreamAlias(value="Examination")
public class Examination
extends AbstractPersistable
implements Solution<HardSoftScore>,
PlanningCloneable<Examination> {
    private InstitutionParametrization institutionParametrization;
    private List<Student> studentList;
    private List<Topic> topicList;
    private List<Period> periodList;
    private List<Room> roomList;
    private List<PeriodPenalty> periodPenaltyList;
    private List<RoomPenalty> roomPenaltyList;
    private List<Exam> examList;
    @XStreamConverter(value=XStreamScoreConverter.class, types={HardSoftScoreDefinition.class})
    private HardSoftScore score;

    public InstitutionParametrization getInstitutionParametrization() {
        return this.institutionParametrization;
    }

    public void setInstitutionParametrization(InstitutionParametrization institutionParametrization) {
        this.institutionParametrization = institutionParametrization;
    }

    public List<Student> getStudentList() {
        return this.studentList;
    }

    public void setStudentList(List<Student> studentList) {
        this.studentList = studentList;
    }

    public List<Topic> getTopicList() {
        return this.topicList;
    }

    public void setTopicList(List<Topic> topicList) {
        this.topicList = topicList;
    }

    public List<Period> getPeriodList() {
        return this.periodList;
    }

    public void setPeriodList(List<Period> periodList) {
        this.periodList = periodList;
    }

    public List<Room> getRoomList() {
        return this.roomList;
    }

    public void setRoomList(List<Room> roomList) {
        this.roomList = roomList;
    }

    public List<PeriodPenalty> getPeriodPenaltyList() {
        return this.periodPenaltyList;
    }

    public void setPeriodPenaltyList(List<PeriodPenalty> periodPenaltyList) {
        this.periodPenaltyList = periodPenaltyList;
    }

    public List<RoomPenalty> getRoomPenaltyList() {
        return this.roomPenaltyList;
    }

    public void setRoomPenaltyList(List<RoomPenalty> roomPenaltyList) {
        this.roomPenaltyList = roomPenaltyList;
    }

    @PlanningEntityCollectionProperty
    public List<Exam> getExamList() {
        return this.examList;
    }

    public void setExamList(List<Exam> examList) {
        this.examList = examList;
    }

    @Override
    public HardSoftScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(HardSoftScore score) {
        this.score = score;
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        ArrayList<Comparable<AbstractPersistable>> facts = new ArrayList<Comparable<AbstractPersistable>>();
        facts.add(this.institutionParametrization);
        facts.addAll(this.topicList);
        facts.addAll(this.periodList);
        facts.addAll(this.roomList);
        facts.addAll(this.periodPenaltyList);
        facts.addAll(this.roomPenaltyList);
        facts.addAll(this.precalculateTopicConflictList());
        return facts;
    }

    private List<TopicConflict> precalculateTopicConflictList() {
        ArrayList<TopicConflict> topicConflictList = new ArrayList<TopicConflict>();
        for (Topic leftTopic : this.topicList) {
            for (Topic rightTopic : this.topicList) {
                if (leftTopic.getId() >= rightTopic.getId()) continue;
                int studentSize = 0;
                for (Student student : leftTopic.getStudentList()) {
                    if (!rightTopic.getStudentList().contains(student)) continue;
                    ++studentSize;
                }
                if (studentSize <= 0) continue;
                topicConflictList.add(new TopicConflict(leftTopic, rightTopic, studentSize));
            }
        }
        return topicConflictList;
    }

    @Override
    public Examination planningClone() {
        Examination clone = new Examination();
        clone.id = this.id;
        clone.institutionParametrization = this.institutionParametrization;
        clone.studentList = this.studentList;
        clone.topicList = this.topicList;
        clone.periodList = this.periodList;
        clone.roomList = this.roomList;
        clone.periodPenaltyList = this.periodPenaltyList;
        clone.roomPenaltyList = this.roomPenaltyList;
        ArrayList<Exam> clonedExamList = new ArrayList<Exam>(this.examList.size());
        for (Exam exam : this.examList) {
            Exam clonedExam = exam.planningClone();
            clonedExamList.add(clonedExam);
        }
        clone.examList = clonedExamList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof Examination)) {
            return false;
        }
        Examination other = (Examination)o;
        if (this.examList.size() != other.examList.size()) {
            return false;
        }
        Iterator<Exam> it = this.examList.iterator();
        Iterator<Exam> otherIt = other.examList.iterator();
        while (it.hasNext()) {
            Exam otherExam;
            Exam exam = it.next();
            if (exam.solutionEquals(otherExam = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (Exam exam : this.examList) {
            hashCodeBuilder.append(exam.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

