/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.solver.score;

import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.score.director.incremental.AbstractIncrementalScoreCalculator;
import org.optaplanner.examples.tsp.domain.Appearance;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;
import org.optaplanner.examples.tsp.domain.Visit;

public class TspIncrementalScoreCalculator
extends AbstractIncrementalScoreCalculator<TravelingSalesmanTour> {
    private Domicile domicile;
    private int score;

    @Override
    public void resetWorkingSolution(TravelingSalesmanTour tour) {
        if (tour.getDomicileList().size() != 1) {
            throw new UnsupportedOperationException("The domicileList (" + tour.getDomicileList() + ") should be a singleton.");
        }
        this.domicile = tour.getDomicileList().get(0);
        this.score = 0;
        for (Visit visit : tour.getVisitList()) {
            this.insert(visit);
        }
    }

    @Override
    public void beforeEntityAdded(Object entity) {
    }

    @Override
    public void afterEntityAdded(Object entity) {
        this.insert((Visit)entity);
    }

    @Override
    public void beforeAllVariablesChanged(Object entity) {
        this.retract((Visit)entity);
    }

    @Override
    public void afterAllVariablesChanged(Object entity) {
        this.insert((Visit)entity);
    }

    @Override
    public void beforeVariableChanged(Object entity, String variableName) {
        this.retract((Visit)entity);
    }

    @Override
    public void afterVariableChanged(Object entity, String variableName) {
        this.insert((Visit)entity);
    }

    @Override
    public void beforeEntityRemoved(Object entity) {
        this.retract((Visit)entity);
    }

    @Override
    public void afterEntityRemoved(Object entity) {
    }

    private void insert(Visit visit) {
        Appearance previousAppearance = visit.getPreviousAppearance();
        if (previousAppearance != null) {
            this.score -= visit.getDistanceToPreviousAppearance();
            this.score += this.domicile.getCity().getDistance(previousAppearance.getCity());
            this.score -= this.domicile.getCity().getDistance(visit.getCity());
        }
    }

    private void retract(Visit visit) {
        Appearance previousAppearance = visit.getPreviousAppearance();
        if (previousAppearance != null) {
            this.score += visit.getDistanceToPreviousAppearance();
            this.score -= this.domicile.getCity().getDistance(previousAppearance.getCity());
            this.score += this.domicile.getCity().getDistance(visit.getCity());
        }
    }

    @Override
    public SimpleScore calculateScore() {
        return SimpleScore.valueOf(this.score);
    }
}

