/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.index.LeftTupleList;
import org.kie.api.runtime.Calendars;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhreakTimerNode {
    private static final Logger log = LoggerFactory.getLogger(PhreakTimerNode.class);

    public void doNode(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(timerNode, tm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(timerNode, tm, pmem, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(timerNode, tm, pmem, sink, wm, srcLeftTuples, trgLeftTuples);
        }
        this.doPropagateChildLeftTuples(timerNode, tm, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
        Timer timer = timerNode.getTimer();
        TimerService timerService = wm.getTimerService();
        long timestamp = timerService.getCurrentTime();
        String[] calendarNames = timerNode.getCalendarNames();
        Calendars calendars = wm.getCalendars();
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            this.scheduleLeftTuple(timerNode, tm, pmem, sink, wm, timer, timerService, timestamp, calendarNames, calendars, leftTuple, trgLeftTuples, null);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftUpdates(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        Timer timer = timerNode.getTimer();
        TimerService timerService = wm.getTimerService();
        long timestamp = timerService.getCurrentTime();
        String[] calendarNames = timerNode.getCalendarNames();
        Calendars calendars = wm.getCalendars();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            DefaultJobHandle jobHandle = (DefaultJobHandle)leftTuple.getObject();
            timerService.removeJob(jobHandle);
            this.scheduleLeftTuple(timerNode, tm, pmem, sink, wm, timer, timerService, timestamp, calendarNames, calendars, leftTuple, trgLeftTuples, stagedLeftTuples);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLeftDeletes(TimerNode timerNode, TimerNode.TimerNodeMemory tm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        LeftTupleList leftTuples;
        TimerService timerService = wm.getTimerService();
        LeftTupleList leftTupleList = leftTuples = tm.getLeftTuples();
        synchronized (leftTupleList) {
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple childLeftTuple;
                LeftTuple next = leftTuple.getStagedNext();
                DefaultJobHandle jobHandle = (DefaultJobHandle)leftTuple.getObject();
                timerService.removeJob(jobHandle);
                if (leftTuple.getMemory() != null) {
                    leftTuples.remove(leftTuple);
                }
                if ((childLeftTuple = leftTuple.getFirstChild()) != null) {
                    switch (childLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(childLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(childLeftTuple);
                        }
                    }
                    trgLeftTuples.addDelete(childLeftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }
    }

    private void scheduleLeftTuple(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, LeftTupleSink sink, InternalWorkingMemory wm, Timer timer, TimerService timerService, long timestamp, String[] calendarNames, Calendars calendars, LeftTuple leftTuple, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        DefaultJobHandle jobHandle = (DefaultJobHandle)leftTuple.getObject();
        Trigger trigger = timer.createTrigger(timestamp, leftTuple, jobHandle, calendarNames, calendars, timerNode.getDeclarations(), wm);
        if (trigger.hasNextFireTime().getTime() <= timestamp) {
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            if (childLeftTuple == null) {
                childLeftTuple = sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true);
                trgLeftTuples.addInsert(childLeftTuple);
            } else {
                switch (childLeftTuple.getStagedType()) {
                    case 1: {
                        stagedLeftTuples.removeInsert(childLeftTuple);
                        break;
                    }
                    case 2: {
                        stagedLeftTuples.removeUpdate(childLeftTuple);
                    }
                }
                trgLeftTuples.addUpdate(childLeftTuple);
            }
            trigger.nextFireTime();
            if (trigger.hasNextFireTime().getTime() <= timestamp) {
                throw new IllegalStateException("Trigger.nextFireTime is not increasing");
            }
        }
        TimerNodeJob job = new TimerNodeJob();
        TimerNodeJobContext jobCtx = new TimerNodeJobContext(trigger, leftTuple, tm, sink, pmem, wm);
        jobHandle = (DefaultJobHandle)timerService.scheduleJob(job, jobCtx, trigger);
        leftTuple.setObject(jobHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPropagateChildLeftTuples(TimerNode timerNode, TimerNode.TimerNodeMemory tm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        LeftTupleList leftTuples;
        LeftTupleList leftTupleList = leftTuples = tm.getLeftTuples();
        synchronized (leftTupleList) {
            LeftTuple leftTuple = leftTuples.getFirst();
            while (leftTuple != null) {
                LeftTuple next = (LeftTuple)leftTuple.getNext();
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                if (childLeftTuple == null) {
                    childLeftTuple = sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true);
                    trgLeftTuples.addInsert(childLeftTuple);
                } else {
                    switch (childLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(childLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(childLeftTuple);
                        }
                    }
                    trgLeftTuples.addUpdate(childLeftTuple);
                }
                leftTuple.clear();
                leftTuple = next;
            }
            leftTuples.clear();
        }
    }

    public static class TimerNodeJobContext
    implements JobContext {
        private JobHandle jobHandle;
        private Trigger trigger;
        private LeftTuple leftTuple;
        private TimerNode.TimerNodeMemory tm;
        private LeftTupleSink sink;
        private PathMemory pmem;
        private InternalWorkingMemory wm;

        public TimerNodeJobContext(Trigger trigger, LeftTuple leftTuple, TimerNode.TimerNodeMemory tm, LeftTupleSink sink, PathMemory pmem, InternalWorkingMemory wm) {
            this.trigger = trigger;
            this.leftTuple = leftTuple;
            this.sink = sink;
            this.pmem = pmem;
            this.tm = tm;
            this.wm = wm;
        }

        @Override
        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public LeftTupleSink getSink() {
            return this.sink;
        }

        public LeftTuple getLeftTuple() {
            return this.leftTuple;
        }

        public TimerNode.TimerNodeMemory getTimerNodeMemory() {
            return this.tm;
        }

        public PathMemory getPathMemory() {
            return this.pmem;
        }

        public InternalWorkingMemory getWorkingMemory() {
            return this.wm;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }
    }

    public static class TimerNodeJob
    implements Job {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(JobContext ctx) {
            TimerNodeJobContext timerJobCtx = (TimerNodeJobContext)ctx;
            Trigger trigger = timerJobCtx.getTrigger();
            PathMemory pmem = timerJobCtx.getPathMemory();
            pmem.doLinkRule(timerJobCtx.getWorkingMemory());
            LeftTupleList leftTuples = timerJobCtx.getTimerNodeMemory().getLeftTuples();
            LeftTuple lt = timerJobCtx.getLeftTuple();
            log.trace("Timer Executor {} {}", (Object)timerJobCtx.getTrigger(), (Object)lt);
            LeftTupleList leftTupleList = leftTuples;
            synchronized (leftTupleList) {
                if (lt.getMemory() == null) {
                    leftTuples.add(lt);
                }
            }
            pmem.queueRuleAgendaItem(timerJobCtx.getWorkingMemory());
        }
    }
}

