/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleIterator;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextImpl;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.EvalNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeSet;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EvalCondition;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.RuleComponent;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.kie.api.definition.rule.Rule;

public class EvalConditionNode
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory {
    private static final long serialVersionUID = 510L;
    private EvalCondition condition;
    protected boolean tupleMemoryEnabled;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public EvalConditionNode() {
    }

    public EvalConditionNode(int id, LeftTupleSource tupleSource, EvalCondition eval, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.condition = eval;
        this.setLeftTupleSource(tupleSource);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.initMasks(context, tupleSource);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.condition = (EvalCondition)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.condition);
        out.writeBoolean(this.tupleMemoryEnabled);
    }

    @Override
    public void attach(BuildContext context) {
        this.leftInput.addTupleSink(this, context);
        if (context == null || context.getRuleBase().getConfiguration().isPhreakEnabled()) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.leftInput.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    public EvalCondition getCondition() {
        return this.condition;
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        EvalMemory memory = (EvalMemory)workingMemory.getNodeMemory(this);
        boolean allowed = this.condition.isAllowed(leftTuple, workingMemory, memory.context);
        if (allowed) {
            Object object;
            boolean useLeftMemory = true;
            if (!(this.tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
                useLeftMemory = false;
            }
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, useLeftMemory);
        }
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (leftTuple.getFirstChild() != null) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        }
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        EvalMemory memory = (EvalMemory)workingMemory.getNodeMemory(this);
        boolean wasPropagated = leftTuple.getFirstChild() != null;
        boolean allowed = this.condition.isAllowed(leftTuple, workingMemory, memory.context);
        if (allowed) {
            if (wasPropagated) {
                this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            } else {
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
        } else if (wasPropagated) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        }
    }

    @Override
    public String toString() {
        return "[EvalConditionNode: cond=" + this.condition + "]";
    }

    @Override
    public int hashCode() {
        return this.leftInput.hashCode() ^ this.condition.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != EvalConditionNode.class) {
            return false;
        }
        EvalConditionNode other = (EvalConditionNode)object;
        return this.leftInput.equals(other.leftInput) && this.condition.equals(other.condition);
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return new EvalMemory(this.condition.createContext());
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        EvalNodeLeftTuple peer = new EvalNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleIterator it = LeftTupleIterator.iterator(workingMemory, this);
        LeftTuple leftTuple = (LeftTuple)it.next();
        while (leftTuple != null) {
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                RightTuple rightParent = childLeftTuple.getRightParent();
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, rightParent, childLeftTuple, null, sink, true), context, workingMemory);
                while (childLeftTuple != null && childLeftTuple.getRightParent() == rightParent) {
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
            }
            leftTuple = (LeftTuple)it.next();
        }
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            if (!context.getRuleBase().getConfiguration().isPhreakEnabled()) {
                for (InternalWorkingMemory workingMemory : workingMemories) {
                    workingMemory.clearNodeMemory(this);
                }
            }
            this.getLeftTupleSource().removeTupleSink(this);
        } else {
            Map.Entry<Rule, RuleComponent> next = this.getAssociations().entrySet().iterator().next();
            this.condition = (EvalCondition)next.getValue();
        }
    }

    @Override
    protected void doCollectAncestors(NodeSet nodeSet) {
        this.getLeftTupleSource().collectAncestors(nodeSet);
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 131;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        return new EvalNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    public static class EvalMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Externalizable,
    Memory {
        private static final long serialVersionUID = 510L;
        public Object context;
        private SegmentMemory memory;

        public EvalMemory() {
        }

        public EvalMemory(Object context) {
            this.context = context;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
        }

        @Override
        public short getNodeType() {
            return 131;
        }

        @Override
        public void setSegmentMemory(SegmentMemory smem) {
            this.memory = smem;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.memory;
        }
    }
}

