/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.mimic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.AbstractEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;

public class MimicRecordingEntitySelector
extends AbstractEntitySelector {
    protected final EntitySelector childEntitySelector;
    protected final List<MimicReplayingEntitySelector> replayingEntitySelectorList;

    public MimicRecordingEntitySelector(EntitySelector childEntitySelector) {
        this.childEntitySelector = childEntitySelector;
        this.solverPhaseLifecycleSupport.addEventListener(childEntitySelector);
        this.replayingEntitySelectorList = new ArrayList<MimicReplayingEntitySelector>();
    }

    public void addMimicReplayingEntitySelector(MimicReplayingEntitySelector replayingEntitySelector) {
        this.replayingEntitySelectorList.add(replayingEntitySelector);
    }

    @Override
    public PlanningEntityDescriptor getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public boolean isContinuous() {
        return this.childEntitySelector.isContinuous();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childEntitySelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.childEntitySelector.getSize();
    }

    @Override
    public Iterator<Object> iterator() {
        return new RecordingEntityIterator(this.childEntitySelector.iterator());
    }

    @Override
    public Iterator<Object> endingIterator() {
        return this.childEntitySelector.endingIterator();
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "Recording(" + this.childEntitySelector + ")";
    }

    private class RecordingEntityIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> childEntityIterator;

        public RecordingEntityIterator(Iterator<Object> childEntityIterator) {
            this.childEntityIterator = childEntityIterator;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.childEntityIterator.hasNext();
            for (MimicReplayingEntitySelector replayingEntitySelector : MimicRecordingEntitySelector.this.replayingEntitySelectorList) {
                replayingEntitySelector.recordedHasNext(hasNext);
            }
            return hasNext;
        }

        @Override
        public Object next() {
            Object next = this.childEntityIterator.next();
            for (MimicReplayingEntitySelector replayingEntitySelector : MimicRecordingEntitySelector.this.replayingEntitySelectorList) {
                replayingEntitySelector.recordedNext(next);
            }
            return next;
        }
    }
}

