/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.incremental;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreCalculator;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreDirectorFactory;
import org.optaplanner.core.impl.solution.Solution;

public class IncrementalScoreDirector
extends AbstractScoreDirector<IncrementalScoreDirectorFactory> {
    private final IncrementalScoreCalculator incrementalScoreCalculator;

    public IncrementalScoreDirector(IncrementalScoreDirectorFactory scoreDirectorFactory, IncrementalScoreCalculator incrementalScoreCalculator) {
        super(scoreDirectorFactory);
        this.incrementalScoreCalculator = incrementalScoreCalculator;
    }

    public IncrementalScoreCalculator getIncrementalScoreCalculator() {
        return this.incrementalScoreCalculator;
    }

    @Override
    public void setWorkingSolution(Solution workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.incrementalScoreCalculator.resetWorkingSolution(workingSolution);
    }

    @Override
    public Score calculateScore() {
        Score score = this.incrementalScoreCalculator.calculateScore();
        this.setCalculatedScore(score);
        return score;
    }

    @Override
    public void beforeEntityAdded(PlanningEntityDescriptor entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.beforeEntityAdded(entity);
        super.beforeEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterEntityAdded(PlanningEntityDescriptor entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.afterEntityAdded(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void beforeVariableChanged(PlanningVariableDescriptor variableDescriptor, Object entity) {
        this.incrementalScoreCalculator.beforeVariableChanged(entity, variableDescriptor.getVariableName());
        super.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(PlanningVariableDescriptor variableDescriptor, Object entity) {
        this.incrementalScoreCalculator.afterVariableChanged(entity, variableDescriptor.getVariableName());
        super.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void beforeShadowVariableChanged(Object entity, String variableName) {
        this.incrementalScoreCalculator.beforeVariableChanged(entity, variableName);
        super.beforeShadowVariableChanged(entity, variableName);
    }

    @Override
    public void afterShadowVariableChanged(Object entity, String variableName) {
        this.incrementalScoreCalculator.afterVariableChanged(entity, variableName);
        super.afterShadowVariableChanged(entity, variableName);
    }

    @Override
    public void beforeEntityRemoved(PlanningEntityDescriptor entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.beforeEntityRemoved(entity);
        super.beforeEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterEntityRemoved(PlanningEntityDescriptor entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.afterEntityRemoved(entity);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
        super.beforeProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void beforeProblemFactChanged(Object problemFact) {
        super.beforeProblemFactChanged(problemFact);
    }

    @Override
    public void afterProblemFactChanged(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
        super.afterProblemFactChanged(problemFact);
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
        super.beforeProblemFactRemoved(problemFact);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
        super.afterProblemFactRemoved(problemFact);
    }

    @Override
    protected String buildScoreCorruptionAnalysis(ScoreDirector uncorruptedScoreDirector) {
        if (!(uncorruptedScoreDirector instanceof IncrementalScoreDirector)) {
            return "Unable to analyze: the uncorruptedScoreDirector class (" + uncorruptedScoreDirector.getClass() + ") is not an instance of the scoreDirector class (" + IncrementalScoreDirector.class + ").";
        }
        IncrementalScoreDirector uncorruptedIncrementalScoreDirector = (IncrementalScoreDirector)uncorruptedScoreDirector;
        return this.incrementalScoreCalculator.buildScoreCorruptionAnalysis(uncorruptedIncrementalScoreDirector.incrementalScoreCalculator);
    }
}

