/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.pas.domain.Bed;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.solver.move.PatientAdmissionMoveHelper;

public class BedDesignationSwapMove
implements Move {
    private BedDesignation leftBedDesignation;
    private BedDesignation rightBedDesignation;

    public BedDesignationSwapMove(BedDesignation leftBedDesignation, BedDesignation rightBedDesignation) {
        this.leftBedDesignation = leftBedDesignation;
        this.rightBedDesignation = rightBedDesignation;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.leftBedDesignation.getBed(), (Object)this.rightBedDesignation.getBed());
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new BedDesignationSwapMove(this.rightBedDesignation, this.leftBedDesignation);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        Bed oldLeftBed = this.leftBedDesignation.getBed();
        Bed oldRightBed = this.rightBedDesignation.getBed();
        PatientAdmissionMoveHelper.moveBed(scoreDirector, this.leftBedDesignation, oldRightBed);
        PatientAdmissionMoveHelper.moveBed(scoreDirector, this.rightBedDesignation, oldLeftBed);
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftBedDesignation, this.rightBedDesignation);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftBedDesignation.getBed(), this.rightBedDesignation.getBed());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BedDesignationSwapMove) {
            BedDesignationSwapMove other = (BedDesignationSwapMove)o;
            return new EqualsBuilder().append((Object)this.leftBedDesignation, (Object)other.leftBedDesignation).append((Object)this.rightBedDesignation, (Object)other.rightBedDesignation).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftBedDesignation).append((Object)this.rightBedDesignation).toHashCode();
    }

    public String toString() {
        return this.leftBedDesignation + " <=> " + this.rightBedDesignation;
    }
}

