/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.solver;

import org.optaplanner.core.impl.domain.variable.listener.PlanningVariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.VrpCustomer;
import org.optaplanner.examples.vehiclerouting.domain.VrpStandstill;
import org.optaplanner.examples.vehiclerouting.domain.VrpVehicle;

public class VehicleUpdatingVariableListener
implements PlanningVariableListener<VrpCustomer> {
    @Override
    public void beforeEntityAdded(ScoreDirector scoreDirector, VrpCustomer customer) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector scoreDirector, VrpCustomer customer) {
        this.updateVehicle(scoreDirector, customer);
    }

    @Override
    public void beforeVariableChanged(ScoreDirector scoreDirector, VrpCustomer customer) {
    }

    @Override
    public void afterVariableChanged(ScoreDirector scoreDirector, VrpCustomer customer) {
        this.updateVehicle(scoreDirector, customer);
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector scoreDirector, VrpCustomer customer) {
    }

    @Override
    public void afterEntityRemoved(ScoreDirector scoreDirector, VrpCustomer customer) {
    }

    protected void updateVehicle(ScoreDirector scoreDirector, VrpCustomer sourceCustomer) {
        VrpStandstill previousStandstill = sourceCustomer.getPreviousStandstill();
        VrpVehicle vehicle = previousStandstill == null ? null : previousStandstill.getVehicle();
        for (VrpCustomer shadowCustomer = sourceCustomer; shadowCustomer != null && shadowCustomer.getVehicle() != vehicle; shadowCustomer = shadowCustomer.getNextCustomer()) {
            scoreDirector.beforeVariableChanged(shadowCustomer, "vehicle");
            shadowCustomer.setVehicle(vehicle);
            scoreDirector.afterVariableChanged(shadowCustomer, "vehicle");
        }
    }
}

