/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.defeasible;

import java.util.Arrays;
import org.drools.core.beliefsystem.defeasible.DefeasibilityStatus;
import org.drools.core.beliefsystem.defeasible.Defeater;
import org.drools.core.beliefsystem.defeasible.Defeats;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.common.LogicalDependency;
import org.drools.core.spi.Activation;

public class DefeasibleLogicalDependency
extends SimpleLogicalDependency {
    public static final String DEFEATS = Defeats.class.getSimpleName();
    public static final String DEFEATER = Defeater.class.getSimpleName();
    private DefeasibilityStatus status;
    private String[] defeats;
    private DefeasibleLogicalDependency rootDefeated;
    private DefeasibleLogicalDependency tailDefeated;
    private DefeasibleLogicalDependency defeatedBy;
    private boolean isDefeater;

    public DefeasibleLogicalDependency(Activation justifier, Object justified) {
        super(justifier, justified);
        this.initDefeats();
    }

    public DefeasibleLogicalDependency(Activation justifier, Object justified, Object object, Object value) {
        super(justifier, justified, object, value);
        this.initDefeats();
    }

    private void initDefeats() {
        Object o = this.getJustifier().getRule().getMetaData().get(DEFEATER);
        if (o != null && !"FALSE".equals(((String)o).toUpperCase())) {
            this.isDefeater = true;
        }
        if ((o = this.getJustifier().getRule().getMetaData().get(DEFEATS)) != null) {
            if (o instanceof String) {
                this.defeats = new String[]{(String)o};
                Arrays.sort(this.defeats);
            } else if (o instanceof Object[]) {
                this.defeats = (String[])o;
                Arrays.sort(this.defeats);
            }
        }
    }

    public void addDefeated(DefeasibleLogicalDependency defeated) {
        defeated.setDefeatedBy(this);
        if (this.rootDefeated == null) {
            this.rootDefeated = defeated;
        } else {
            this.tailDefeated.setNext(defeated);
            defeated.setPrevious(this.rootDefeated);
        }
        this.tailDefeated = defeated;
    }

    public void removeDefeated(DefeasibleLogicalDependency defeated) {
        defeated.setDefeatedBy(null);
        if (this.rootDefeated == defeated) {
            this.removeFirst();
        } else if (this.tailDefeated == defeated) {
            this.removeLast();
        } else {
            ((LogicalDependency)defeated.getPrevious()).setNext(defeated.getNext());
            ((LogicalDependency)defeated.getNext()).setPrevious(defeated.getPrevious());
            defeated.nullPrevNext();
        }
    }

    public DefeasibleLogicalDependency removeFirst() {
        if (this.rootDefeated == null) {
            return null;
        }
        DefeasibleLogicalDependency node = this.rootDefeated;
        this.rootDefeated = (DefeasibleLogicalDependency)node.getNext();
        node.setNext(null);
        if (this.rootDefeated != null) {
            this.rootDefeated.setPrevious(null);
        } else {
            this.tailDefeated = null;
        }
        return node;
    }

    public DefeasibleLogicalDependency removeLast() {
        if (this.tailDefeated == null) {
            return null;
        }
        DefeasibleLogicalDependency node = this.tailDefeated;
        this.tailDefeated = (DefeasibleLogicalDependency)node.getPrevious();
        node.setPrevious(null);
        if (this.tailDefeated != null) {
            this.tailDefeated.setNext(null);
        } else {
            this.rootDefeated = this.tailDefeated;
        }
        return node;
    }

    public DefeasibleLogicalDependency getRootDefeated() {
        return this.rootDefeated;
    }

    public DefeasibleLogicalDependency getTailDefeated() {
        return this.tailDefeated;
    }

    public String[] getDefeats() {
        return this.defeats;
    }

    public DefeasibleLogicalDependency getDefeatedBy() {
        return this.defeatedBy;
    }

    public void setDefeatedBy(DefeasibleLogicalDependency defeatedBy) {
        this.defeatedBy = defeatedBy;
    }

    public DefeasibilityStatus getStatus() {
        return this.status;
    }

    public void setStatus(DefeasibilityStatus status) {
        this.status = status;
    }

    public boolean isDefeater() {
        return this.isDefeater;
    }

    public void setDefeater(boolean defeater) {
        this.isDefeater = defeater;
    }
}

