/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.InitialFact;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.ActivationIterator;
import org.drools.core.common.AgendaGroupQueueImpl;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleIterator;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.Memory;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.NodeMemories;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.QueryElementFactHandle;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProcessMarshaller;
import org.drools.core.marshalling.impl.ProcessMarshallerFactory;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.marshalling.impl.TimersOutputMarshaller;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.rule.Rule;
import org.drools.core.spi.Activation;
import org.drools.core.spi.AgendaGroup;
import org.drools.core.spi.RuleFlowGroup;
import org.drools.core.time.JobContext;
import org.drools.core.time.SelfRemovalJobContext;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.CronTrigger;
import org.drools.core.time.impl.IntervalTrigger;
import org.drools.core.time.impl.PointInTimeTrigger;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.core.time.impl.TimerJobInstance;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.ObjectHashMap;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.rule.EntryPoint;

public class ProtobufOutputMarshaller {
    private static ProcessMarshaller processMarshaller = ProtobufOutputMarshaller.createProcessMarshaller();

    private static ProcessMarshaller createProcessMarshaller() {
        try {
            return ProcessMarshallerFactory.newProcessMarshaller();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void writeSession(MarshallerWriteContext context) throws IOException {
        ProtobufMessages.KnowledgeSession _session = ProtobufOutputMarshaller.serializeSession(context);
        PersisterHelper.writeToStreamWithHeader(context, (Message)_session);
    }

    private static ProtobufMessages.KnowledgeSession serializeSession(MarshallerWriteContext context) throws IOException {
        ProtobufMessages.Timers _timers;
        AbstractWorkingMemory wm = (AbstractWorkingMemory)context.wm;
        wm.getAgenda().unstageActivations();
        ProtobufOutputMarshaller.evaluateRuleActivations(wm);
        ProtobufMessages.RuleData.Builder _ruleData = ProtobufMessages.RuleData.newBuilder();
        long time = 0L;
        if (context.wm.getTimerService() instanceof PseudoClockScheduler) {
            time = context.clockTime;
        }
        _ruleData.setLastId(wm.getFactHandleFactory().getId());
        _ruleData.setLastRecency(wm.getFactHandleFactory().getRecency());
        InternalFactHandle handle = context.wm.getInitialFactHandle();
        ProtobufMessages.FactHandle _ifh = ProtobufMessages.FactHandle.newBuilder().setType(ProtobufMessages.FactHandle.HandleType.INITIAL_FACT).setId(handle.getId()).setRecency(handle.getRecency()).build();
        _ruleData.setInitialFact(_ifh);
        ProtobufOutputMarshaller.writeAgenda(context, _ruleData);
        ProtobufOutputMarshaller.writeNodeMemories(context, _ruleData);
        for (WorkingMemoryEntryPoint wmep : wm.getEntryPoints().values()) {
            ProtobufMessages.EntryPoint.Builder _epb = ProtobufMessages.EntryPoint.newBuilder();
            _epb.setEntryPointId(wmep.getEntryPointId());
            ProtobufOutputMarshaller.writeFactHandles(context, _epb, ((NamedEntryPoint)wmep).getObjectStore());
            ProtobufOutputMarshaller.writeTruthMaintenanceSystem(context, wmep, _epb);
            _ruleData.addEntryPoint(_epb.build());
        }
        ProtobufOutputMarshaller.writeActionQueue(context, _ruleData);
        ProtobufMessages.KnowledgeSession.Builder _session = ProtobufMessages.KnowledgeSession.newBuilder().setMultithread(false).setTime(time).setRuleData(_ruleData.build());
        if (processMarshaller != null) {
            ProtobufMessages.ProcessData.Builder _pdata = ProtobufMessages.ProcessData.newBuilder();
            if (context.marshalProcessInstances) {
                context.parameterObject = _pdata;
                processMarshaller.writeProcessInstances(context);
            }
            if (context.marshalWorkItems) {
                context.parameterObject = _pdata;
                processMarshaller.writeWorkItems(context);
            }
            context.parameterObject = _pdata;
            processMarshaller.writeProcessTimers(context);
            _session.setProcessData(_pdata.build());
        }
        if ((_timers = ProtobufOutputMarshaller.writeTimers(context.wm.getTimerService().getTimerJobInstances(context.wm.getId()), context)) != null) {
            _session.setTimers(_timers);
        }
        return _session.build();
    }

    private static void evaluateRuleActivations(AbstractWorkingMemory wm) {
        boolean dirty = true;
        block0: while (dirty) {
            for (Activation activation : wm.getAgenda().getActivations()) {
                if (!activation.isRuleAgendaItem()) continue;
                ((RuleAgendaItem)activation).getRuleExecutor().reEvaluateNetwork(wm, null, false);
                ((RuleAgendaItem)activation).getRuleExecutor().removeRuleAgendaItemWhenEmpty(wm);
            }
            dirty = false;
            if (!((InternalRuleBase)wm.getRuleBase()).getConfiguration().isPhreakEnabled()) continue;
            for (Activation activation : wm.getAgenda().getActivations()) {
                if (!activation.isRuleAgendaItem() || !((RuleAgendaItem)activation).getRuleExecutor().isDirty()) continue;
                dirty = true;
                continue block0;
            }
        }
    }

    private static void writeAgenda(MarshallerWriteContext context, ProtobufMessages.RuleData.Builder _ksb) throws IOException {
        InternalWorkingMemory wm = context.wm;
        InternalAgenda agenda = (InternalAgenda)wm.getAgenda();
        ProtobufMessages.Agenda.Builder _ab = ProtobufMessages.Agenda.newBuilder();
        AgendaGroup[] agendaGroups = agenda.getAgendaGroupsMap().values().toArray(new AgendaGroup[agenda.getAgendaGroupsMap().size()]);
        Arrays.sort(agendaGroups, AgendaGroupSorter.instance);
        for (AgendaGroup ag : agendaGroups) {
            AgendaGroupQueueImpl group = (AgendaGroupQueueImpl)ag;
            ProtobufMessages.Agenda.AgendaGroup.Builder _agb = ProtobufMessages.Agenda.AgendaGroup.newBuilder();
            _agb.setName(group.getName()).setIsActive(group.isActive()).setIsAutoDeactivate(group.isAutoDeactivate()).setClearedForRecency(group.getClearedForRecency()).setHasRuleFlowLister(group.isRuleFlowListener()).setActivatedForRecency(group.getActivatedForRecency());
            Map<Long, String> nodeInstances = group.getNodeInstances();
            for (Map.Entry<Long, String> entry : nodeInstances.entrySet()) {
                ProtobufMessages.Agenda.AgendaGroup.NodeInstance.Builder _nib = ProtobufMessages.Agenda.AgendaGroup.NodeInstance.newBuilder();
                _nib.setProcessInstanceId(entry.getKey());
                _nib.setNodeInstanceId(entry.getValue());
                _agb.addNodeInstance(_nib.build());
            }
            _ab.addAgendaGroup(_agb.build());
        }
        ProtobufMessages.Agenda.FocusStack.Builder _fsb = ProtobufMessages.Agenda.FocusStack.newBuilder();
        java.util.LinkedList<AgendaGroup> focusStack = agenda.getStackList();
        for (AgendaGroup group : focusStack) {
            _fsb.addGroupName(group.getName());
        }
        _ab.setFocusStack(_fsb.build());
        org.drools.core.util.Iterator it = ActivationIterator.iterator(wm);
        ArrayList<Activation> dormant = new ArrayList<Activation>();
        Activation item = (Activation)it.next();
        while (item != null) {
            if (!item.isQueued()) {
                dormant.add(item);
            }
            item = (Activation)it.next();
        }
        Collections.sort(dormant, ActivationsSorter.INSTANCE);
        for (Activation activation : dormant) {
            _ab.addMatch(ProtobufOutputMarshaller.writeActivation(context, (AgendaItem)activation));
        }
        for (Activation activation : agenda.getActivations()) {
            if (!activation.isRuleAgendaItem()) continue;
            _ab.addRuleActivation(ProtobufOutputMarshaller.writeActivation(context, (AgendaItem)activation));
        }
        _ksb.setAgenda(_ab.build());
    }

    private static void writeNodeMemories(MarshallerWriteContext context, ProtobufMessages.RuleData.Builder _ksb) throws IOException {
        InternalWorkingMemory wm = context.wm;
        NodeMemories memories = wm.getNodeMemories();
        for (int i = 0; i < memories.length(); ++i) {
            Memory memory = memories.peekNodeMemory(i);
            if (memory == null) continue;
            ProtobufMessages.NodeMemory _node = null;
            switch (memory.getNodeType()) {
                case 211: {
                    _node = ProtobufOutputMarshaller.writeAccumulateNodeMemory(i, memory);
                    break;
                }
                case 71: {
                    _node = ProtobufOutputMarshaller.writeRIANodeMemory(i, memory);
                    break;
                }
                case 151: {
                    _node = ProtobufOutputMarshaller.writeFromNodeMemory(i, memory);
                    break;
                }
                case 165: {
                    _node = ProtobufOutputMarshaller.writeQueryElementNodeMemory(i, memory, wm);
                }
            }
            if (_node == null) continue;
            _ksb.addNodeMemory(_node);
        }
    }

    private static ProtobufMessages.NodeMemory writeAccumulateNodeMemory(int nodeId, Memory memory) {
        AccumulateNode.AccumulateMemory accmem = (AccumulateNode.AccumulateMemory)memory;
        if (accmem.betaMemory.getLeftTupleMemory().size() > 0) {
            ProtobufMessages.NodeMemory.AccumulateNodeMemory.Builder _accumulate = ProtobufMessages.NodeMemory.AccumulateNodeMemory.newBuilder();
            org.drools.core.util.Iterator tupleIter = accmem.betaMemory.getLeftTupleMemory().iterator();
            LeftTuple leftTuple = (LeftTuple)tupleIter.next();
            while (leftTuple != null) {
                AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                if (accctx.getResultFactHandle() != null) {
                    ProtobufMessages.FactHandle _handle = ProtobufMessages.FactHandle.newBuilder().setId(accctx.getResultFactHandle().getId()).setRecency(accctx.getResultFactHandle().getRecency()).build();
                    _accumulate.addContext(ProtobufMessages.NodeMemory.AccumulateNodeMemory.AccumulateContext.newBuilder().setTuple(PersisterHelper.createTuple(leftTuple)).setResultHandle(_handle).build());
                }
                leftTuple = (LeftTuple)tupleIter.next();
            }
            return ProtobufMessages.NodeMemory.newBuilder().setNodeId(nodeId).setNodeType(ProtobufMessages.NodeMemory.NodeType.ACCUMULATE).setAccumulate(_accumulate.build()).build();
        }
        return null;
    }

    private static ProtobufMessages.NodeMemory writeRIANodeMemory(int nodeId, Memory memory) {
        RightInputAdapterNode.RiaNodeMemory mem = (RightInputAdapterNode.RiaNodeMemory)memory;
        if (!mem.getMap().isEmpty()) {
            ProtobufMessages.NodeMemory.RIANodeMemory.Builder _ria = ProtobufMessages.NodeMemory.RIANodeMemory.newBuilder();
            org.drools.core.util.Iterator it = mem.getMap().iterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                LeftTuple leftTuple = (LeftTuple)entry.getKey();
                InternalFactHandle handle = (InternalFactHandle)entry.getValue();
                ProtobufMessages.FactHandle _handle = ProtobufMessages.FactHandle.newBuilder().setId(handle.getId()).setRecency(handle.getRecency()).build();
                _ria.addContext(ProtobufMessages.NodeMemory.RIANodeMemory.RIAContext.newBuilder().setTuple(PersisterHelper.createTuple(leftTuple)).setResultHandle(_handle).build());
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
            return ProtobufMessages.NodeMemory.newBuilder().setNodeId(nodeId).setNodeType(ProtobufMessages.NodeMemory.NodeType.RIA).setRia(_ria.build()).build();
        }
        return null;
    }

    private static ProtobufMessages.NodeMemory writeFromNodeMemory(int nodeId, Memory memory) {
        FromNode.FromMemory fromMemory = (FromNode.FromMemory)memory;
        if (fromMemory.betaMemory.getLeftTupleMemory().size() > 0) {
            ProtobufMessages.NodeMemory.FromNodeMemory.Builder _from = ProtobufMessages.NodeMemory.FromNodeMemory.newBuilder();
            org.drools.core.util.Iterator tupleIter = fromMemory.betaMemory.getLeftTupleMemory().iterator();
            LeftTuple leftTuple = (LeftTuple)tupleIter.next();
            while (leftTuple != null) {
                Map matches = (Map)leftTuple.getObject();
                ProtobufMessages.NodeMemory.FromNodeMemory.FromContext.Builder _context = ProtobufMessages.NodeMemory.FromNodeMemory.FromContext.newBuilder().setTuple(PersisterHelper.createTuple(leftTuple));
                for (RightTuple rightTuple : matches.values()) {
                    ProtobufMessages.FactHandle _handle = ProtobufMessages.FactHandle.newBuilder().setId(rightTuple.getFactHandle().getId()).setRecency(rightTuple.getFactHandle().getRecency()).build();
                    _context.addHandle(_handle);
                }
                _from.addContext(_context.build());
                leftTuple = (LeftTuple)tupleIter.next();
            }
            return ProtobufMessages.NodeMemory.newBuilder().setNodeId(nodeId).setNodeType(ProtobufMessages.NodeMemory.NodeType.FROM).setFrom(_from.build()).build();
        }
        return null;
    }

    private static ProtobufMessages.NodeMemory writeQueryElementNodeMemory(int nodeId, Memory memory, InternalWorkingMemory wm) {
        org.drools.core.util.Iterator<LeftTuple> it = LeftTupleIterator.iterator(wm, ((QueryElementNode.QueryElementNodeMemory)memory).getNode());
        ProtobufMessages.NodeMemory.QueryElementNodeMemory.Builder _query = ProtobufMessages.NodeMemory.QueryElementNodeMemory.newBuilder();
        LeftTuple leftTuple = it.next();
        while (leftTuple != null) {
            InternalFactHandle handle = (InternalFactHandle)leftTuple.getObject();
            ProtobufMessages.FactHandle _handle = ProtobufMessages.FactHandle.newBuilder().setId(handle.getId()).setRecency(handle.getRecency()).build();
            ProtobufMessages.NodeMemory.QueryElementNodeMemory.QueryContext.Builder _context = ProtobufMessages.NodeMemory.QueryElementNodeMemory.QueryContext.newBuilder().setTuple(PersisterHelper.createTuple(leftTuple)).setHandle(_handle);
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                RightTuple rightParent = childLeftTuple.getRightParent();
                _context.addResult(ProtobufMessages.FactHandle.newBuilder().setId(rightParent.getFactHandle().getId()).setRecency(rightParent.getFactHandle().getRecency()).build());
                while (childLeftTuple != null && childLeftTuple.getRightParent() == rightParent) {
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
            }
            _query.addContext(_context.build());
            leftTuple = it.next();
        }
        return _query.getContextCount() > 0 ? ProtobufMessages.NodeMemory.newBuilder().setNodeId(nodeId).setNodeType(ProtobufMessages.NodeMemory.NodeType.QUERY_ELEMENT).setQueryElement(_query.build()).build() : null;
    }

    public static void writeActionQueue(MarshallerWriteContext context, ProtobufMessages.RuleData.Builder _session) throws IOException {
        AbstractWorkingMemory wm = (AbstractWorkingMemory)context.wm;
        if (!wm.getActionQueue().isEmpty()) {
            ProtobufMessages.ActionQueue.Builder _queue = ProtobufMessages.ActionQueue.newBuilder();
            WorkingMemoryAction[] queue = wm.getActionQueue().toArray(new WorkingMemoryAction[wm.getActionQueue().size()]);
            for (int i = queue.length - 1; i >= 0; --i) {
                _queue.addAction(queue[i].serialize(context));
            }
            _session.setActionQueue(_queue.build());
        }
    }

    public static void writeTruthMaintenanceSystem(MarshallerWriteContext context, EntryPoint wmep, ProtobufMessages.EntryPoint.Builder _epb) throws IOException {
        TruthMaintenanceSystem tms = ((NamedEntryPoint)wmep).getTruthMaintenanceSystem();
        ObjectHashMap justifiedMap = tms.getEqualityKeyMap();
        if (!justifiedMap.isEmpty()) {
            EqualityKey[] keys = new EqualityKey[justifiedMap.size()];
            org.drools.core.util.Iterator it = justifiedMap.iterator();
            int i = 0;
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                EqualityKey key = (EqualityKey)entry.getKey();
                keys[i++] = key;
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
            Arrays.sort(keys, EqualityKeySorter.instance);
            ProtobufMessages.TruthMaintenanceSystem.Builder _tms = ProtobufMessages.TruthMaintenanceSystem.newBuilder();
            for (EqualityKey key : keys) {
                ProtobufMessages.EqualityKey.Builder _key = ProtobufMessages.EqualityKey.newBuilder();
                _key.setStatus(key.getStatus());
                _key.setHandleId(key.getFactHandle().getId());
                if (key.size() > 1) {
                    FastIterator keyIter = key.fastIterator();
                    DefaultFactHandle handle = (DefaultFactHandle)((DefaultFactHandle)key.getFirst()).getNext();
                    while (handle != null) {
                        _key.addOtherHandle(handle.getId());
                        handle = (DefaultFactHandle)keyIter.next(handle);
                    }
                }
                if (key.getBeliefSet() != null) {
                    ProtobufOutputMarshaller.writeBeliefSet(context, key.getBeliefSet(), _key);
                }
                _tms.addKey(_key.build());
            }
            _epb.setTms(_tms.build());
        }
    }

    private static void writeBeliefSet(MarshallerWriteContext context, BeliefSet beliefSet, ProtobufMessages.EqualityKey.Builder _key) throws IOException {
        ProtobufMessages.BeliefSet.Builder _beliefSet = ProtobufMessages.BeliefSet.newBuilder();
        _beliefSet.setHandleId(beliefSet.getFactHandle().getId());
        ObjectMarshallingStrategyStore objectMarshallingStrategyStore = context.objectMarshallingStrategyStore;
        FastIterator it = beliefSet.iterator();
        LinkedListEntry node = (LinkedListEntry)beliefSet.getFirst();
        while (node != null) {
            Integer index;
            ObjectMarshallingStrategy strategy;
            LogicalDependency belief = (LogicalDependency)node.getObject();
            ProtobufMessages.LogicalDependency.Builder _logicalDependency = ProtobufMessages.LogicalDependency.newBuilder();
            LogicalDependency dependency = (LogicalDependency)node.getObject();
            Activation activation = dependency.getJustifier();
            ProtobufMessages.Activation _activation = ProtobufMessages.Activation.newBuilder().setPackageName(activation.getRule().getPackage()).setRuleName(activation.getRule().getName()).setTuple(PersisterHelper.createTuple(activation.getTuple())).build();
            _logicalDependency.setActivation(_activation);
            if (belief.getObject() != null) {
                strategy = objectMarshallingStrategyStore.getStrategyObject(belief.getObject());
                index = context.getStrategyIndex(strategy);
                _logicalDependency.setObjectStrategyIndex(index);
                _logicalDependency.setObject(ByteString.copyFrom((byte[])strategy.marshal(context.strategyContext.get(strategy), (ObjectOutputStream)context, belief.getObject())));
            }
            if (belief.getValue() != null) {
                strategy = objectMarshallingStrategyStore.getStrategyObject(belief.getValue());
                index = context.getStrategyIndex(strategy);
                _logicalDependency.setValueStrategyIndex(index);
                _logicalDependency.setValue(ByteString.copyFrom((byte[])strategy.marshal(context.strategyContext.get(strategy), (ObjectOutputStream)context, belief.getValue())));
            }
            _beliefSet.addLogicalDependency(_logicalDependency.build());
            node = (LinkedListEntry)it.next(node);
        }
        _key.setBeliefSet(_beliefSet);
    }

    private static void writeFactHandles(MarshallerWriteContext context, ProtobufMessages.EntryPoint.Builder _epb, ObjectStore objectStore) throws IOException {
        ObjectMarshallingStrategyStore objectMarshallingStrategyStore = context.objectMarshallingStrategyStore;
        for (InternalFactHandle handle : ProtobufOutputMarshaller.orderFacts(objectStore)) {
            ProtobufMessages.FactHandle _handle = ProtobufOutputMarshaller.writeFactHandle(context, objectMarshallingStrategyStore, handle);
            _epb.addHandle(_handle);
        }
    }

    private static ProtobufMessages.FactHandle writeFactHandle(MarshallerWriteContext context, ObjectMarshallingStrategyStore objectMarshallingStrategyStore, InternalFactHandle handle) throws IOException {
        ProtobufMessages.FactHandle.Builder _handle = ProtobufMessages.FactHandle.newBuilder();
        _handle.setType(ProtobufOutputMarshaller.getHandleType(handle));
        _handle.setId(handle.getId());
        _handle.setRecency(handle.getRecency());
        if (_handle.getType() == ProtobufMessages.FactHandle.HandleType.EVENT) {
            EventFactHandle efh = (EventFactHandle)handle;
            _handle.setTimestamp(efh.getStartTimestamp());
            _handle.setDuration(efh.getDuration());
            _handle.setIsExpired(efh.isExpired());
            _handle.setActivationsCount(efh.getActivationsCount());
        }
        if (handle.getEqualityKey() != null && handle.getEqualityKey().getStatus() == 2) {
            _handle.setIsJustified(true);
        } else {
            _handle.setIsJustified(false);
        }
        Object object = handle.getObject();
        if (object != null) {
            ObjectMarshallingStrategy strategy = objectMarshallingStrategyStore.getStrategyObject(object);
            Integer index = context.getStrategyIndex(strategy);
            _handle.setStrategyIndex(index);
            _handle.setObject(ByteString.copyFrom((byte[])strategy.marshal(context.strategyContext.get(strategy), (ObjectOutputStream)context, object)));
        }
        return _handle.build();
    }

    private static ProtobufMessages.FactHandle.HandleType getHandleType(InternalFactHandle handle) {
        if (handle instanceof EventFactHandle) {
            return ProtobufMessages.FactHandle.HandleType.EVENT;
        }
        if (handle instanceof QueryElementFactHandle) {
            return ProtobufMessages.FactHandle.HandleType.QUERY;
        }
        if (handle.getObject() instanceof InitialFact) {
            return ProtobufMessages.FactHandle.HandleType.INITIAL_FACT;
        }
        return ProtobufMessages.FactHandle.HandleType.FACT;
    }

    public static InternalFactHandle[] orderFacts(ObjectStore objectStore) {
        int size = objectStore.size();
        InternalFactHandle[] handles = new InternalFactHandle[size];
        int i = 0;
        Iterator it = objectStore.iterateFactHandles();
        while (it.hasNext()) {
            handles[i++] = (InternalFactHandle)it.next();
        }
        Arrays.sort(handles, new HandleSorter());
        return handles;
    }

    public static InternalFactHandle[] orderFacts(List<InternalFactHandle> handlesList) {
        int size = handlesList.size();
        InternalFactHandle[] handles = handlesList.toArray(new InternalFactHandle[size]);
        Arrays.sort(handles, new HandleSorter());
        return handles;
    }

    public static ProtobufMessages.Activation writeActivation(MarshallerWriteContext context, AgendaItem agendaItem) {
        LinkedList<LogicalDependency> list;
        ProtobufMessages.Activation.Builder _activation = ProtobufMessages.Activation.newBuilder();
        Rule rule = agendaItem.getRule();
        _activation.setPackageName(rule.getPackage());
        _activation.setRuleName(rule.getName());
        _activation.setTuple(ProtobufOutputMarshaller.writeTuple(agendaItem.getTuple()));
        _activation.setSalience(agendaItem.getSalience());
        _activation.setIsActivated(agendaItem.isQueued());
        _activation.setEvaluated(agendaItem.isRuleAgendaItem());
        if (agendaItem.getActivationGroupNode() != null) {
            _activation.setActivationGroup(agendaItem.getActivationGroupNode().getActivationGroup().getName());
        }
        if (agendaItem.getFactHandle() != null) {
            _activation.setHandleId(agendaItem.getFactHandle().getId());
        }
        if ((list = agendaItem.getLogicalDependencies()) != null && !list.isEmpty()) {
            for (LogicalDependency node = list.getFirst(); node != null; node = (LogicalDependency)node.getNext()) {
                _activation.addLogicalDependency(((BeliefSet)node.getJustified()).getFactHandle().getId());
            }
        }
        return _activation.build();
    }

    public static ProtobufMessages.Tuple writeTuple(LeftTuple tuple) {
        ProtobufMessages.Tuple.Builder _tb = ProtobufMessages.Tuple.newBuilder();
        for (LeftTuple entry = tuple; entry != null; entry = entry.getParent()) {
            InternalFactHandle handle = entry.getLastHandle();
            _tb.addHandleId(handle.getId());
        }
        return _tb.build();
    }

    private static ProtobufMessages.Timers writeTimers(Collection<TimerJobInstance> timers, MarshallerWriteContext outCtx) {
        if (!timers.isEmpty()) {
            ArrayList<TimerJobInstance> sortedTimers = new ArrayList<TimerJobInstance>(timers);
            Collections.sort(sortedTimers, new Comparator<TimerJobInstance>(){

                @Override
                public int compare(TimerJobInstance o1, TimerJobInstance o2) {
                    return (int)(o1.getJobHandle().getId() - o2.getJobHandle().getId());
                }
            });
            ProtobufMessages.Timers.Builder _timers = ProtobufMessages.Timers.newBuilder();
            for (TimerJobInstance timer : sortedTimers) {
                JobContext jctx = ((SelfRemovalJobContext)timer.getJobContext()).getJobContext();
                TimersOutputMarshaller writer = outCtx.writersByClass.get(jctx.getClass());
                ProtobufMessages.Timers.Timer _timer = writer.serialize(jctx, outCtx);
                if (_timer == null) continue;
                _timers.addTimer(_timer);
            }
            return _timers.build();
        }
        return null;
    }

    public static ProtobufMessages.Trigger writeTrigger(Trigger trigger, MarshallerWriteContext outCtx) {
        if (trigger instanceof CronTrigger) {
            CronTrigger cronTrigger = (CronTrigger)trigger;
            ProtobufMessages.Trigger.CronTrigger.Builder _cron = ProtobufMessages.Trigger.CronTrigger.newBuilder().setStartTime(cronTrigger.getStartTime().getTime()).setRepeatLimit(cronTrigger.getRepeatLimit()).setRepeatCount(cronTrigger.getRepeatCount()).setCronExpression(cronTrigger.getCronEx().getCronExpression());
            if (cronTrigger.getEndTime() != null) {
                _cron.setEndTime(cronTrigger.getEndTime().getTime());
            }
            if (cronTrigger.getNextFireTime() != null) {
                _cron.setNextFireTime(cronTrigger.getNextFireTime().getTime());
            }
            if (cronTrigger.getCalendarNames() != null) {
                for (String calendarName : cronTrigger.getCalendarNames()) {
                    _cron.addCalendarName(calendarName);
                }
            }
            return ProtobufMessages.Trigger.newBuilder().setType(ProtobufMessages.Trigger.TriggerType.CRON).setCron(_cron.build()).build();
        }
        if (trigger instanceof IntervalTrigger) {
            IntervalTrigger intTrigger = (IntervalTrigger)trigger;
            ProtobufMessages.Trigger.IntervalTrigger.Builder _interval = ProtobufMessages.Trigger.IntervalTrigger.newBuilder().setStartTime(intTrigger.getStartTime().getTime()).setRepeatLimit(intTrigger.getRepeatLimit()).setRepeatCount(intTrigger.getRepeatCount()).setPeriod(intTrigger.getPeriod());
            if (intTrigger.getEndTime() != null) {
                _interval.setEndTime(intTrigger.getEndTime().getTime());
            }
            if (intTrigger.getNextFireTime() != null) {
                _interval.setNextFireTime(intTrigger.getNextFireTime().getTime());
            }
            if (intTrigger.getCalendarNames() != null) {
                for (String calendarName : intTrigger.getCalendarNames()) {
                    _interval.addCalendarName(calendarName);
                }
            }
            return ProtobufMessages.Trigger.newBuilder().setType(ProtobufMessages.Trigger.TriggerType.INTERVAL).setInterval(_interval.build()).build();
        }
        if (trigger instanceof PointInTimeTrigger) {
            PointInTimeTrigger pinTrigger = (PointInTimeTrigger)trigger;
            return ProtobufMessages.Trigger.newBuilder().setType(ProtobufMessages.Trigger.TriggerType.POINT_IN_TIME).setPit(ProtobufMessages.Trigger.PointInTimeTrigger.newBuilder().setNextFireTime(pinTrigger.hasNextFireTime().getTime()).build()).build();
        }
        throw new RuntimeException("Unable to serialize Trigger for type: " + trigger.getClass());
    }

    public static class ActivationsSorter
    implements Comparator<Activation> {
        public static final ActivationsSorter INSTANCE = new ActivationsSorter();

        @Override
        public int compare(Activation o1, Activation o2) {
            int result = o1.getRule().getName().compareTo(o2.getRule().getName());
            if (result == 0) {
                LeftTuple t1 = o1.getTuple();
                for (LeftTuple t2 = o2.getTuple(); result == 0 && t1 != null && t2 != null; t1 = t1.getParent(), t2 = t2.getParent()) {
                    result = t1.getLastHandle().getId() - t2.getLastHandle().getId();
                }
            }
            return result;
        }
    }

    public static class HandleSorter
    implements Comparator<InternalFactHandle> {
        @Override
        public int compare(InternalFactHandle h1, InternalFactHandle h2) {
            return h1.getId() - h2.getId();
        }
    }

    public static class EqualityKeySorter
    implements Comparator<EqualityKey> {
        public static final EqualityKeySorter instance = new EqualityKeySorter();

        @Override
        public int compare(EqualityKey key1, EqualityKey key2) {
            return key1.getFactHandle().getId() - key2.getFactHandle().getId();
        }
    }

    private static class RuleFlowGroupSorter
    implements Comparator<RuleFlowGroup> {
        public static final RuleFlowGroupSorter instance = new RuleFlowGroupSorter();

        private RuleFlowGroupSorter() {
        }

        @Override
        public int compare(RuleFlowGroup group1, RuleFlowGroup group2) {
            return group1.getName().compareTo(group2.getName());
        }
    }

    private static class AgendaGroupSorter
    implements Comparator<AgendaGroup> {
        public static final AgendaGroupSorter instance = new AgendaGroupSorter();

        private AgendaGroupSorter() {
        }

        @Override
        public int compare(AgendaGroup group1, AgendaGroup group2) {
            return group1.getName().compareTo(group2.getName());
        }
    }
}

