/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.app;

import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.solver.XmlSolverFactory;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.examination.persistence.ExaminationDao;
import org.optaplanner.examples.examination.persistence.ExaminationExporter;
import org.optaplanner.examples.examination.persistence.ExaminationImporter;
import org.optaplanner.examples.examination.swingui.ExaminationPanel;

public class ExaminationApp
extends CommonApp {
    public static final String SOLVER_CONFIG = "/org/optaplanner/examples/examination/solver/examinationSolverConfig.xml";

    public static void main(String[] args) {
        ExaminationApp.fixateLookAndFeel();
        new ExaminationApp().init();
    }

    public ExaminationApp() {
        super("Exam timetabling", "Official competition name: ITC 2007 track1 - Examination timetabling\n\nAssign exams to timeslots and rooms.", "/org/optaplanner/examples/examination/swingui/examinationLogo.png");
    }

    @Override
    protected Solver createSolver() {
        XmlSolverFactory solverFactory = new XmlSolverFactory();
        solverFactory.configure(SOLVER_CONFIG);
        return solverFactory.buildSolver();
    }

    @Override
    protected SolutionPanel createSolutionPanel() {
        return new ExaminationPanel();
    }

    @Override
    protected SolutionDao createSolutionDao() {
        return new ExaminationDao();
    }

    @Override
    protected AbstractSolutionImporter createSolutionImporter() {
        return new ExaminationImporter();
    }

    @Override
    protected AbstractSolutionExporter createSolutionExporter() {
        return new ExaminationExporter();
    }
}

