/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.decorator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public abstract class AbstractCachingMoveSelector
extends AbstractMoveSelector
implements SelectionCacheLifecycleListener {
    protected final MoveSelector childMoveSelector;
    protected final SelectionCacheType cacheType;
    protected List<Move> cachedMoveList = null;

    public AbstractCachingMoveSelector(MoveSelector childMoveSelector, SelectionCacheType cacheType) {
        this.childMoveSelector = childMoveSelector;
        this.cacheType = cacheType;
        if (childMoveSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has a childMoveSelector (" + childMoveSelector + ") with neverEnding (" + childMoveSelector.isNeverEnding() + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(childMoveSelector);
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + (Object)((Object)cacheType) + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    public MoveSelector getChildMoveSelector() {
        return this.childMoveSelector;
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        long childSize = this.childMoveSelector.getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + this + ") has a childMoveSelector (" + this.childMoveSelector + ") with childSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        this.cachedMoveList = new ArrayList<Move>((int)childSize);
        CollectionUtils.addAll(this.cachedMoveList, this.childMoveSelector.iterator());
        this.logger.trace("    Created cachedMoveList with size ({}) in moveSelector({}).", (Object)this.cachedMoveList.size(), (Object)this);
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.cachedMoveList = null;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public long getSize() {
        return this.cachedMoveList.size();
    }
}

