/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedMoveUtils;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SubChainSwapMove
implements Move {
    private final PlanningVariableDescriptor variableDescriptor;
    private final SubChain leftSubChain;
    private final SubChain rightSubChain;

    public SubChainSwapMove(PlanningVariableDescriptor variableDescriptor, SubChain leftSubChain, SubChain rightSubChain) {
        this.variableDescriptor = variableDescriptor;
        this.leftSubChain = leftSubChain;
        this.rightSubChain = rightSubChain;
    }

    public SubChain getLeftSubChain() {
        return this.leftSubChain;
    }

    public SubChain getRightSubChain() {
        return this.rightSubChain;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        for (Object leftEntity : this.leftSubChain.getEntityList()) {
            if (!this.rightSubChain.getEntityList().contains(leftEntity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new SubChainSwapMove(this.variableDescriptor, this.rightSubChain, this.leftSubChain);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        Object oldLeftValue = this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity());
        Object oldRightValue = this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity());
        if (oldRightValue != this.leftSubChain.getLastEntity()) {
            ChainedMoveUtils.doSubChainChange(scoreDirector, this.leftSubChain, this.variableDescriptor, oldRightValue);
        }
        if (oldLeftValue != this.rightSubChain.getLastEntity()) {
            ChainedMoveUtils.doSubChainChange(scoreDirector, this.rightSubChain, this.variableDescriptor, oldLeftValue);
        }
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        ArrayList<Object> entities = new ArrayList<Object>(this.leftSubChain.getSize() + this.rightSubChain.getSize());
        entities.addAll(this.leftSubChain.getEntityList());
        entities.addAll(this.rightSubChain.getEntityList());
        return entities;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(2);
        values.add(this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity()));
        values.add(this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity()));
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubChainSwapMove) {
            SubChainSwapMove other = (SubChainSwapMove)o;
            return new EqualsBuilder().append((Object)this.variableDescriptor, (Object)other.variableDescriptor).append((Object)this.leftSubChain, (Object)other.leftSubChain).append((Object)this.rightSubChain, (Object)other.rightSubChain).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.variableDescriptor).append((Object)this.leftSubChain).append((Object)this.rightSubChain).toHashCode();
    }

    public String toString() {
        return this.leftSubChain + " <=> " + this.rightSubChain;
    }
}

