/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.variable;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedChangeMove;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningValueSelector;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.step.AbstractStepScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

@Deprecated
public class PlanningValueWalker
implements SolverPhaseLifecycleListener {
    private final PlanningVariableDescriptor variableDescriptor;
    private final PlanningValueSelector planningValueSelector;
    private ScoreDirector scoreDirector;
    private Object planningEntity;
    private Iterator<?> planningValueIterator;
    private boolean isFirstValue;
    private Object workingValue;

    public PlanningValueWalker(PlanningVariableDescriptor variableDescriptor, PlanningValueSelector planningValueSelector) {
        this.variableDescriptor = variableDescriptor;
        this.planningValueSelector = planningValueSelector;
    }

    public PlanningVariableDescriptor getVariableDescriptor() {
        return this.variableDescriptor;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        this.planningValueSelector.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        this.planningValueSelector.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void stepStarted(AbstractStepScope stepScope) {
        this.planningValueSelector.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(AbstractStepScope stepScope) {
        this.planningValueSelector.stepEnded(stepScope);
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        this.planningValueSelector.phaseEnded(phaseScope);
        this.scoreDirector = null;
        this.planningEntity = null;
        this.isFirstValue = false;
        this.workingValue = null;
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        this.planningValueSelector.solvingEnded(solverScope);
    }

    public void initWalk(Object planningEntity) {
        this.planningEntity = planningEntity;
        this.planningValueIterator = this.planningValueSelector.iterator(planningEntity);
        if (!this.planningValueIterator.hasNext()) {
            throw new IllegalStateException("The planningEntity (" + planningEntity + ") has a planning variable (" + this.variableDescriptor.getVariableName() + ") which has no planning values.");
        }
        Object value = this.planningValueIterator.next();
        this.scoreDirector.beforeVariableChanged(planningEntity, this.variableDescriptor.getVariableName());
        this.variableDescriptor.setValue(planningEntity, value);
        this.scoreDirector.afterVariableChanged(planningEntity, this.variableDescriptor.getVariableName());
        this.isFirstValue = true;
        this.workingValue = value;
    }

    public boolean hasWalk() {
        if (this.isFirstValue) {
            return true;
        }
        return this.planningValueIterator.hasNext();
    }

    public void walk() {
        if (this.isFirstValue) {
            this.isFirstValue = false;
        } else {
            Object value = this.planningValueIterator.next();
            this.changeWorkingValue(value);
        }
    }

    public void resetWalk() {
        this.planningValueIterator = this.planningValueSelector.iterator(this.planningEntity);
        Object value = this.planningValueIterator.next();
        this.changeWorkingValue(value);
        this.workingValue = value;
    }

    private void changeWorkingValue(Object value) {
        this.scoreDirector.beforeVariableChanged(this.planningEntity, this.variableDescriptor.getVariableName());
        this.variableDescriptor.setValue(this.planningEntity, value);
        this.scoreDirector.afterVariableChanged(this.planningEntity, this.variableDescriptor.getVariableName());
        this.workingValue = value;
    }

    public Iterator<Move> moveIterator(Object planningEntity) {
        Iterator<?> planningValueIterator = this.planningValueSelector.iterator(planningEntity);
        if (!this.variableDescriptor.isChained()) {
            return new ChangeMoveIterator(planningValueIterator, planningEntity);
        }
        return new ChainedChangeMoveIterator(planningValueIterator, planningEntity);
    }

    private class ChainedChangeMoveIterator
    extends ChangeMoveIterator {
        public ChainedChangeMoveIterator(Iterator<?> planningValueIterator, Object planningEntity) {
            super(planningValueIterator, planningEntity);
        }

        @Override
        public Move next() {
            Object toPlanningValue = this.planningValueIterator.next();
            return new ChainedChangeMove(this.planningEntity, PlanningValueWalker.this.variableDescriptor, toPlanningValue);
        }
    }

    private class ChangeMoveIterator
    extends SelectionIterator<Move> {
        protected final Iterator<?> planningValueIterator;
        protected final Object planningEntity;

        public ChangeMoveIterator(Iterator<?> planningValueIterator, Object planningEntity) {
            this.planningValueIterator = planningValueIterator;
            this.planningEntity = planningEntity;
        }

        @Override
        public boolean hasNext() {
            return this.planningValueIterator.hasNext();
        }

        @Override
        public Move next() {
            Object toPlanningValue = this.planningValueIterator.next();
            return new ChangeMove(this.planningEntity, PlanningValueWalker.this.variableDescriptor, toPlanningValue);
        }
    }
}

