/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.termination;

import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.termination.AbstractTermination;

public class TimeMillisSpendTermination
extends AbstractTermination {
    private long maximumTimeMillisSpend;

    public void setMaximumTimeMillisSpend(long maximumTimeMillisSpend) {
        this.maximumTimeMillisSpend = maximumTimeMillisSpend;
        if (maximumTimeMillisSpend <= 0L) {
            throw new IllegalArgumentException("Property maximumTimeMillisSpend (" + maximumTimeMillisSpend + ") must be greater than 0.");
        }
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        long solverTimeMillisSpend = solverScope.calculateTimeMillisSpend();
        return this.isTerminated(solverTimeMillisSpend);
    }

    @Override
    public boolean isPhaseTerminated(AbstractSolverPhaseScope phaseScope) {
        long phaseTimeMillisSpend = phaseScope.calculatePhaseTimeMillisSpend();
        return this.isTerminated(phaseTimeMillisSpend);
    }

    private boolean isTerminated(long timeMillisSpend) {
        return timeMillisSpend >= this.maximumTimeMillisSpend;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        long solverTimeMillisSpend = solverScope.calculateTimeMillisSpend();
        return this.calculateTimeGradient(solverTimeMillisSpend);
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope phaseScope) {
        long phaseTimeMillisSpend = phaseScope.calculatePhaseTimeMillisSpend();
        return this.calculateTimeGradient(phaseTimeMillisSpend);
    }

    private double calculateTimeGradient(double timeMillisSpend) {
        double timeGradient = timeMillisSpend / (double)this.maximumTimeMillisSpend;
        return Math.min(timeGradient, 1.0);
    }
}

