/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel.traits;

import java.io.Serializable;
import java.util.List;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.BuildUtils;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.TraitClassBuilder;
import org.mvel2.asm.AnnotationVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

public class TraitClassBuilderImpl
implements TraitClassBuilder,
Serializable {
    @Override
    public byte[] buildClass(ClassDefinition classDef) {
        this.init(classDef);
        ClassWriter cw = new ClassWriter(1);
        try {
            String[] tmp;
            String cName = BuildUtils.getInternalType(classDef.getClassName());
            String genericTypes = BuildUtils.getGenericTypes(classDef.getInterfaces());
            String superType = Type.getInternalName(Object.class);
            String[] intfaces = null;
            if (Object.class.getName().equals(classDef.getSuperClass())) {
                tmp = BuildUtils.getInternalTypes(classDef.getInterfaces());
                intfaces = new String[tmp.length + 1];
                System.arraycopy(tmp, 0, intfaces, 0, tmp.length);
                intfaces[tmp.length] = Type.getInternalName(Serializable.class);
            } else {
                tmp = BuildUtils.getInternalTypes(classDef.getInterfaces());
                intfaces = new String[tmp.length + 2];
                System.arraycopy(tmp, 0, intfaces, 0, tmp.length);
                intfaces[tmp.length] = BuildUtils.getInternalType(classDef.getSuperClass());
                intfaces[tmp.length + 1] = Type.getInternalName(Serializable.class);
            }
            cw.visit(50, 1537, cName, genericTypes, superType, intfaces);
            if (classDef.getDefinedClass() == null || classDef.getDefinedClass().getAnnotation(Trait.class) == null) {
                AnnotationVisitor av0 = cw.visitAnnotation(Type.getDescriptor(Trait.class), true);
                List<AnnotationDefinition> annotations = classDef.getAnnotations();
                if (annotations != null && !annotations.isEmpty()) {
                    for (AnnotationDefinition adef : annotations) {
                        if (!Trait.class.getName().equals(adef.getName())) continue;
                        if (adef.getPropertyValue("logical") != null) {
                            av0.visit("logical", (Object)((Boolean)adef.getPropertyValue("logical")));
                        }
                        if (adef.getPropertyValue("impl") == null) break;
                        av0.visit("impl", (Object)Type.getType((Class)((Class)adef.getPropertyValue("impl"))));
                        break;
                    }
                }
                av0.visitEnd();
            }
            for (FieldDefinition field : classDef.getFieldsDefinitions()) {
                this.buildField(cw, field);
            }
            this.finalizeCreation(classDef);
            cw.visitEnd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cw.toByteArray();
    }

    protected void init(ClassDefinition classDef) {
    }

    private void buildField(ClassWriter cw, FieldDefinition field) {
        String name = field.getName();
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        String type = field.getTypeName();
        this.buildGetter(cw, field, name, type, null);
        this.buildSetter(cw, field, name, type, null);
    }

    protected void buildSetter(ClassWriter cw, FieldDefinition field, String name, String type, String generic) {
        MethodVisitor mv = cw.visitMethod(1025, BuildUtils.setterName(name, type), "(" + BuildUtils.getTypeDescriptor(type) + ")V", generic == null ? null : "(" + BuildUtils.getTypeDescriptor(type).replace(";", "<" + BuildUtils.getTypeDescriptor(generic) + ">;") + ")V", null);
        mv.visitEnd();
    }

    protected void buildGetter(ClassWriter cw, FieldDefinition field, String name, String type, String generic) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        MethodVisitor mv = cw.visitMethod(1025, BuildUtils.getterName(name, type), "()" + BuildUtils.getTypeDescriptor(type), generic == null ? null : "()" + BuildUtils.getTypeDescriptor(type).replace(";", "<" + BuildUtils.getTypeDescriptor(generic) + ">;"), null);
        mv.visitEnd();
    }

    protected void finalizeCreation(ClassDefinition trait) {
    }
}

