/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.solver.move.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveListFactory;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.solver.move.CloudProcessSwapMove;

public class CloudProcessSwapMoveFactory
implements MoveListFactory<CloudBalance> {
    @Override
    public List<Move> createMoveList(CloudBalance cloudBalance) {
        List<CloudProcess> cloudProcessList = cloudBalance.getProcessList();
        ArrayList<Move> moveList = new ArrayList<Move>();
        ListIterator<CloudProcess> leftIt = cloudProcessList.listIterator();
        while (leftIt.hasNext()) {
            CloudProcess leftCloudProcess = leftIt.next();
            ListIterator<CloudProcess> rightIt = cloudProcessList.listIterator(leftIt.nextIndex());
            while (rightIt.hasNext()) {
                CloudProcess rightCloudProcess = rightIt.next();
                moveList.add(new CloudProcessSwapMove(leftCloudProcess, rightCloudProcess));
            }
        }
        return moveList;
    }
}

