/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.projectjobscheduling.domain.Allocation;
import org.optaplanner.examples.projectjobscheduling.domain.ExecutionMode;
import org.optaplanner.examples.projectjobscheduling.domain.Job;
import org.optaplanner.examples.projectjobscheduling.domain.JobType;
import org.optaplanner.examples.projectjobscheduling.domain.Project;
import org.optaplanner.examples.projectjobscheduling.domain.ResourceRequirement;
import org.optaplanner.examples.projectjobscheduling.domain.Schedule;
import org.optaplanner.examples.projectjobscheduling.domain.resource.GlobalResource;
import org.optaplanner.examples.projectjobscheduling.domain.resource.LocalResource;
import org.optaplanner.examples.projectjobscheduling.domain.resource.Resource;
import org.optaplanner.examples.projectjobscheduling.persistence.ProjectJobSchedulingDao;

public class ProjectJobSchedulingImporter
extends AbstractTxtSolutionImporter {
    public static void main(String[] args) {
        new ProjectJobSchedulingImporter().convertAll();
    }

    public ProjectJobSchedulingImporter() {
        super(new ProjectJobSchedulingDao());
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new ProjectJobSchedulingInputBuilder();
    }

    public class ProjectJobSchedulingInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        private Schedule schedule;
        private int projectListSize;
        private int resourceListSize;
        private int globalResourceListSize;
        private long projectId;
        private long resourceId;
        private long jobId;
        private long executionModeId;
        private long resourceRequirementId;
        private Map<Project, File> projectFileMap;

        public ProjectJobSchedulingInputBuilder() {
            super(ProjectJobSchedulingImporter.this);
            this.projectId = 0L;
            this.resourceId = 0L;
            this.jobId = 0L;
            this.executionModeId = 0L;
            this.resourceRequirementId = 0L;
        }

        @Override
        public Solution readSolution() throws IOException {
            this.schedule = new Schedule();
            this.schedule.setId(0L);
            this.readProjectList();
            this.readResourceList();
            for (Map.Entry<Project, File> entry : this.projectFileMap.entrySet()) {
                this.readProjectFile(entry.getKey(), entry.getValue());
            }
            this.removePointlessExecutionModes();
            this.createAllocationList();
            ProjectJobSchedulingImporter.this.logger.info("Schedule {} has {} projects, {} jobs, {} execution modes, {} resources and {} resource requirements.", new Object[]{this.getInputId(), this.schedule.getProjectList().size(), this.schedule.getJobList().size(), this.schedule.getExecutionModeList().size(), this.schedule.getResourceList().size(), this.schedule.getResourceRequirementList().size()});
            return this.schedule;
        }

        private void readProjectList() throws IOException {
            this.projectListSize = this.readIntegerValue();
            ArrayList<Project> projectList = new ArrayList<Project>(this.projectListSize);
            this.projectFileMap = new LinkedHashMap<Project, File>(this.projectListSize);
            for (int i = 0; i < this.projectListSize; ++i) {
                Project project = new Project();
                project.setId(this.projectId);
                project.setReleaseDate(this.readIntegerValue());
                project.setCriticalPathDuration(this.readIntegerValue());
                File projectFile = new File(this.inputFile.getParentFile(), this.readStringValue());
                if (!projectFile.exists()) {
                    throw new IllegalArgumentException("The projectFile (" + projectFile + ") does not exist.");
                }
                this.projectFileMap.put(project, projectFile);
                projectList.add(project);
                ++this.projectId;
            }
            this.schedule.setProjectList(projectList);
            this.schedule.setJobList(new ArrayList<Job>(this.projectListSize * 10));
            this.schedule.setExecutionModeList(new ArrayList<ExecutionMode>(this.projectListSize * 10 * 5));
        }

        private void readResourceList() throws IOException {
            this.resourceListSize = this.readIntegerValue();
            String[] tokens = this.splitBySpacesOrTabs(this.readStringValue(), this.resourceListSize);
            ArrayList<Resource> resourceList = new ArrayList<Resource>(this.resourceListSize * this.projectListSize * 10);
            for (int i = 0; i < this.resourceListSize; ++i) {
                int capacity = Integer.parseInt(tokens[i]);
                if (capacity == -1) continue;
                GlobalResource resource = new GlobalResource();
                resource.setId(this.resourceId);
                resource.setCapacity(capacity);
                resourceList.add(resource);
                ++this.resourceId;
            }
            this.globalResourceListSize = resourceList.size();
            this.schedule.setResourceList(resourceList);
            this.schedule.setResourceRequirementList(new ArrayList<ResourceRequirement>(this.projectListSize * 10 * 5 * this.resourceListSize));
        }

        private void readProjectFile(Project project, File projectFile) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(projectFile), "UTF-8"));
                ProjectFileInputBuilder projectFileInputBuilder = new ProjectFileInputBuilder(this.schedule, project);
                projectFileInputBuilder.setInputFile(projectFile);
                projectFileInputBuilder.setBufferedReader(bufferedReader);
                try {
                    projectFileInputBuilder.readSolution();
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Exception in projectFile (" + projectFile + ")", e);
                }
                catch (IllegalStateException e) {
                    throw new IllegalStateException("Exception in projectFile (" + projectFile + ")", e);
                }
            }
            catch (IOException e) {
                try {
                    throw new IllegalArgumentException("Could not read the projectFile (" + projectFile + ").", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bufferedReader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)bufferedReader);
        }

        private void removePointlessExecutionModes() {
        }

        private void createAllocationList() {
            List<Job> jobList = this.schedule.getJobList();
            ArrayList<Allocation> allocationList = new ArrayList<Allocation>(jobList.size());
            HashMap<Job, Allocation> jobToAllocationMap = new HashMap<Job, Allocation>(jobList.size());
            HashMap<Project, Allocation> projectToSourceAllocationMap = new HashMap<Project, Allocation>(this.projectListSize);
            HashMap<Project, Allocation> projectToSinkAllocationMap = new HashMap<Project, Allocation>(this.projectListSize);
            for (Job job : jobList) {
                Allocation allocation = new Allocation();
                allocation.setId(job.getId());
                allocation.setJob(job);
                allocation.setPredecessorAllocationList(new ArrayList<Allocation>(job.getSuccessorJobList().size()));
                allocation.setSuccessorAllocationList(new ArrayList<Allocation>(job.getSuccessorJobList().size()));
                allocation.setPredecessorsDoneDate(job.getProject().getReleaseDate());
                if (job.getJobType() == JobType.SOURCE) {
                    allocation.setDelay(0);
                    if (job.getExecutionModeList().size() != 1) {
                        throw new IllegalArgumentException("The job (" + job + ")'s executionModeList (" + job.getExecutionModeList() + ") is expected to be a singleton.");
                    }
                    allocation.setExecutionMode(job.getExecutionModeList().get(0));
                    projectToSourceAllocationMap.put(job.getProject(), allocation);
                } else if (job.getJobType() == JobType.SINK) {
                    allocation.setDelay(0);
                    if (job.getExecutionModeList().size() != 1) {
                        throw new IllegalArgumentException("The job (" + job + ")'s executionModeList (" + job.getExecutionModeList() + ") is expected to be a singleton.");
                    }
                    allocation.setExecutionMode(job.getExecutionModeList().get(0));
                    projectToSinkAllocationMap.put(job.getProject(), allocation);
                }
                allocationList.add(allocation);
                jobToAllocationMap.put(job, allocation);
            }
            for (Allocation allocation : allocationList) {
                Job job = allocation.getJob();
                allocation.setSourceAllocation((Allocation)projectToSourceAllocationMap.get(job.getProject()));
                allocation.setSinkAllocation((Allocation)projectToSinkAllocationMap.get(job.getProject()));
                for (Job successorJob : job.getSuccessorJobList()) {
                    Allocation successorAllocation = (Allocation)jobToAllocationMap.get(successorJob);
                    allocation.getSuccessorAllocationList().add(successorAllocation);
                    successorAllocation.getPredecessorAllocationList().add(allocation);
                }
            }
            for (Allocation sourceAllocation : projectToSourceAllocationMap.values()) {
                for (Allocation allocation : sourceAllocation.getSuccessorAllocationList()) {
                    allocation.setPredecessorsDoneDate(sourceAllocation.getEndDate());
                }
            }
            this.schedule.setAllocationList(allocationList);
        }

        public class ProjectFileInputBuilder
        extends AbstractTxtSolutionImporter.TxtInputBuilder {
            private Schedule schedule;
            private Project project;
            private int jobListSize;
            private int renewableLocalResourceSize;
            private int nonrenewableLocalResourceSize;

            public ProjectFileInputBuilder(Schedule schedule, Project project) {
                super(ProjectJobSchedulingImporter.this);
                this.schedule = schedule;
                this.project = project;
            }

            @Override
            public Solution readSolution() throws IOException {
                this.readHeader();
                this.readResourceList();
                this.readProjectInformation();
                this.readPrecedenceRelations();
                this.readRequestDurations();
                this.readResourceAvailabilities();
                this.detectPointlessSuccessor();
                return null;
            }

            private void readHeader() throws IOException {
                this.readRegexConstantLine("\\*+");
                this.readStringValue("file with basedata            :");
                this.readStringValue("initial value random generator:");
                this.readRegexConstantLine("\\*+");
                int projects = this.readIntegerValue("projects                      :");
                if (projects != 1) {
                    throw new IllegalArgumentException("The projects value (" + projects + ") should always be 1.");
                }
                this.jobListSize = this.readIntegerValue("jobs (incl. supersource/sink ):");
                int horizon = this.readIntegerValue("horizon                       :");
            }

            private void readResourceList() throws IOException {
                LocalResource localResource;
                int i;
                this.readConstantLine("RESOURCES");
                int renewableResourceSize = this.readIntegerValue("- renewable                 :", "R");
                if (renewableResourceSize < ProjectJobSchedulingInputBuilder.this.globalResourceListSize) {
                    throw new IllegalArgumentException("The renewableResourceSize (" + renewableResourceSize + ") can not be less than globalResourceListSize (" + ProjectJobSchedulingInputBuilder.this.globalResourceListSize + ").");
                }
                this.renewableLocalResourceSize = renewableResourceSize - ProjectJobSchedulingInputBuilder.this.globalResourceListSize;
                this.nonrenewableLocalResourceSize = this.readIntegerValue("- nonrenewable              :", "N");
                int doublyConstrainedResourceSize = this.readIntegerValue("- doubly constrained        :", "D");
                if (doublyConstrainedResourceSize != 0) {
                    throw new IllegalArgumentException("The doublyConstrainedResourceSize (" + doublyConstrainedResourceSize + ") should always be 0.");
                }
                ArrayList<LocalResource> localResourceList = new ArrayList<LocalResource>(ProjectJobSchedulingInputBuilder.this.globalResourceListSize + this.renewableLocalResourceSize + this.nonrenewableLocalResourceSize);
                for (i = 0; i < this.renewableLocalResourceSize; ++i) {
                    localResource = new LocalResource();
                    localResource.setId(ProjectJobSchedulingInputBuilder.this.resourceId);
                    localResource.setProject(this.project);
                    localResource.setRenewable(true);
                    ProjectJobSchedulingInputBuilder.this.resourceId++;
                    localResourceList.add(localResource);
                }
                for (i = 0; i < this.nonrenewableLocalResourceSize; ++i) {
                    localResource = new LocalResource();
                    localResource.setId(ProjectJobSchedulingInputBuilder.this.resourceId);
                    localResource.setProject(this.project);
                    localResource.setRenewable(false);
                    ProjectJobSchedulingInputBuilder.this.resourceId++;
                    localResourceList.add(localResource);
                }
                this.project.setLocalResourceList(localResourceList);
                this.schedule.getResourceList().addAll(localResourceList);
                this.readRegexConstantLine("\\*+");
            }

            private void readProjectInformation() throws IOException {
                this.readConstantLine("PROJECT INFORMATION:");
                this.readConstantLine("pronr.  #jobs rel.date duedate tardcost  MPM-Time");
                Object[] tokens = this.splitBySpacesOrTabs(this.readStringValue(), 6);
                if (Integer.parseInt(tokens[0]) != 1) {
                    throw new IllegalArgumentException("The project information tokens (" + Arrays.toString(tokens) + ") index 0 should be 1.");
                }
                if (Integer.parseInt(tokens[1]) != this.jobListSize - 2) {
                    throw new IllegalArgumentException("The project information tokens (" + Arrays.toString(tokens) + ") index 1 should be " + (this.jobListSize - 2) + ".");
                }
                this.readRegexConstantLine("\\*+");
            }

            private void readPrecedenceRelations() throws IOException {
                Job job;
                int i;
                this.readConstantLine("PRECEDENCE RELATIONS:");
                this.readConstantLine("jobnr.    #modes  #successors   successors");
                ArrayList<Job> jobList = new ArrayList<Job>(this.jobListSize);
                for (i = 0; i < this.jobListSize; ++i) {
                    job = new Job();
                    job.setId(ProjectJobSchedulingInputBuilder.this.jobId);
                    job.setProject(this.project);
                    if (i == 0) {
                        job.setJobType(JobType.SOURCE);
                    } else if (i == this.jobListSize - 1) {
                        job.setJobType(JobType.SINK);
                    } else {
                        job.setJobType(JobType.STANDARD);
                    }
                    jobList.add(job);
                    ProjectJobSchedulingInputBuilder.this.jobId++;
                }
                this.project.setJobList(jobList);
                this.schedule.getJobList().addAll(jobList);
                for (i = 0; i < this.jobListSize; ++i) {
                    job = (Job)jobList.get(i);
                    Object[] tokens = this.splitBySpacesOrTabs(this.readStringValue());
                    if (tokens.length < 3) {
                        throw new IllegalArgumentException("The tokens (" + Arrays.toString(tokens) + ") should be at least 3 in length.");
                    }
                    if (Integer.parseInt(tokens[0]) != i + 1) {
                        throw new IllegalArgumentException("The tokens (" + Arrays.toString(tokens) + ") index 0 should be " + (i + 1) + ".");
                    }
                    int executionModeListSize = Integer.parseInt((String)tokens[1]);
                    ArrayList<ExecutionMode> executionModeList = new ArrayList<ExecutionMode>(executionModeListSize);
                    for (int j = 0; j < executionModeListSize; ++j) {
                        ExecutionMode executionMode = new ExecutionMode();
                        executionMode.setId(ProjectJobSchedulingInputBuilder.this.executionModeId);
                        executionMode.setJob(job);
                        executionModeList.add(executionMode);
                        ProjectJobSchedulingInputBuilder.this.executionModeId++;
                    }
                    job.setExecutionModeList(executionModeList);
                    this.schedule.getExecutionModeList().addAll(executionModeList);
                    int successorJobListSize = Integer.parseInt((String)tokens[2]);
                    if (tokens.length != 3 + successorJobListSize) {
                        throw new IllegalArgumentException("The tokens (" + Arrays.toString(tokens) + ") should be " + (3 + successorJobListSize) + " in length.");
                    }
                    ArrayList<Job> successorJobList = new ArrayList<Job>(successorJobListSize);
                    for (int j = 0; j < successorJobListSize; ++j) {
                        int successorIndex = Integer.parseInt((String)tokens[3 + j]);
                        Job successorJob = this.project.getJobList().get(successorIndex - 1);
                        successorJobList.add(successorJob);
                    }
                    job.setSuccessorJobList(successorJobList);
                }
                this.readRegexConstantLine("\\*+");
            }

            private void readRequestDurations() throws IOException {
                this.readConstantLine("REQUESTS/DURATIONS:");
                this.splitBySpacesOrTabs(this.readStringValue());
                this.readRegexConstantLine("\\-+");
                int resourceSize = ProjectJobSchedulingInputBuilder.this.globalResourceListSize + this.renewableLocalResourceSize + this.nonrenewableLocalResourceSize;
                for (int i = 0; i < this.jobListSize; ++i) {
                    Job job = this.project.getJobList().get(i);
                    int executionModeSize = job.getExecutionModeList().size();
                    for (int j = 0; j < executionModeSize; ++j) {
                        ExecutionMode executionMode = job.getExecutionModeList().get(j);
                        boolean first = j == 0;
                        Object[] tokens = this.splitBySpacesOrTabs(this.readStringValue(), (first ? 3 : 2) + resourceSize);
                        if (first && Integer.parseInt(tokens[0]) != i + 1) {
                            throw new IllegalArgumentException("The tokens (" + Arrays.toString(tokens) + ") index 0 should be " + (i + 1) + ".");
                        }
                        if (Integer.parseInt(tokens[first ? 1 : 0]) != j + 1) {
                            throw new IllegalArgumentException("The tokens (" + Arrays.toString(tokens) + ") index " + (first ? 1 : 0) + " should be " + (j + 1) + ".");
                        }
                        int duration = Integer.parseInt(tokens[first ? 2 : 1]);
                        executionMode.setDuration(duration);
                        ArrayList<ResourceRequirement> resourceRequirementList = new ArrayList<ResourceRequirement>(resourceSize);
                        for (int k = 0; k < resourceSize; ++k) {
                            int requirement = Integer.parseInt((String)tokens[(first ? 3 : 2) + k]);
                            if (requirement == 0) continue;
                            ResourceRequirement resourceRequirement = new ResourceRequirement();
                            resourceRequirement.setId(ProjectJobSchedulingInputBuilder.this.resourceRequirementId);
                            resourceRequirement.setExecutionMode(executionMode);
                            Resource resource = k < ProjectJobSchedulingInputBuilder.this.globalResourceListSize ? this.schedule.getResourceList().get(k) : (Resource)this.project.getLocalResourceList().get(k - ProjectJobSchedulingInputBuilder.this.globalResourceListSize);
                            resourceRequirement.setResource(resource);
                            resourceRequirement.setRequirement(requirement);
                            resourceRequirementList.add(resourceRequirement);
                            ProjectJobSchedulingInputBuilder.this.resourceRequirementId++;
                        }
                        executionMode.setResourceRequirementList(resourceRequirementList);
                        this.schedule.getResourceRequirementList().addAll(resourceRequirementList);
                    }
                }
                this.readRegexConstantLine("\\*+");
            }

            private void readResourceAvailabilities() throws IOException {
                this.readConstantLine("RESOURCEAVAILABILITIES:");
                this.splitBySpacesOrTabs(this.readStringValue());
                int resourceSize = ProjectJobSchedulingInputBuilder.this.globalResourceListSize + this.renewableLocalResourceSize + this.nonrenewableLocalResourceSize;
                String[] tokens = this.splitBySpacesOrTabs(this.readStringValue(), resourceSize);
                for (int i = 0; i < resourceSize; ++i) {
                    int capacity = Integer.parseInt(tokens[i]);
                    if (i < ProjectJobSchedulingInputBuilder.this.globalResourceListSize) continue;
                    Resource resource = this.project.getLocalResourceList().get(i - ProjectJobSchedulingInputBuilder.this.globalResourceListSize);
                    resource.setCapacity(capacity);
                }
                this.readRegexConstantLine("\\*+");
            }

            private void detectPointlessSuccessor() {
                for (Job baseJob : this.project.getJobList()) {
                    HashSet<Job> baseSuccessorJobSet = new HashSet<Job>(baseJob.getSuccessorJobList());
                    HashSet checkedSuccessorSet = new HashSet(this.project.getJobList().size());
                    ArrayDeque<Job> uncheckedSuccessorQueue = new ArrayDeque<Job>(this.project.getJobList().size());
                    for (Job baseSuccessorJob : baseJob.getSuccessorJobList()) {
                        uncheckedSuccessorQueue.addAll(baseSuccessorJob.getSuccessorJobList());
                    }
                    while (!uncheckedSuccessorQueue.isEmpty()) {
                        Job uncheckedJob = (Job)uncheckedSuccessorQueue.remove();
                        if (checkedSuccessorSet.contains(uncheckedJob)) continue;
                        if (baseSuccessorJobSet.contains(uncheckedJob)) {
                            throw new IllegalStateException("The baseJob (" + baseJob + ") has a direct successor (" + uncheckedJob + ") that is also an indirect successor. That's pointless.");
                        }
                        uncheckedSuccessorQueue.addAll(uncheckedJob.getSuccessorJobList());
                    }
                }
            }
        }
    }
}

