/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoftlong;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScoreHolder;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.definition.AbstractScoreDefinition;

public class HardSoftLongScoreDefinition
extends AbstractScoreDefinition<HardSoftLongScore> {
    private double hardScoreTimeGradientWeight = 0.75;
    private HardSoftLongScore perfectMaximumScore = HardSoftLongScore.valueOf(0L, 0L);
    private HardSoftLongScore perfectMinimumScore = HardSoftLongScore.valueOf(Long.MIN_VALUE, Long.MIN_VALUE);

    public double getHardScoreTimeGradientWeight() {
        return this.hardScoreTimeGradientWeight;
    }

    public void setHardScoreTimeGradientWeight(double hardScoreTimeGradientWeight) {
        this.hardScoreTimeGradientWeight = hardScoreTimeGradientWeight;
        if (hardScoreTimeGradientWeight < 0.0 || hardScoreTimeGradientWeight > 1.0) {
            throw new IllegalArgumentException("Property hardScoreTimeGradientWeight (" + hardScoreTimeGradientWeight + ") must be greater or equal to 0.0 and smaller or equal to 1.0.");
        }
    }

    @Override
    public HardSoftLongScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    public void setPerfectMaximumScore(HardSoftLongScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    @Override
    public HardSoftLongScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    public void setPerfectMinimumScore(HardSoftLongScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public Class<HardSoftLongScore> getScoreClass() {
        return HardSoftLongScore.class;
    }

    @Override
    public Score parseScore(String scoreString) {
        return HardSoftLongScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(HardSoftLongScore startScore, HardSoftLongScore endScore, HardSoftLongScore score) {
        if (score.compareTo(endScore) > 0) {
            return 1.0;
        }
        if (score.compareTo(startScore) < 0) {
            return 0.0;
        }
        double timeGradient = 0.0;
        double softScoreTimeGradientWeight = 1.0 - this.hardScoreTimeGradientWeight;
        if (startScore.getHardScore() == endScore.getHardScore()) {
            timeGradient += this.hardScoreTimeGradientWeight;
        } else {
            long hardScoreTotal = endScore.getHardScore() - startScore.getHardScore();
            long hardScoreDelta = score.getHardScore() - startScore.getHardScore();
            double hardTimeGradient = (double)hardScoreDelta / (double)hardScoreTotal;
            timeGradient += hardTimeGradient * this.hardScoreTimeGradientWeight;
        }
        if (score.getSoftScore() >= endScore.getSoftScore()) {
            timeGradient += softScoreTimeGradientWeight;
        } else if (score.getSoftScore() > startScore.getSoftScore()) {
            long softScoreTotal = endScore.getSoftScore() - startScore.getSoftScore();
            long softScoreDelta = score.getSoftScore() - startScore.getSoftScore();
            double softTimeGradient = (double)softScoreDelta / (double)softScoreTotal;
            timeGradient += softTimeGradient * softScoreTimeGradientWeight;
        }
        return timeGradient;
    }

    @Override
    public ScoreHolder buildScoreHolder(boolean constraintMatchEnabled) {
        return new HardSoftLongScoreHolder(constraintMatchEnabled);
    }
}

