/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.InitialFact;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.ValueType;
import org.drools.core.reteoo.InitialFactImpl;
import org.drools.core.spi.ClassWireable;
import org.drools.core.spi.ObjectType;
import org.kie.api.runtime.rule.Match;

public class ClassObjectType
implements ObjectType,
ClassWireable,
Externalizable {
    public static final ClassObjectType InitialFact_ObjectType = new ClassObjectType(InitialFactImpl.class);
    public static final ClassObjectType DroolsQuery_ObjectType = new ClassObjectType(DroolsQuery.class);
    public static final ClassObjectType Map_ObjectType = new ClassObjectType(Map.class);
    public static final ClassObjectType ObjectArray_ObjectType = new ClassObjectType(Object[].class);
    public static final ClassObjectType Match_ObjectType = new ClassObjectType(Match.class);
    private static final long serialVersionUID = 510L;
    protected Class<?> cls;
    protected String clsName;
    protected ValueType valueType;
    private boolean isEvent;
    private transient Map<String, Long> transformedMasks;

    public ClassObjectType() {
    }

    public ClassObjectType(Class<?> objectTypeClass) {
        this(objectTypeClass, false);
    }

    public ClassObjectType(Class<?> objectTypeClass, boolean isEvent) {
        this.cls = objectTypeClass;
        this.isEvent = isEvent;
        this.clsName = this.cls.getName();
        this.valueType = ValueType.determineValueType(objectTypeClass);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.clsName = in.readUTF();
        if (InitialFact.class.getName().equals(this.clsName) || InitialFactImpl.class.getName().equals(this.clsName)) {
            this.setClassType(InitialFactImpl.class);
            this.valueType = ValueType.OBJECT_TYPE;
        } else if (DroolsQuery.class.getName().equals(this.clsName)) {
            this.setClassType(DroolsQuery.class);
            this.valueType = ValueType.QUERY_TYPE;
        } else {
            try {
                this.setClassType(Class.forName(this.clsName));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.isEvent = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.clsName);
        out.writeBoolean(this.isEvent);
    }

    @Override
    public Class<?> getClassType() {
        return this.cls;
    }

    @Override
    public String getClassName() {
        return this.clsName;
    }

    public void setClassType(Class<?> cls) {
        this.cls = cls;
        this.valueType = ValueType.determineValueType(cls);
    }

    @Override
    public boolean isAssignableFrom(ObjectType objectType) {
        if (!(objectType instanceof ClassObjectType)) {
            return false;
        }
        return this.cls.isAssignableFrom(((ClassObjectType)objectType).getClassType());
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isEvent() {
        return this.isEvent;
    }

    public void setEvent(boolean isEvent) {
        this.isEvent = isEvent;
    }

    public String toString() {
        return "[ClassObjectType " + (this.isEvent ? "event=" : "class=") + this.getClassType().getName() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != ClassObjectType.class) {
            return false;
        }
        return this.clsName.equals(((ClassObjectType)object).clsName);
    }

    public int hashCode() {
        return this.clsName.hashCode();
    }

    @Override
    public void wire(Class<?> klass) {
        this.cls = klass;
    }

    public Long getTransformedMask(Class<?> modifiedClass, long modificationMask) {
        if (this.transformedMasks == null) {
            return null;
        }
        String key = modifiedClass.getName() + ":" + modificationMask;
        return this.transformedMasks.get(key);
    }

    public void storeTransformedMask(Class<?> modifiedClass, long modificationMask, long transforedMask) {
        if (this.transformedMasks == null) {
            this.transformedMasks = new ConcurrentHashMap<String, Long>();
        }
        String key = modifiedClass.getName() + ":" + modificationMask;
        this.transformedMasks.put(key, transforedMask);
    }
}

