/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.DoubleBetaConstraints;
import org.drools.core.common.DoubleNonIndexSkipBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PhreakPropagationContext;
import org.drools.core.common.QuadroupleBetaConstraints;
import org.drools.core.common.QuadroupleNonIndexSkipBetaConstraints;
import org.drools.core.common.RightTupleSets;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.common.SingleNonIndexSkipBetaConstraints;
import org.drools.core.common.TripleBetaConstraints;
import org.drools.core.common.TripleNonIndexSkipBetaConstraints;
import org.drools.core.common.UpdateContext;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.phreak.RightTupleEntry;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MemoryVisitor;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.FastIterator;
import org.drools.core.util.index.IndexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BetaNode
extends LeftTupleSource
implements LeftTupleSinkNode,
ObjectSinkNode,
RightTupleSink,
MemoryFactory {
    protected static transient Logger log = LoggerFactory.getLogger(BetaNode.class);
    protected ObjectSource rightInput;
    protected BetaConstraints constraints;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;
    protected boolean objectMemory = true;
    protected boolean tupleMemoryEnabled;
    protected boolean concurrentRightTupleMemory = false;
    protected boolean indexedUnificationJoin;
    private long rightDeclaredMask;
    private long rightInferredMask;
    private long rightNegativeMask;
    private List<String> leftListenedProperties;
    private List<String> rightListenedProperties;
    private transient ObjectTypeNode.Id rightInputOtnId = ObjectTypeNode.DEFAULT_ID;
    private boolean rightInputIsRiaNode;
    private transient ObjectTypeNode objectTypeNode;

    public BetaNode() {
    }

    BetaNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints constraints, BuildContext context) {
        super(id, partitionId, partitionsEnabled);
        this.setLeftTupleSource(leftInput);
        this.rightInput = rightInput;
        this.rightInputIsRiaNode = 71 == rightInput.getType();
        this.setConstraints(constraints);
        if (this.constraints == null) {
            throw new RuntimeException("cannot have null constraints, must at least be an instance of EmptyBetaConstraints");
        }
        this.initMasks(context, leftInput);
        this.streamMode = context.isStreamMode() && this.getObjectTypeNode(context).getObjectType().isEvent();
    }

    private ObjectTypeNode getObjectTypeNode(BuildContext context) {
        ObjectTypeNode otn = this.getObjectTypeNode();
        return otn != null ? otn : context.getRootObjectTypeNode();
    }

    @Override
    protected void initDeclaredMask(BuildContext context, LeftTupleSource leftInput) {
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.rightDeclaredMask = -1L;
            super.initDeclaredMask(context, leftInput);
            return;
        }
        if (!this.isRightInputIsRiaNode()) {
            Pattern pattern = context.getLastBuiltPatterns()[0];
            ObjectType objectType = pattern.getObjectType();
            if (objectType instanceof ClassObjectType) {
                Class<?> objectClass = ((ClassObjectType)objectType).getClassType();
                if (PropertySpecificUtil.isPropertyReactive(context, objectClass)) {
                    this.rightListenedProperties = pattern.getListenedProperties();
                    List<String> settableProperties = PropertySpecificUtil.getSettableProperties(context.getRuleBase(), objectClass);
                    this.rightDeclaredMask = PropertySpecificUtil.calculatePositiveMask(this.rightListenedProperties, settableProperties);
                    this.rightDeclaredMask |= this.constraints.getListenedPropertyMask(settableProperties);
                    this.rightNegativeMask = PropertySpecificUtil.calculateNegativeMask(this.rightListenedProperties, settableProperties);
                } else {
                    this.rightDeclaredMask = -1L;
                }
            } else {
                this.rightDeclaredMask = -1L;
            }
        } else {
            this.rightDeclaredMask = -1L;
            context.setLastBuiltPattern(context.getLastBuiltPatterns()[0]);
        }
        super.initDeclaredMask(context, leftInput);
    }

    @Override
    protected void setLeftListenedProperties(List<String> leftListenedProperties) {
        this.leftListenedProperties = leftListenedProperties;
    }

    public void initInferredMask() {
        this.initInferredMask(this.leftInput);
    }

    @Override
    protected void initInferredMask(LeftTupleSource leftInput) {
        super.initInferredMask(leftInput);
        ObjectSource unwrappedRight = this.unwrapRightInput();
        if (unwrappedRight.getType() == 40) {
            AlphaNode alphaNode = (AlphaNode)unwrappedRight;
            this.rightInferredMask = alphaNode.updateMask(this.rightDeclaredMask);
        } else {
            this.rightInferredMask = this.rightDeclaredMask;
        }
        this.rightInferredMask &= -1L - this.rightNegativeMask;
    }

    public ObjectSource unwrapRightInput() {
        return this.rightInput.getType() == 50 ? this.rightInput.getParentObjectSource() : this.rightInput;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraints = (BetaConstraints)in.readObject();
        this.rightInput = (ObjectSource)in.readObject();
        this.objectMemory = in.readBoolean();
        this.tupleMemoryEnabled = in.readBoolean();
        this.concurrentRightTupleMemory = in.readBoolean();
        this.rightDeclaredMask = in.readLong();
        this.rightInferredMask = in.readLong();
        this.rightNegativeMask = in.readLong();
        this.leftListenedProperties = (List)in.readObject();
        this.rightListenedProperties = (List)in.readObject();
        this.setUnificationJoin();
        super.readExternal(in);
        this.rightInputIsRiaNode = 71 == this.rightInput.getType();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        BetaNodeFieldConstraint c;
        BetaNodeFieldConstraint[] betaCconstraints = this.constraints.getConstraints();
        if (betaCconstraints.length > 0 && IndexUtil.isIndexable(c = betaCconstraints[0], this.getType()) && ((IndexableConstraint)((Object)c)).isUnification()) {
            this.setConstraints(this.constraints.getOriginalConstraint());
        }
        out.writeObject(this.constraints);
        out.writeObject(this.rightInput);
        out.writeBoolean(this.objectMemory);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeBoolean(this.concurrentRightTupleMemory);
        out.writeLong(this.rightDeclaredMask);
        out.writeLong(this.rightInferredMask);
        out.writeLong(this.rightNegativeMask);
        out.writeObject(this.leftListenedProperties);
        out.writeObject(this.rightListenedProperties);
        super.writeExternal(out);
    }

    public void setUnificationJoin() {
        BetaNodeFieldConstraint c;
        BetaNodeFieldConstraint[] betaCconstraints = this.constraints.getConstraints();
        if (betaCconstraints.length > 0 && IndexUtil.isIndexable(c = betaCconstraints[0], this.getType()) && ((IndexableConstraint)((Object)c)).isUnification()) {
            if (this.constraints instanceof SingleBetaConstraints) {
                this.setConstraints(new SingleNonIndexSkipBetaConstraints((SingleBetaConstraints)this.constraints));
            } else if (this.constraints instanceof DoubleBetaConstraints) {
                this.setConstraints(new DoubleNonIndexSkipBetaConstraints((DoubleBetaConstraints)this.constraints));
            } else if (this.constraints instanceof TripleBetaConstraints) {
                this.setConstraints(new TripleNonIndexSkipBetaConstraints((TripleBetaConstraints)this.constraints));
            } else if (this.constraints instanceof QuadroupleBetaConstraints) {
                this.setConstraints(new QuadroupleNonIndexSkipBetaConstraints((QuadroupleBetaConstraints)this.constraints));
            }
            this.indexedUnificationJoin = true;
        }
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory wm) {
        BetaMemory memory = (BetaMemory)BetaNode.getBetaMemoryFromRightInput(this, wm);
        RightTuple rightTuple = this.createRightTuple(factHandle, this, pctx);
        boolean stagedInsertWasEmpty = false;
        if (this.streamMode) {
            stagedInsertWasEmpty = memory.getSegmentMemory().getTupleQueue().isEmpty();
            int propagationType = pctx.getType() == 2 ? 0 : pctx.getType();
            memory.getSegmentMemory().getTupleQueue().add(new RightTupleEntry(rightTuple, pctx, memory, propagationType));
            if (log.isTraceEnabled()) {
                log.trace("JoinNode insert queue={} size={} pctx={} lt={}", new Object[]{System.identityHashCode(memory.getSegmentMemory().getTupleQueue()), memory.getSegmentMemory().getTupleQueue().size(), PhreakPropagationContext.intEnumToString(pctx), rightTuple});
            }
        } else {
            stagedInsertWasEmpty = memory.getStagedRightTuples().addInsert(rightTuple);
        }
        if (log.isTraceEnabled()) {
            log.trace("BetaNode insert={} stagedInsertWasEmpty={}", (Object)memory.getStagedRightTuples().insertSize(), (Object)stagedInsertWasEmpty);
        }
        if (memory.getAndIncCounter() == 0) {
            memory.linkNode(wm);
        } else if (stagedInsertWasEmpty) {
            memory.setNodeDirty(wm);
        }
        if (pctx.getReaderContext() != null) {
            MarshallerReaderContext mrc = pctx.getReaderContext();
            mrc.filter.fireRNEAs(wm);
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory wm) {
        BetaMemory bm;
        RightTuple rightTuple = modifyPreviousTuples.peekRightTuple();
        while (rightTuple != null && ((BetaNode)rightTuple.getRightTupleSink()).getRightInputOtnId().before(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple();
            rightTuple.setPropagationContext(context);
            bm = BetaNode.getBetaMemory((BetaNode)rightTuple.getRightTupleSink(), wm);
            ((BetaNode)rightTuple.getRightTupleSink()).doDeleteRightTuple(rightTuple, wm, bm);
            rightTuple = modifyPreviousTuples.peekRightTuple();
        }
        if (rightTuple != null && ((BetaNode)rightTuple.getRightTupleSink()).getRightInputOtnId().equals(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple();
            rightTuple.reAdd();
            if (BitMaskUtil.intersect(context.getModificationMask(), this.getRightInferredMask())) {
                rightTuple.setPropagationContext(context);
                bm = BetaNode.getBetaMemory(this, wm);
                rightTuple.setPropagationContext(context);
                this.doUpdateRightTuple(rightTuple, wm, bm);
            }
        } else if (BitMaskUtil.intersect(context.getModificationMask(), this.getRightInferredMask())) {
            this.assertObject(factHandle, context, wm);
        }
    }

    public void doDeleteRightTuple(RightTuple rightTuple, InternalWorkingMemory wm, BetaMemory memory) {
        RightTupleSets stagedRightTuples = memory.getStagedRightTuples();
        boolean stagedDeleteWasEmpty = false;
        if (this.isStreamMode()) {
            stagedDeleteWasEmpty = memory.getSegmentMemory().getTupleQueue().isEmpty();
            PropagationContext pctx = rightTuple.getPropagationContext();
            int propagationType = pctx.getType() == 2 ? 1 : pctx.getType();
            memory.getSegmentMemory().getTupleQueue().add(new RightTupleEntry(rightTuple, pctx, memory, propagationType));
            if (log.isTraceEnabled()) {
                log.trace("JoinNode delete queue={} size={} pctx={} lt={}", new Object[]{System.identityHashCode(memory.getSegmentMemory().getTupleQueue()), memory.getSegmentMemory().getTupleQueue().size(), PhreakPropagationContext.intEnumToString(rightTuple.getPropagationContext()), rightTuple});
            }
        } else {
            stagedDeleteWasEmpty = stagedRightTuples.addDelete(rightTuple);
        }
        if (memory.getAndDecCounter() == 1) {
            memory.unlinkNode(wm);
        } else if (stagedDeleteWasEmpty) {
            memory.setNodeDirty(wm);
        }
    }

    public void doUpdateRightTuple(RightTuple rightTuple, InternalWorkingMemory wm, BetaMemory memory) {
        RightTupleSets stagedRightTuples = memory.getStagedRightTuples();
        boolean stagedUpdateWasEmpty = false;
        if (this.streamMode) {
            stagedUpdateWasEmpty = memory.getSegmentMemory().getTupleQueue().isEmpty();
            PropagationContext pctx = rightTuple.getPropagationContext();
            memory.getSegmentMemory().getTupleQueue().add(new RightTupleEntry(rightTuple, pctx, memory, pctx.getType()));
        } else {
            stagedUpdateWasEmpty = stagedRightTuples.addUpdate(rightTuple);
        }
        if (stagedUpdateWasEmpty) {
            memory.setNodeDirty(wm);
        }
    }

    public boolean isRightInputIsRiaNode() {
        return this.rightInputIsRiaNode;
    }

    public ObjectSource getRightInput() {
        return this.rightInput;
    }

    public FastIterator getRightIterator(RightTupleMemory memory) {
        if (!this.indexedUnificationJoin) {
            return memory.fastIterator();
        }
        return memory.fullFastIterator();
    }

    public FastIterator getRightIterator(RightTupleMemory memory, RightTuple rightTuple) {
        if (!this.indexedUnificationJoin) {
            return memory.fastIterator();
        }
        return memory.fullFastIterator(rightTuple);
    }

    public FastIterator getLeftIterator(LeftTupleMemory memory) {
        if (!this.indexedUnificationJoin) {
            return memory.fastIterator();
        }
        return memory.fullFastIterator();
    }

    public RightTuple getFirstRightTuple(LeftTuple leftTuple, RightTupleMemory memory, InternalFactHandle factHandle, FastIterator it) {
        if (!this.indexedUnificationJoin) {
            return memory.getFirst(leftTuple, factHandle, it);
        }
        return (RightTuple)it.next(null);
    }

    public LeftTuple getFirstLeftTuple(RightTuple rightTuple, LeftTupleMemory memory, PropagationContext context, FastIterator it) {
        if (!this.indexedUnificationJoin) {
            return memory.getFirst(rightTuple);
        }
        return (LeftTuple)it.next(null);
    }

    public static RightTuple getFirstRightTuple(RightTupleMemory memory, FastIterator it) {
        if (!memory.isIndexed()) {
            return memory.getFirst(null, null, it);
        }
        return (RightTuple)it.next(null);
    }

    public static LeftTuple getFirstLeftTuple(LeftTupleMemory memory, FastIterator it) {
        if (!memory.isIndexed()) {
            return memory.getFirst(null);
        }
        return (LeftTuple)it.next(null);
    }

    public boolean isIndexedUnificationJoin() {
        return this.indexedUnificationJoin;
    }

    public BetaNodeFieldConstraint[] getConstraints() {
        return this.constraints.getConstraints();
    }

    public BetaConstraints getRawConstraints() {
        return this.constraints;
    }

    public void setConstraints(BetaConstraints constraints) {
        this.constraints = constraints.cloneIfInUse();
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        updateContext.startVisitNode(this.leftInput);
        this.rightInput.networkUpdated(updateContext);
        updateContext.endVisit();
        if (!updateContext.isVisiting(this.leftInput)) {
            this.leftInput.networkUpdated(updateContext);
        }
    }

    public List<String> getRules() {
        ArrayList<String> list = new ArrayList<String>();
        LeftTupleSink[] sinks = this.sink.getSinks();
        int length = sinks.length;
        for (int i = 0; i < length; ++i) {
            if (sinks[i].getType() == 101) {
                list.add(((RuleTerminalNode)sinks[i]).getRule().getName());
                continue;
            }
            if (!NodeTypeEnums.isBetaNode(sinks[i])) continue;
            list.addAll(((BetaNode)sinks[i]).getRules());
        }
        return list;
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        if (this.objectTypeNode == null) {
            ObjectSource source = this.rightInput;
            while (source != null) {
                if (source instanceof ObjectTypeNode) {
                    this.objectTypeNode = (ObjectTypeNode)source;
                    break;
                }
                source = source.source;
            }
        }
        return this.objectTypeNode;
    }

    @Override
    public void attach(BuildContext context) {
        this.constraints.init(context, this.getType());
        this.setUnificationJoin();
        this.rightInput.addObjectSink(this);
        this.leftInput.addTupleSink(this, context);
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public static BetaMemory getBetaMemory(BetaNode node, InternalWorkingMemory wm) {
        BetaMemory bm = node.getType() == 211 ? ((AccumulateNode.AccumulateMemory)wm.getNodeMemory(node)).getBetaMemory() : (BetaMemory)wm.getNodeMemory(node);
        return bm;
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemory;
    }

    public void setObjectMemoryEnabled(boolean objectMemory) {
        this.objectMemory = objectMemory;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public boolean isConcurrentRightTupleMemory() {
        return this.concurrentRightTupleMemory;
    }

    public void setConcurrentRightTupleMemory(boolean concurrentRightTupleMemory) {
        this.concurrentRightTupleMemory = concurrentRightTupleMemory;
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return this.constraints.createBetaMemory(config, this.getType());
    }

    @Override
    public String toString() {
        return "[ " + this.getClass().getSimpleName() + "(" + this.id + ") ]";
    }

    public void dumpMemory(InternalWorkingMemory workingMemory) {
        MemoryVisitor visitor = new MemoryVisitor(workingMemory);
        visitor.visit(this);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    @Override
    public int hashCode() {
        int hash = 23 * this.leftInput.hashCode() + 29 * this.rightInput.hashCode() + 31 * this.constraints.hashCode();
        if (this.leftListenedProperties != null) {
            hash += 37 * ((Object)this.leftListenedProperties).hashCode();
        }
        if (this.rightListenedProperties != null) {
            hash += 41 * ((Object)this.rightListenedProperties).hashCode();
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BetaNode)) {
            return false;
        }
        BetaNode other = (BetaNode)object;
        return this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints) && ClassUtils.areNullSafeEquals(this.leftListenedProperties, other.leftListenedProperties) && ClassUtils.areNullSafeEquals(this.rightListenedProperties, other.rightListenedProperties);
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }

    public RightTuple createRightTuple(InternalFactHandle handle, RightTupleSink sink, PropagationContext context) {
        RightTuple rightTuple = new RightTuple(handle, sink);
        rightTuple.setPropagationContext(context);
        return rightTuple;
    }

    public static Object getBetaMemoryFromRightInput(BetaNode betaNode, InternalWorkingMemory workingMemory) {
        BetaMemory memory = 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)workingMemory.getNodeMemory(betaNode)).getBetaMemory() : (BetaMemory)workingMemory.getNodeMemory(betaNode);
        if (memory.getSegmentMemory() == null) {
            SegmentUtilities.createSegmentMemory(betaNode, workingMemory);
        }
        return memory;
    }

    public long getRightDeclaredMask() {
        return this.rightDeclaredMask;
    }

    public void setRightDeclaredMask(long rightDeclaredMask) {
        this.rightDeclaredMask = rightDeclaredMask;
    }

    public long getRightInferredMask() {
        return this.rightInferredMask;
    }

    public long getRightNegativeMask() {
        return this.rightNegativeMask;
    }

    @Override
    public ObjectTypeNode.Id getRightInputOtnId() {
        return this.rightInputOtnId;
    }

    public void setRightInputOtnId(ObjectTypeNode.Id rightInputOtnId) {
        this.rightInputOtnId = rightInputOtnId;
    }
}

