/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.index.LeftTupleList;

public class LeftTupleRBTree<K extends Comparable<? super K>> {
    public static final boolean VERIFY_RBTREE = false;
    private static final int INDENT_STEP = 4;
    public Node<K> root;

    public void verifyProperties() {
    }

    private static void verifyProperty1(Node<?> n) {
        assert (LeftTupleRBTree.nodeColor(n) == Color.RED || LeftTupleRBTree.nodeColor(n) == Color.BLACK);
        if (n == null) {
            return;
        }
        LeftTupleRBTree.verifyProperty1(((Node)n).left);
        LeftTupleRBTree.verifyProperty1(((Node)n).right);
    }

    private static void verifyProperty2(Node<?> root) {
        assert (LeftTupleRBTree.nodeColor(root) == Color.BLACK);
    }

    private static Color nodeColor(Node<?> n) {
        return n == null ? Color.BLACK : ((Node)n).color;
    }

    private static void verifyProperty4(Node<?> n) {
        if (LeftTupleRBTree.nodeColor(n) == Color.RED) {
            assert (LeftTupleRBTree.nodeColor(((Node)n).left) == Color.BLACK);
            assert (LeftTupleRBTree.nodeColor(((Node)n).right) == Color.BLACK);
            assert (LeftTupleRBTree.nodeColor(((Node)n).parent) == Color.BLACK);
        }
        if (n == null) {
            return;
        }
        LeftTupleRBTree.verifyProperty4(((Node)n).left);
        LeftTupleRBTree.verifyProperty4(((Node)n).right);
    }

    private static void verifyProperty5(Node<?> root) {
        LeftTupleRBTree.verifyProperty5Helper(root, 0, -1);
    }

    private static int verifyProperty5Helper(Node<?> n, int blackCount, int pathBlackCount) {
        if (LeftTupleRBTree.nodeColor(n) == Color.BLACK) {
            ++blackCount;
        }
        if (n == null) {
            if (pathBlackCount == -1) {
                pathBlackCount = blackCount;
            } else assert (blackCount == pathBlackCount);
            return pathBlackCount;
        }
        pathBlackCount = LeftTupleRBTree.verifyProperty5Helper(((Node)n).left, blackCount, pathBlackCount);
        pathBlackCount = LeftTupleRBTree.verifyProperty5Helper(((Node)n).right, blackCount, pathBlackCount);
        return pathBlackCount;
    }

    public Node<K> lookup(K key) {
        Node n = this.root;
        while (n != null) {
            int compResult = key.compareTo(n.key);
            if (compResult == 0) {
                return n;
            }
            if (compResult < 0) {
                n = n.left;
                continue;
            }
            n = n.right;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public Node<K> first() {
        if (this.root == null) {
            return null;
        }
        Node n = this.root;
        while (n.left != null) {
            n = n.left;
        }
        return n;
    }

    public Node<K> last() {
        if (this.root == null) {
            return null;
        }
        Node n = this.root;
        while (n.right != null) {
            n = n.right;
        }
        return n;
    }

    public FastIterator fastIterator() {
        return this.root == null ? FastIterator.EMPTY : new RangeFastIterator<K>(this.first(), null);
    }

    public String toString() {
        FastIterator iterator = this.fastIterator();
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        Entry entry = iterator.next(null);
        while (entry != null) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry);
            entry = iterator.next(null);
        }
        sb.append("]");
        return sb.toString();
    }

    public FastIterator range(K lowerBound, boolean testLowerEqual, K upperBound, boolean testUpperEqual) {
        Node<K> lowerNearest = this.findNearestNode(lowerBound, testLowerEqual, Boundary.LOWER);
        Node<K> upperNearest = this.findNearestNode(upperBound, testUpperEqual, Boundary.UPPER);
        if (lowerNearest == null || upperNearest == null) {
            return FastIterator.EMPTY;
        }
        if (lowerNearest.key.compareTo(upperNearest.key) > 0) {
            upperNearest = lowerNearest;
        }
        return new RangeFastIterator<K>(lowerNearest, upperNearest);
    }

    public void rangeUperBounded(K upperBound, boolean testUpperEqual) {
        Node<K> upperNearest = this.findNearestNode(upperBound, testUpperEqual, Boundary.UPPER);
    }

    public void rangeLowerBounded(K upperBound, boolean testUpperEqual) {
        Node<K> upperNearest = this.findNearestNode(upperBound, testUpperEqual, Boundary.UPPER);
    }

    public Node<K> findNearestNode(K key, boolean allowEqual, Boundary boundary) {
        Node nearest = null;
        Node n = this.root;
        while (n != null) {
            int compResult = key.compareTo(n.key);
            if (allowEqual && compResult == 0) {
                return n;
            }
            boolean accepted = this.acceptNode(compResult, boundary);
            if (this.acceptNode(compResult, boundary) && (nearest == null || this.acceptNode(n.key.compareTo(nearest.key), boundary))) {
                nearest = n;
            }
            if (compResult == 0) {
                n = boundary == Boundary.LOWER ? n.right : n.left;
                continue;
            }
            n = accepted ^ boundary == Boundary.LOWER ? n.right : n.left;
        }
        return nearest;
    }

    private boolean acceptNode(int compResult, Boundary boundary) {
        return compResult != 0 && compResult > 0 ^ boundary == Boundary.LOWER;
    }

    private void rotateLeft(Node<K> n) {
        Node r = ((Node)n).right;
        this.replaceNode(n, r);
        ((Node)n).right = r.left;
        if (r.left != null) {
            r.left.parent = (Node)n;
        }
        r.left = (Node)n;
        ((Node)n).parent = r;
    }

    private void rotateRight(Node<K> n) {
        Node l = ((Node)n).left;
        this.replaceNode(n, l);
        ((Node)n).left = l.right;
        if (l.right != null) {
            l.right.parent = (Node)n;
        }
        l.right = (Node)n;
        ((Node)n).parent = l;
    }

    private void replaceNode(Node<K> oldn, Node<K> newn) {
        if (((Node)oldn).parent == null) {
            this.root = newn;
        } else if (oldn == ((Node)oldn).parent.left) {
            ((Node)oldn).parent.left = (Node)newn;
        } else {
            ((Node)oldn).parent.right = (Node)newn;
        }
        if (newn != null) {
            ((Node)newn).parent = ((Node)oldn).parent;
        }
    }

    public Node<K> insert(K key) {
        Node<K> insertedNode = new Node<K>(key);
        if (this.root == null) {
            this.root = insertedNode;
        } else {
            Node n = this.root;
            while (true) {
                int compResult;
                if ((compResult = key.compareTo(n.key)) == 0) {
                    return n;
                }
                if (compResult < 0) {
                    if (n.left == null) {
                        n.left = (Node)insertedNode;
                        break;
                    }
                    n = n.left;
                    continue;
                }
                if (n.right == null) {
                    n.right = (Node)insertedNode;
                    break;
                }
                n = n.right;
            }
            ((Node)insertedNode).parent = n;
        }
        this.insertCase1(insertedNode);
        return insertedNode;
    }

    private void insertCase1(Node<K> n) {
        if (((Node)n).parent == null) {
            ((Node)n).color = Color.BLACK;
        } else {
            this.insertCase2(n);
        }
    }

    private void insertCase2(Node<K> n) {
        if (LeftTupleRBTree.nodeColor(((Node)n).parent) == Color.BLACK) {
            return;
        }
        this.insertCase3(n);
    }

    void insertCase3(Node<K> n) {
        if (LeftTupleRBTree.nodeColor(n.uncle()) == Color.RED) {
            ((Node)n).parent.color = Color.BLACK;
            ((Node)n.uncle()).color = Color.BLACK;
            ((Node)n.grandparent()).color = Color.RED;
            this.insertCase1(n.grandparent());
        } else {
            this.insertCase4(n);
        }
    }

    void insertCase4(Node<K> n) {
        if (n == n.parent.right && n.parent == ((Node)n.grandparent()).left) {
            this.rotateLeft(n.parent);
            n = n.left;
        } else if (n == n.parent.left && n.parent == ((Node)n.grandparent()).right) {
            this.rotateRight(n.parent);
            n = n.right;
        }
        this.insertCase5(n);
    }

    void insertCase5(Node<K> n) {
        ((Node)n).parent.color = Color.BLACK;
        ((Node)n.grandparent()).color = Color.RED;
        if (n == ((Node)n).parent.left && ((Node)n).parent == ((Node)n.grandparent()).left) {
            this.rotateRight(n.grandparent());
        } else {
            this.rotateLeft(n.grandparent());
        }
    }

    public void delete(K key) {
        Node child;
        Node<K> n = this.lookup(key);
        if (n == null) {
            return;
        }
        if (((Node)n).left != null && ((Node)n).right != null) {
            Node<K> pred = LeftTupleRBTree.maximumNode(((Node)n).left);
            pred.copyStateInto(n);
            n = pred;
        }
        Node node = child = ((Node)n).right == null ? ((Node)n).left : ((Node)n).right;
        if (LeftTupleRBTree.nodeColor(n) == Color.BLACK) {
            ((Node)n).color = LeftTupleRBTree.nodeColor(child);
            this.deleteCase1(n);
        }
        this.replaceNode(n, child);
        if (LeftTupleRBTree.nodeColor(this.root) == Color.RED) {
            ((Node)this.root).color = Color.BLACK;
        }
        if (LeftTupleRBTree.nodeColor(this.root) == Color.RED) {
            ((Node)this.root).color = Color.BLACK;
        }
    }

    private static <K extends Comparable<? super K>, V> Node<K> maximumNode(Node<K> n) {
        while (n.right != null) {
            n = n.right;
        }
        return n;
    }

    private void deleteCase1(Node<K> n) {
        if (((Node)n).parent == null) {
            return;
        }
        this.deleteCase2(n);
    }

    private void deleteCase2(Node<K> n) {
        if (LeftTupleRBTree.nodeColor(n.sibling()) == Color.RED) {
            ((Node)n).parent.color = Color.RED;
            ((Node)n.sibling()).color = Color.BLACK;
            if (n == ((Node)n).parent.left) {
                this.rotateLeft(((Node)n).parent);
            } else {
                this.rotateRight(((Node)n).parent);
            }
        }
        this.deleteCase3(n);
    }

    private void deleteCase3(Node<K> n) {
        if (LeftTupleRBTree.nodeColor(((Node)n).parent) == Color.BLACK && LeftTupleRBTree.nodeColor(n.sibling()) == Color.BLACK && LeftTupleRBTree.nodeColor(((Node)n.sibling()).left) == Color.BLACK && LeftTupleRBTree.nodeColor(((Node)n.sibling()).right) == Color.BLACK) {
            ((Node)n.sibling()).color = Color.RED;
            this.deleteCase1(((Node)n).parent);
        } else {
            this.deleteCase4(n);
        }
    }

    private void deleteCase4(Node<K> n) {
        if (LeftTupleRBTree.nodeColor(((Node)n).parent) == Color.RED && LeftTupleRBTree.nodeColor(n.sibling()) == Color.BLACK && LeftTupleRBTree.nodeColor(((Node)n.sibling()).left) == Color.BLACK && LeftTupleRBTree.nodeColor(((Node)n.sibling()).right) == Color.BLACK) {
            ((Node)n.sibling()).color = Color.RED;
            ((Node)n).parent.color = Color.BLACK;
        } else {
            this.deleteCase5(n);
        }
    }

    private void deleteCase5(Node<K> n) {
        if (n == ((Node)n).parent.left && LeftTupleRBTree.nodeColor(n.sibling()) == Color.BLACK && LeftTupleRBTree.nodeColor(((Node)n.sibling()).left) == Color.RED && LeftTupleRBTree.nodeColor(((Node)n.sibling()).right) == Color.BLACK) {
            ((Node)n.sibling()).color = Color.RED;
            ((Node)n.sibling()).left.color = Color.BLACK;
            this.rotateRight(n.sibling());
        } else if (n == ((Node)n).parent.right && LeftTupleRBTree.nodeColor(n.sibling()) == Color.BLACK && LeftTupleRBTree.nodeColor(((Node)n.sibling()).right) == Color.RED && LeftTupleRBTree.nodeColor(((Node)n.sibling()).left) == Color.BLACK) {
            ((Node)n.sibling()).color = Color.RED;
            ((Node)n.sibling()).right.color = Color.BLACK;
            this.rotateLeft(n.sibling());
        }
        this.deleteCase6(n);
    }

    private void deleteCase6(Node<K> n) {
        ((Node)n.sibling()).color = LeftTupleRBTree.nodeColor(((Node)n).parent);
        ((Node)n).parent.color = Color.BLACK;
        if (n == ((Node)n).parent.left) {
            ((Node)n.sibling()).right.color = Color.BLACK;
            this.rotateLeft(((Node)n).parent);
        } else {
            ((Node)n.sibling()).left.color = Color.BLACK;
            this.rotateRight(((Node)n).parent);
        }
    }

    public void print() {
        LeftTupleRBTree.printHelper(this.root, 0);
    }

    private static void printHelper(Node<?> n, int indent) {
        if (n == null) {
            System.out.print("<empty tree>");
            return;
        }
        if (((Node)n).right != null) {
            LeftTupleRBTree.printHelper(((Node)n).right, indent + 4);
        }
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
        if (((Node)n).color == Color.BLACK) {
            System.out.println(n.key);
        } else {
            System.out.println("<" + n.key + ">");
        }
        if (((Node)n).left != null) {
            LeftTupleRBTree.printHelper(((Node)n).left, indent + 4);
        }
    }

    public static class Node<K extends Comparable<? super K>>
    extends LeftTupleList
    implements Entry,
    Comparable<Node<K>> {
        public K key;
        private Node<K> left;
        private Node<K> right;
        private Node<K> parent;
        private Color color = Color.RED;

        public Node(K key) {
            this.key = key;
        }

        public Node<K> grandparent() {
            return this.parent.parent;
        }

        public Node<K> sibling() {
            return this == this.parent.left ? this.parent.right : this.parent.left;
        }

        public Node<K> uncle() {
            return this.parent.sibling();
        }

        @Override
        public String toString() {
            return "Node key=" + this.key;
        }

        @Override
        public void setNext(Entry next) {
        }

        @Override
        public Entry getNext() {
            return null;
        }

        @Override
        public int compareTo(Node<K> other) {
            return this.key.compareTo(other.key);
        }

        protected void copyStateInto(Node<K> other) {
            super.copyStateInto(other);
            other.key = this.key;
        }
    }

    public static enum Color {
        RED,
        BLACK;

    }

    public static class RangeFastIterator<K extends Comparable<? super K>>
    implements FastIterator {
        private Node<K> upperBound;
        private Node<K> next;

        public RangeFastIterator(Node<K> lowerNearest, Node<K> upperNearest) {
            this.next = lowerNearest;
            this.upperBound = upperNearest;
        }

        @Override
        public Entry next(Entry object) {
            Node<K> temp = this.next;
            this.next = this.checkUpperBound(this.recurse(this.next));
            return temp;
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }

        private Node<K> recurse(Node<K> current) {
            if (current == null) {
                return null;
            }
            if (current.right != null) {
                Node p = current.right;
                while (p.left != null) {
                    p = p.left;
                }
                return p;
            }
            Node p = current.parent;
            Node ch = current;
            while (p != null && ch == p.right) {
                ch = p;
                p = p.parent;
            }
            return p;
        }

        public Node<K> checkUpperBound(Node<K> current) {
            if (this.upperBound == null) {
                return current;
            }
            return current == null || current.compareTo(this.upperBound) > 0 ? null : current;
        }
    }

    public static enum Boundary {
        LOWER,
        UPPER;

    }
}

