/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.XmlPlannerBenchmarkFactory;

public class FreemarkerXmlPlannerBenchmarkFactory
implements PlannerBenchmarkFactory {
    private XmlPlannerBenchmarkFactory xmlPlannerBenchmarkFactory = new XmlPlannerBenchmarkFactory();

    public FreemarkerXmlPlannerBenchmarkFactory() {
    }

    public FreemarkerXmlPlannerBenchmarkFactory(String templateResource) {
        this();
        this.configure(templateResource);
    }

    public XmlPlannerBenchmarkFactory getXmlPlannerBenchmarkFactory() {
        return this.xmlPlannerBenchmarkFactory;
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(String templateResource) {
        return this.configure(templateResource, null);
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(String templateResource, Object model) {
        InputStream templateIn = this.getClass().getResourceAsStream(templateResource);
        if (templateIn == null) {
            throw new IllegalArgumentException("Could not find templateResource (" + templateResource + ").");
        }
        return this.configure(templateIn, model);
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(InputStream templateIn) {
        return this.configure(templateIn, null);
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(InputStream templateIn, Object model) {
        FreemarkerXmlPlannerBenchmarkFactory freemarkerXmlPlannerBenchmarkFactory;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(templateIn, "UTF-8");
            freemarkerXmlPlannerBenchmarkFactory = this.configure(reader, model);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This vm does not support UTF-8 encoding.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)templateIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)templateIn);
        return freemarkerXmlPlannerBenchmarkFactory;
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(Reader templateReader) {
        return this.configure(templateReader, null);
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(Reader templateReader, Object model) {
        Template template;
        Configuration freemarkerCfg = new Configuration();
        freemarkerCfg.setDefaultEncoding("UTF-8");
        freemarkerCfg.setNumberFormat("computer");
        freemarkerCfg.setDateFormat("yyyy-mm-dd");
        freemarkerCfg.setDateTimeFormat("yyyy-mm-dd HH:mm:ss.SSS z");
        freemarkerCfg.setTimeFormat("HH:mm:ss.SSS");
        String templateFilename = "benchmarkTemplate.ftl";
        try {
            template = new Template(templateFilename, templateReader, freemarkerCfg, "UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not read template (" + templateFilename + ") from templateReader.", e);
        }
        return this.configure(template, model);
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(Template template) {
        return this.configure(template, null);
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(Template template, Object model) {
        StringWriter configWriter = new StringWriter();
        try {
            template.process(model, (Writer)configWriter);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not write to configWriter.", e);
        }
        catch (TemplateException e) {
            throw new IllegalArgumentException("Can not process Freemarker template to configWriter.", e);
        }
        finally {
            IOUtils.closeQuietly((Writer)configWriter);
        }
        StringReader configReader = new StringReader(configWriter.toString());
        this.xmlPlannerBenchmarkFactory.configure(configReader);
        return this;
    }

    @Override
    public PlannerBenchmarkConfig getPlannerBenchmarkConfig() {
        return this.xmlPlannerBenchmarkFactory.getPlannerBenchmarkConfig();
    }

    @Override
    public PlannerBenchmark buildPlannerBenchmark() {
        return this.xmlPlannerBenchmarkFactory.buildPlannerBenchmark();
    }
}

