/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.config.report.BenchmarkReportConfig;
import org.optaplanner.benchmark.impl.PlannerBenchmarkRunner;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="plannerBenchmark")
public class PlannerBenchmarkConfig {
    public static final String PARALLEL_BENCHMARK_COUNT_AUTO = "AUTO";
    public static final String AVAILABLE_PROCESSOR_COUNT = "availableProcessorCount";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name = null;
    private File benchmarkDirectory = null;
    private String parallelBenchmarkCount = null;
    private Long warmUpMillisecondsSpentLimit = null;
    private Long warmUpSecondsSpentLimit = null;
    private Long warmUpMinutesSpentLimit = null;
    private Long warmUpHoursSpentLimit = null;
    @XStreamAlias(value="benchmarkReport")
    private BenchmarkReportConfig benchmarkReportConfig = null;
    @XStreamAlias(value="inheritedSolverBenchmark")
    private SolverBenchmarkConfig inheritedSolverBenchmarkConfig = null;
    @XStreamImplicit(itemFieldName="solverBenchmark")
    private List<SolverBenchmarkConfig> solverBenchmarkConfigList = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public String getParallelBenchmarkCount() {
        return this.parallelBenchmarkCount;
    }

    public void setParallelBenchmarkCount(String parallelBenchmarkCount) {
        this.parallelBenchmarkCount = parallelBenchmarkCount;
    }

    public Long getWarmUpMillisecondsSpentLimit() {
        return this.warmUpMillisecondsSpentLimit;
    }

    public void setWarmUpMillisecondsSpentLimit(Long warmUpMillisecondsSpentLimit) {
        this.warmUpMillisecondsSpentLimit = warmUpMillisecondsSpentLimit;
    }

    public Long getWarmUpSecondsSpentLimit() {
        return this.warmUpSecondsSpentLimit;
    }

    public void setWarmUpSecondsSpentLimit(Long warmUpSecondsSpentLimit) {
        this.warmUpSecondsSpentLimit = warmUpSecondsSpentLimit;
    }

    public Long getWarmUpMinutesSpentLimit() {
        return this.warmUpMinutesSpentLimit;
    }

    public void setWarmUpMinutesSpentLimit(Long warmUpMinutesSpentLimit) {
        this.warmUpMinutesSpentLimit = warmUpMinutesSpentLimit;
    }

    public Long getWarmUpHoursSpentLimit() {
        return this.warmUpHoursSpentLimit;
    }

    public void setWarmUpHoursSpentLimit(Long warmUpHoursSpentLimit) {
        this.warmUpHoursSpentLimit = warmUpHoursSpentLimit;
    }

    public BenchmarkReportConfig getBenchmarkReportConfig() {
        return this.benchmarkReportConfig;
    }

    public void setBenchmarkReportConfig(BenchmarkReportConfig benchmarkReportConfig) {
        this.benchmarkReportConfig = benchmarkReportConfig;
    }

    public SolverBenchmarkConfig getInheritedSolverBenchmarkConfig() {
        return this.inheritedSolverBenchmarkConfig;
    }

    public void setInheritedSolverBenchmarkConfig(SolverBenchmarkConfig inheritedSolverBenchmarkConfig) {
        this.inheritedSolverBenchmarkConfig = inheritedSolverBenchmarkConfig;
    }

    public List<SolverBenchmarkConfig> getSolverBenchmarkConfigList() {
        return this.solverBenchmarkConfigList;
    }

    public void setSolverBenchmarkConfigList(List<SolverBenchmarkConfig> solverBenchmarkConfigList) {
        this.solverBenchmarkConfigList = solverBenchmarkConfigList;
    }

    public PlannerBenchmark buildPlannerBenchmark() {
        this.validate();
        this.generateSolverBenchmarkConfigNames();
        this.inherit();
        PlannerBenchmarkResult plannerBenchmarkResult = new PlannerBenchmarkResult();
        plannerBenchmarkResult.setName(this.name);
        plannerBenchmarkResult.setAggregation(false);
        PlannerBenchmarkRunner plannerBenchmarkRunner = new PlannerBenchmarkRunner(plannerBenchmarkResult);
        plannerBenchmarkRunner.setBenchmarkDirectory(this.benchmarkDirectory);
        plannerBenchmarkResult.setParallelBenchmarkCount(this.resolveParallelBenchmarkCount());
        plannerBenchmarkResult.setWarmUpTimeMillisSpentLimit(this.calculateWarmUpTimeMillisSpentLimit());
        BenchmarkReportConfig benchmarkReportConfig_ = this.benchmarkReportConfig == null ? new BenchmarkReportConfig() : this.benchmarkReportConfig;
        plannerBenchmarkRunner.setBenchmarkReport(benchmarkReportConfig_.buildBenchmarkReport(plannerBenchmarkResult));
        ArrayList<SolverBenchmarkResult> solverBenchmarkResultList = new ArrayList<SolverBenchmarkResult>(this.solverBenchmarkConfigList.size());
        ArrayList<ProblemBenchmarkResult> unifiedProblemBenchmarkResultList = new ArrayList<ProblemBenchmarkResult>();
        plannerBenchmarkResult.setUnifiedProblemBenchmarkResultList(unifiedProblemBenchmarkResultList);
        for (SolverBenchmarkConfig solverBenchmarkConfig : this.solverBenchmarkConfigList) {
            SolverBenchmarkResult solverBenchmarkResult = solverBenchmarkConfig.buildSolverBenchmark(plannerBenchmarkResult);
            solverBenchmarkResultList.add(solverBenchmarkResult);
        }
        plannerBenchmarkResult.setSolverBenchmarkResultList(solverBenchmarkResultList);
        return plannerBenchmarkRunner;
    }

    protected void validate() {
        String nameRegex = "^[\\w\\d _\\-\\.\\(\\)]+$";
        if (this.name != null && !this.name.matches("^[\\w\\d _\\-\\.\\(\\)]+$")) {
            throw new IllegalStateException("The plannerBenchmark name (" + this.name + ") is invalid because it does not follow the nameRegex (" + "^[\\w\\d _\\-\\.\\(\\)]+$" + ")" + " which might cause an illegal filename.");
        }
        if (this.solverBenchmarkConfigList == null || this.solverBenchmarkConfigList.isEmpty()) {
            throw new IllegalArgumentException("Configure at least 1 <solverBenchmark> in the <plannerBenchmark> configuration.");
        }
    }

    protected void generateSolverBenchmarkConfigNames() {
        HashSet<String> nameSet = new HashSet<String>(this.solverBenchmarkConfigList.size());
        LinkedHashSet<SolverBenchmarkConfig> noNameBenchmarkConfigSet = new LinkedHashSet<SolverBenchmarkConfig>(this.solverBenchmarkConfigList.size());
        for (SolverBenchmarkConfig solverBenchmarkConfig : this.solverBenchmarkConfigList) {
            if (solverBenchmarkConfig.getName() != null) {
                boolean unique = nameSet.add(solverBenchmarkConfig.getName());
                if (unique) continue;
                throw new IllegalStateException("The benchmark name (" + solverBenchmarkConfig.getName() + ") is used in more than 1 benchmark.");
            }
            noNameBenchmarkConfigSet.add(solverBenchmarkConfig);
        }
        int generatedNameIndex = 0;
        for (SolverBenchmarkConfig solverBenchmarkConfig : noNameBenchmarkConfigSet) {
            String generatedName = "Config_" + generatedNameIndex;
            while (nameSet.contains(generatedName)) {
                generatedName = "Config_" + ++generatedNameIndex;
            }
            solverBenchmarkConfig.setName(generatedName);
            ++generatedNameIndex;
        }
    }

    protected void inherit() {
        if (this.inheritedSolverBenchmarkConfig != null) {
            for (SolverBenchmarkConfig solverBenchmarkConfig : this.solverBenchmarkConfigList) {
                solverBenchmarkConfig.inherit(this.inheritedSolverBenchmarkConfig);
            }
        }
    }

    protected int resolveParallelBenchmarkCount() {
        int resolvedParallelBenchmarkCount;
        int availableProcessorCount = Runtime.getRuntime().availableProcessors();
        if (this.parallelBenchmarkCount == null) {
            resolvedParallelBenchmarkCount = 1;
        } else if (this.parallelBenchmarkCount.equals(PARALLEL_BENCHMARK_COUNT_AUTO)) {
            resolvedParallelBenchmarkCount = availableProcessorCount <= 2 ? 1 : (availableProcessorCount <= 4 ? 2 : availableProcessorCount / 2 + 1);
        } else {
            Object scriptResult;
            String scriptLanguage = "JavaScript";
            ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName(scriptLanguage);
            scriptEngine.put(AVAILABLE_PROCESSOR_COUNT, availableProcessorCount);
            try {
                scriptResult = scriptEngine.eval(this.parallelBenchmarkCount);
            }
            catch (ScriptException e) {
                throw new IllegalArgumentException("The parallelBenchmarkCount (" + this.parallelBenchmarkCount + ") is not " + PARALLEL_BENCHMARK_COUNT_AUTO + " and cannot be parsed in " + scriptLanguage + " with the variables ([" + AVAILABLE_PROCESSOR_COUNT + "]).", e);
            }
            if (!(scriptResult instanceof Number)) {
                throw new IllegalArgumentException("The parallelBenchmarkCount (" + this.parallelBenchmarkCount + ") is resolved to scriptResult (" + scriptResult + ") in " + scriptLanguage + " and is not a Number.");
            }
            resolvedParallelBenchmarkCount = ((Number)scriptResult).intValue();
        }
        if (resolvedParallelBenchmarkCount < 1) {
            throw new IllegalArgumentException("The parallelBenchmarkCount (" + this.parallelBenchmarkCount + ") resulted in a resolvedParallelBenchmarkCount (" + resolvedParallelBenchmarkCount + ") that is lower than 1.");
        }
        if (resolvedParallelBenchmarkCount > availableProcessorCount) {
            this.logger.warn("Because the resolvedParallelBenchmarkCount (" + resolvedParallelBenchmarkCount + ") is higher than the availableProcessorCount (" + availableProcessorCount + "), it is reduced to availableProcessorCount.");
            resolvedParallelBenchmarkCount = availableProcessorCount;
        }
        return resolvedParallelBenchmarkCount;
    }

    protected long calculateWarmUpTimeMillisSpentLimit() {
        long warmUpTimeMillisSpentLimit = 0L;
        if (this.warmUpMillisecondsSpentLimit != null) {
            warmUpTimeMillisSpentLimit += this.warmUpMillisecondsSpentLimit.longValue();
        }
        if (this.warmUpSecondsSpentLimit != null) {
            warmUpTimeMillisSpentLimit += this.warmUpSecondsSpentLimit * 1000L;
        }
        if (this.warmUpMinutesSpentLimit != null) {
            warmUpTimeMillisSpentLimit += this.warmUpMinutesSpentLimit * 60000L;
        }
        if (this.warmUpHoursSpentLimit != null) {
            warmUpTimeMillisSpentLimit += this.warmUpHoursSpentLimit * 3600000L;
        }
        return warmUpTimeMillisSpentLimit;
    }
}

