/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.aggregator.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.drools.core.util.StringUtils;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.report.BenchmarkReportConfig;
import org.optaplanner.benchmark.impl.aggregator.BenchmarkAggregator;
import org.optaplanner.benchmark.impl.aggregator.swingui.CheckBoxTree;
import org.optaplanner.benchmark.impl.aggregator.swingui.MixedCheckBox;
import org.optaplanner.benchmark.impl.aggregator.swingui.SwingUncaughtExceptionHandler;
import org.optaplanner.benchmark.impl.aggregator.swingui.SwingUtils;
import org.optaplanner.benchmark.impl.result.BenchmarkResultIO;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkAggregatorFrame
extends JFrame {
    private static final String DETAIL_TEMPLATE_PLANNER_BENCHMARK = "Average score: %s%nAverage problem scale: %d";
    private static final String DETAIL_TEMPLATE_PROBLEM_BENCHMARK = "Problem scale: %d%nUsed memory: %s";
    private static final String DETAIL_TEMPLATE_SINGLE_BENCHMARK = "Score: %s%nPlanning entity count: %d%nUsed memory: %s%nTime spent: %d ms";
    private static final String DETAIL_TEMPLATE_SOLVER_BENCHMARK = "Average score: %s%nTotal score: %s%nAverage time spent: %d ms%nTotal winning score difference: %s";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BenchmarkAggregator benchmarkAggregator;
    private final BenchmarkResultIO benchmarkResultIO;
    private List<PlannerBenchmarkResult> plannerBenchmarkResultList;
    private Map<MixedCheckBox, SingleBenchmarkResult> resultCheckBoxMapping = new LinkedHashMap<MixedCheckBox, SingleBenchmarkResult>();
    private Map<SolverBenchmarkResult, String> solverBenchmarkResultNameMapping = new HashMap<SolverBenchmarkResult, String>();
    private CheckBoxTree checkBoxTree;
    private JTextArea detailTextArea;
    private JProgressBar generateProgressBar;

    public static void createAndDisplay(PlannerBenchmarkFactory plannerBenchmarkFactory) {
        SwingUncaughtExceptionHandler.register();
        SwingUtils.fixateLookAndFeel();
        PlannerBenchmarkConfig plannerBenchmarkConfig = plannerBenchmarkFactory.getPlannerBenchmarkConfig();
        BenchmarkAggregator benchmarkAggregator = new BenchmarkAggregator();
        benchmarkAggregator.setBenchmarkDirectory(plannerBenchmarkConfig.getBenchmarkDirectory());
        BenchmarkReportConfig benchmarkReportConfig = plannerBenchmarkConfig.getBenchmarkReportConfig();
        if (benchmarkReportConfig == null) {
            benchmarkReportConfig = new BenchmarkReportConfig();
        }
        benchmarkAggregator.setBenchmarkReportConfig(benchmarkReportConfig);
        BenchmarkAggregatorFrame benchmarkAggregatorFrame = new BenchmarkAggregatorFrame(benchmarkAggregator);
        benchmarkAggregatorFrame.init();
        benchmarkAggregatorFrame.setVisible(true);
    }

    public BenchmarkAggregatorFrame(BenchmarkAggregator benchmarkAggregator) {
        super("Benchmark aggregator");
        this.benchmarkAggregator = benchmarkAggregator;
        this.benchmarkResultIO = new BenchmarkResultIO();
        this.plannerBenchmarkResultList = Collections.emptyList();
    }

    public void init() {
        this.setDefaultCloseOperation(3);
        this.initPlannerBenchmarkResultList();
        this.setContentPane(this.createContentPane());
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JComponent createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        if (this.plannerBenchmarkResultList.isEmpty()) {
            contentPane.add((Component)this.createNoPlannerFoundTextField(), "Center");
        } else {
            contentPane.add((Component)this.createTopButtonPanel(), "North");
            contentPane.add((Component)this.createBenchmarkTreePanel(), "Center");
        }
        contentPane.add((Component)this.createDetailTextArea(), "South");
        return contentPane;
    }

    private JComponent createNoPlannerFoundTextField() {
        String infoMessage = "No planner benchmarks have been found in the benchmarkDirectory (" + this.benchmarkAggregator.getBenchmarkDirectory() + ").";
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setText(infoMessage);
        StyledDocument styledDocument = textPane.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        StyleConstants.setBold(center, true);
        styledDocument.setParagraphAttributes(0, styledDocument.getLength(), center, false);
        return textPane;
    }

    private JComponent createDetailTextArea() {
        JPanel detailPanel = new JPanel(new BorderLayout());
        JLabel detailLabel = new JLabel("Details");
        detailPanel.add((Component)detailLabel, "North");
        this.detailTextArea = new JTextArea(5, 80);
        this.detailTextArea.setEditable(false);
        JScrollPane detailScrollPane = new JScrollPane(this.detailTextArea, 22, 30);
        detailPanel.add((Component)detailScrollPane, "South");
        return detailPanel;
    }

    private JComponent createTopButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 5));
        buttonPanel.add(new JButton(new ExpandAllNodesAction()));
        buttonPanel.add(new JButton(new CollapseAllNodesAction()));
        buttonPanel.add(new JButton(new MoveNodeAction(true)));
        buttonPanel.add(new JButton(new MoveNodeAction(false)));
        buttonPanel.add(new JButton(new RenameNodeAction()));
        return buttonPanel;
    }

    private JComponent createBenchmarkTreePanel() {
        JPanel benchmarkTreePanel = new JPanel(new BorderLayout());
        CheckBoxTree checkBoxTree = this.createCheckBoxTree();
        benchmarkTreePanel.add((Component)new JScrollPane(checkBoxTree), "Center");
        JPanel buttonPanelWrapper = new JPanel(new FlowLayout(2));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        JButton generateReportButton = new JButton(new GenerateReportAction(this));
        buttonPanel.add(generateReportButton);
        this.generateProgressBar = new JProgressBar();
        buttonPanel.add(this.generateProgressBar);
        buttonPanelWrapper.add(buttonPanel);
        benchmarkTreePanel.add((Component)buttonPanelWrapper, "South");
        benchmarkTreePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        return benchmarkTreePanel;
    }

    private CheckBoxTree createCheckBoxTree() {
        CheckBoxTree resultCheckBoxTree = new CheckBoxTree(this.initBenchmarkHierarchy());
        resultCheckBoxTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath treeSelectionPath = e.getNewLeadSelectionPath();
                if (treeSelectionPath != null) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treeSelectionPath.getLastPathComponent();
                    MixedCheckBox checkBox = (MixedCheckBox)treeNode.getUserObject();
                    BenchmarkAggregatorFrame.this.detailTextArea.setText(checkBox.getDetail());
                    BenchmarkAggregatorFrame.this.detailTextArea.setCaretPosition(0);
                }
            }
        });
        this.checkBoxTree = resultCheckBoxTree;
        return resultCheckBoxTree;
    }

    private void initPlannerBenchmarkResultList() {
        this.plannerBenchmarkResultList = this.benchmarkResultIO.readPlannerBenchmarkResultList(this.benchmarkAggregator.getBenchmarkDirectory());
        for (PlannerBenchmarkResult plannerBenchmarkResult : this.plannerBenchmarkResultList) {
            plannerBenchmarkResult.accumulateResults(this.benchmarkAggregator.getBenchmarkReportConfig().buildBenchmarkReport(plannerBenchmarkResult));
        }
    }

    private DefaultMutableTreeNode initBenchmarkHierarchy() {
        DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode(new MixedCheckBox("Planner benchmarks"));
        for (PlannerBenchmarkResult plannerBenchmarkResult : this.plannerBenchmarkResultList) {
            DefaultMutableTreeNode plannerNode = new DefaultMutableTreeNode(this.createPlannerBenchmarkCheckBox(plannerBenchmarkResult));
            parentNode.add(plannerNode);
            for (SolverBenchmarkResult solverBenchmarkResult : plannerBenchmarkResult.getSolverBenchmarkResultList()) {
                DefaultMutableTreeNode solverNode = new DefaultMutableTreeNode(this.createSolverBenchmarkCheckBox(solverBenchmarkResult));
                plannerNode.add(solverNode);
                for (ProblemBenchmarkResult problemBenchmarkResult : plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
                    DefaultMutableTreeNode problemNode = new DefaultMutableTreeNode(this.createProblemBenchmarkCheckBox(problemBenchmarkResult));
                    solverNode.add(problemNode);
                    for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                        if (!singleBenchmarkResult.getProblemBenchmarkResult().equals(problemBenchmarkResult)) continue;
                        DefaultMutableTreeNode singleNode = new DefaultMutableTreeNode(this.createSingleBenchmarkCheckBox(singleBenchmarkResult));
                        problemNode.add(singleNode);
                    }
                }
            }
        }
        return parentNode;
    }

    private MixedCheckBox createPlannerBenchmarkCheckBox(PlannerBenchmarkResult plannerBenchmarkResult) {
        String plannerBenchmarkDetail = String.format(DETAIL_TEMPLATE_PLANNER_BENCHMARK, plannerBenchmarkResult.getAverageScore(), plannerBenchmarkResult.getAverageProblemScale());
        return new MixedCheckBox(plannerBenchmarkResult.getName(), plannerBenchmarkDetail, plannerBenchmarkResult);
    }

    private MixedCheckBox createSolverBenchmarkCheckBox(SolverBenchmarkResult solverBenchmarkResult) {
        String solverCheckBoxName = solverBenchmarkResult.getName() + " (" + solverBenchmarkResult.getRanking() + ")";
        String solverBenchmarkDetail = String.format(DETAIL_TEMPLATE_SOLVER_BENCHMARK, solverBenchmarkResult.getAverageScore(), solverBenchmarkResult.getTotalScore(), solverBenchmarkResult.getAverageTimeMillisSpent(), solverBenchmarkResult.getTotalWinningScoreDifference());
        this.solverBenchmarkResultNameMapping.put(solverBenchmarkResult, solverBenchmarkResult.getName());
        return new MixedCheckBox(solverCheckBoxName, solverBenchmarkDetail, solverBenchmarkResult);
    }

    private MixedCheckBox createProblemBenchmarkCheckBox(ProblemBenchmarkResult problemBenchmarkResult) {
        String problemBenchmarkDetail = String.format(DETAIL_TEMPLATE_PROBLEM_BENCHMARK, problemBenchmarkResult.getProblemScale(), this.toEmptyStringIfNull(problemBenchmarkResult.getAverageUsedMemoryAfterInputSolution()));
        return new MixedCheckBox(problemBenchmarkResult.getName(), problemBenchmarkDetail);
    }

    private MixedCheckBox createSingleBenchmarkCheckBox(SingleBenchmarkResult singleBenchmarkResult) {
        String singleCheckBoxName = singleBenchmarkResult.getName() + " (" + singleBenchmarkResult.getRanking() + ")";
        String singleBenchmarkDetail = String.format(DETAIL_TEMPLATE_SINGLE_BENCHMARK, singleBenchmarkResult.getScore(), singleBenchmarkResult.getPlanningEntityCount(), this.toEmptyStringIfNull(singleBenchmarkResult.getUsedMemoryAfterInputSolution()), singleBenchmarkResult.getTimeMillisSpent());
        MixedCheckBox singleBenchmarkCheckBox = new MixedCheckBox(singleCheckBoxName, singleBenchmarkDetail);
        this.resultCheckBoxMapping.put(singleBenchmarkCheckBox, singleBenchmarkResult);
        return singleBenchmarkCheckBox;
    }

    private String toEmptyStringIfNull(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    private class ReportFinishedDialog
    extends JDialog {
        public ReportFinishedDialog(final JFrame parentFrame, final File reportFile) {
            super((Frame)parentFrame, "Report generation finished");
            JPanel contentPanel = new JPanel(new GridLayout(1, 3, 10, 10));
            final JCheckBox exitCheckBox = new JCheckBox("Exit application");
            exitCheckBox.setSelected(true);
            JButton openBrowserButton = new JButton("Show in browser");
            openBrowserButton.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportFinishedDialog.this.openReportFile(reportFile.getAbsoluteFile(), Desktop.Action.BROWSE);
                    if (exitCheckBox.isSelected()) {
                        parentFrame.dispose();
                    }
                }
            });
            contentPanel.add(openBrowserButton);
            JButton openFileButton = new JButton("Show in files");
            openFileButton.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportFinishedDialog.this.openReportFile(reportFile.getParentFile(), Desktop.Action.OPEN);
                    if (exitCheckBox.isSelected()) {
                        parentFrame.dispose();
                    }
                }
            });
            contentPanel.add(openFileButton);
            JButton closeButton = new JButton("Ok");
            closeButton.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (exitCheckBox.isSelected()) {
                        parentFrame.dispose();
                    } else {
                        ReportFinishedDialog.this.dispose();
                    }
                }
            });
            contentPanel.add(closeButton);
            JPanel mainPanel = new JPanel(new BorderLayout(0, 10));
            mainPanel.add((Component)exitCheckBox, "North");
            mainPanel.add((Component)contentPanel, "Center");
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add(mainPanel);
            this.pack();
        }

        private void openReportFile(File file, Desktop.Action action) {
            Desktop desktop = Desktop.getDesktop();
            try {
                switch (action) {
                    case OPEN: {
                        if (!desktop.isSupported(Desktop.Action.OPEN)) break;
                        desktop.open(file);
                        break;
                    }
                    case BROWSE: {
                        if (!desktop.isSupported(Desktop.Action.BROWSE)) break;
                        desktop.browse(file.toURI());
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private class GenerateReportWorker
    extends SwingWorker<File, Void> {
        private JFrame parentFrame;
        private List<SingleBenchmarkResult> singleBenchmarkResultList;

        public GenerateReportWorker(JFrame parentFrame, List<SingleBenchmarkResult> singleBenchmarkResultList) {
            this.parentFrame = parentFrame;
            this.singleBenchmarkResultList = singleBenchmarkResultList;
        }

        @Override
        protected File doInBackground() {
            return BenchmarkAggregatorFrame.this.benchmarkAggregator.aggregate(this.singleBenchmarkResultList, BenchmarkAggregatorFrame.this.solverBenchmarkResultNameMapping);
        }

        @Override
        protected void done() {
            try {
                File htmlOverviewFile = (File)this.get();
                ReportFinishedDialog dialog = new ReportFinishedDialog(this.parentFrame, htmlOverviewFile);
                dialog.pack();
                dialog.setLocationRelativeTo(BenchmarkAggregatorFrame.this);
                dialog.setVisible(true);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
            finally {
                this.parentFrame.setEnabled(true);
                BenchmarkAggregatorFrame.this.detailTextArea.setText(null);
                BenchmarkAggregatorFrame.this.generateProgressBar.setIndeterminate(false);
                BenchmarkAggregatorFrame.this.generateProgressBar.setString(null);
                BenchmarkAggregatorFrame.this.generateProgressBar.setStringPainted(false);
            }
        }
    }

    private class RenameNodeDialog
    extends JDialog {
        public RenameNodeDialog(final DefaultMutableTreeNode treeNode) {
            super((Frame)BenchmarkAggregatorFrame.this, "Rename node");
            final MixedCheckBox mixedCheckBox = (MixedCheckBox)treeNode.getUserObject();
            final Object benchmarkResult = mixedCheckBox.getBenchmarkResult();
            JPanel mainPanel = new JPanel(new BorderLayout());
            final JTextField benchmarkResultNameTextField = new JTextField(benchmarkResult.toString(), 30);
            mainPanel.add((Component)benchmarkResultNameTextField, "West");
            JButton confirmRenameButton = new JButton("Rename");
            mainPanel.add((Component)confirmRenameButton, "East");
            this.setContentPane(mainPanel);
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            confirmRenameButton.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newBenchmarkResultName = benchmarkResultNameTextField.getText();
                    if (StringUtils.isEmpty((CharSequence)newBenchmarkResultName)) {
                        JOptionPane.showMessageDialog(BenchmarkAggregatorFrame.this, "New benchmark's name cannot be empty.", "Warning", 2);
                    } else {
                        if (benchmarkResult instanceof PlannerBenchmarkResult) {
                            ((PlannerBenchmarkResult)benchmarkResult).setName(newBenchmarkResultName);
                            mixedCheckBox.setText(newBenchmarkResultName);
                            ((DefaultTreeModel)BenchmarkAggregatorFrame.this.checkBoxTree.getModel()).nodeChanged(treeNode);
                        } else if (benchmarkResult instanceof SolverBenchmarkResult) {
                            mixedCheckBox.setText(newBenchmarkResultName + " (" + ((SolverBenchmarkResult)benchmarkResult).getRanking() + ")");
                            ((DefaultTreeModel)BenchmarkAggregatorFrame.this.checkBoxTree.getModel()).nodeChanged(treeNode);
                            BenchmarkAggregatorFrame.this.solverBenchmarkResultNameMapping.put((SolverBenchmarkResult)benchmarkResult, newBenchmarkResultName);
                        }
                        RenameNodeDialog.this.dispose();
                    }
                }
            });
        }
    }

    private class RenameNodeAction
    extends AbstractAction {
        public RenameNodeAction() {
            super("Rename");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode selectedNode;
            if (BenchmarkAggregatorFrame.this.checkBoxTree.getSelectionPath() != null && (selectedNode = (DefaultMutableTreeNode)BenchmarkAggregatorFrame.this.checkBoxTree.getSelectionPath().getLastPathComponent()) != null && ((MixedCheckBox)selectedNode.getUserObject()).getBenchmarkResult() != null) {
                RenameNodeDialog renameNodeDialog = new RenameNodeDialog(selectedNode);
                renameNodeDialog.pack();
                renameNodeDialog.setLocationRelativeTo(BenchmarkAggregatorFrame.this);
                renameNodeDialog.setVisible(true);
            }
        }
    }

    private class MoveNodeAction
    extends AbstractAction {
        private boolean directionUp;

        public MoveNodeAction(boolean directionUp) {
            super(directionUp ? "Move up" : "Move down");
            this.directionUp = directionUp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode selectedNode;
            DefaultMutableTreeNode parentNode;
            if (BenchmarkAggregatorFrame.this.checkBoxTree.getSelectionPath() != null && (parentNode = (DefaultMutableTreeNode)(selectedNode = (DefaultMutableTreeNode)BenchmarkAggregatorFrame.this.checkBoxTree.getSelectionPath().getLastPathComponent()).getParent()) != null) {
                DefaultMutableTreeNode immediateSiblingNode;
                DefaultMutableTreeNode defaultMutableTreeNode = immediateSiblingNode = this.directionUp ? (DefaultMutableTreeNode)parentNode.getChildBefore(selectedNode) : (DefaultMutableTreeNode)parentNode.getChildAfter(selectedNode);
                if (immediateSiblingNode != null) {
                    parentNode.insert(immediateSiblingNode, parentNode.getIndex(selectedNode));
                    ((DefaultTreeModel)BenchmarkAggregatorFrame.this.checkBoxTree.getModel()).nodeStructureChanged(parentNode);
                    BenchmarkAggregatorFrame.this.checkBoxTree.setSelectionPath(new TreePath(selectedNode.getPath()));
                }
            }
        }
    }

    private class CollapseAllNodesAction
    extends AbstractAction {
        public CollapseAllNodesAction() {
            super("Collapse all", new ImageIcon(BenchmarkAggregatorFrame.class.getResource("collapseAll.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BenchmarkAggregatorFrame.this.checkBoxTree.collapseAllNodes();
        }
    }

    private class ExpandAllNodesAction
    extends AbstractAction {
        public ExpandAllNodesAction() {
            super("Expand all", new ImageIcon(BenchmarkAggregatorFrame.class.getResource("expandAll.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BenchmarkAggregatorFrame.this.checkBoxTree.expandAllNodes();
        }
    }

    private class GenerateReportAction
    extends AbstractAction {
        private JFrame parentFrame;

        public GenerateReportAction(JFrame parentFrame) {
            super("Generate report");
            this.parentFrame = parentFrame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parentFrame.setEnabled(false);
            this.generateReport();
        }

        private void generateReport() {
            ArrayList<SingleBenchmarkResult> singleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
            for (Map.Entry entry : BenchmarkAggregatorFrame.this.resultCheckBoxMapping.entrySet()) {
                if (MixedCheckBox.MixedCheckBoxStatus.CHECKED != ((MixedCheckBox)entry.getKey()).getStatus()) continue;
                singleBenchmarkResultList.add((SingleBenchmarkResult)entry.getValue());
            }
            if (singleBenchmarkResultList.isEmpty()) {
                JOptionPane.showMessageDialog(this.parentFrame, "No single benchmarks have been selected.", "Warning", 2);
                this.parentFrame.setEnabled(true);
            } else {
                BenchmarkAggregatorFrame.this.generateProgressBar.setIndeterminate(true);
                BenchmarkAggregatorFrame.this.generateProgressBar.setStringPainted(true);
                BenchmarkAggregatorFrame.this.generateProgressBar.setString("Generating...");
                GenerateReportWorker worker = new GenerateReportWorker(this.parentFrame, singleBenchmarkResultList);
                worker.execute();
            }
        }
    }
}

