/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.measurement;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.ScoreUtils;

public class ScoreDifferencePercentage
implements Serializable {
    private final double[] percentageLevels;

    public static <S extends Score> ScoreDifferencePercentage calculateScoreDifferencePercentage(Score<S> baseScore, Score<S> valueScore) {
        double[] valueLevels;
        double[] baseLevels = ScoreUtils.extractLevelDoubles(baseScore);
        if (baseLevels.length != (valueLevels = ScoreUtils.extractLevelDoubles(valueScore)).length) {
            throw new IllegalStateException("The baseScore (" + baseScore + ")'s levelsLength (" + baseLevels.length + ") is different from the valueScore (" + valueScore + ")'s levelsLength (" + valueLevels.length + ").");
        }
        double[] percentageLevels = new double[baseLevels.length];
        for (int i = 0; i < baseLevels.length; ++i) {
            percentageLevels[i] = ScoreDifferencePercentage.calculatePercentageLevel(baseLevels[i], valueLevels[i]);
        }
        return new ScoreDifferencePercentage(percentageLevels);
    }

    private static double calculatePercentageLevel(double baseLevel, double valueLevel) {
        double differenceLevel = valueLevel - baseLevel;
        if (baseLevel < 0.0) {
            return differenceLevel / -baseLevel;
        }
        if (baseLevel == 0.0) {
            if (differenceLevel == 0.0) {
                return 0.0;
            }
            return differenceLevel / baseLevel;
        }
        return differenceLevel / baseLevel;
    }

    public ScoreDifferencePercentage(double[] percentageLevels) {
        this.percentageLevels = percentageLevels;
    }

    public double[] getPercentageLevels() {
        return this.percentageLevels;
    }

    public ScoreDifferencePercentage add(ScoreDifferencePercentage augment) {
        double[] newPercentageLevels = new double[this.percentageLevels.length];
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            newPercentageLevels[i] = this.percentageLevels[i] + augment.percentageLevels[i];
        }
        return new ScoreDifferencePercentage(newPercentageLevels);
    }

    public ScoreDifferencePercentage subtract(ScoreDifferencePercentage subtrahend) {
        double[] newPercentageLevels = new double[this.percentageLevels.length];
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            newPercentageLevels[i] = this.percentageLevels[i] - subtrahend.percentageLevels[i];
        }
        return new ScoreDifferencePercentage(newPercentageLevels);
    }

    public ScoreDifferencePercentage multiply(double multiplicand) {
        double[] newPercentageLevels = new double[this.percentageLevels.length];
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            newPercentageLevels[i] = this.percentageLevels[i] * multiplicand;
        }
        return new ScoreDifferencePercentage(newPercentageLevels);
    }

    public ScoreDifferencePercentage divide(double divisor) {
        double[] newPercentageLevels = new double[this.percentageLevels.length];
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            newPercentageLevels[i] = this.percentageLevels[i] / divisor;
        }
        return new ScoreDifferencePercentage(newPercentageLevels);
    }

    public String toString() {
        return this.toString(Locale.US);
    }

    public String toString(String locale) {
        return this.toString(LocaleUtils.toLocale((String)locale));
    }

    public String toString(Locale locale) {
        StringBuilder s = new StringBuilder(this.percentageLevels.length * 8);
        DecimalFormat decimalFormat = new DecimalFormat("0.00%", DecimalFormatSymbols.getInstance(locale));
        for (int i = 0; i < this.percentageLevels.length; ++i) {
            if (i > 0) {
                s.append("/");
            }
            s.append(decimalFormat.format(this.percentageLevels[i]));
        }
        return s.toString();
    }
}

