/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.policy;

import java.util.HashMap;
import java.util.Map;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicRecordingEntitySelector;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public class HeuristicConfigPolicy {
    private final EnvironmentMode environmentMode;
    private final SolutionDescriptor solutionDescriptor;
    private final ScoreDefinition scoreDefinition;
    private boolean sortEntitiesByDecreasingDifficultyEnabled = false;
    private boolean sortValuesByIncreasingStrengthEnabled = false;
    private boolean reinitializeVariableFilterEnabled = false;
    private boolean initializedChainedValueFilterEnabled = false;
    private Map<String, MimicRecordingEntitySelector> mimicRecordingEntitySelectorMap = new HashMap<String, MimicRecordingEntitySelector>();

    public HeuristicConfigPolicy(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, ScoreDefinition scoreDefinition) {
        this.environmentMode = environmentMode;
        this.solutionDescriptor = solutionDescriptor;
        this.scoreDefinition = scoreDefinition;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDefinition;
    }

    public boolean isSortEntitiesByDecreasingDifficultyEnabled() {
        return this.sortEntitiesByDecreasingDifficultyEnabled;
    }

    public void setSortEntitiesByDecreasingDifficultyEnabled(boolean sortEntitiesByDecreasingDifficultyEnabled) {
        this.sortEntitiesByDecreasingDifficultyEnabled = sortEntitiesByDecreasingDifficultyEnabled;
    }

    public boolean isSortValuesByIncreasingStrengthEnabled() {
        return this.sortValuesByIncreasingStrengthEnabled;
    }

    public void setSortValuesByIncreasingStrengthEnabled(boolean sortValuesByIncreasingStrengthEnabled) {
        this.sortValuesByIncreasingStrengthEnabled = sortValuesByIncreasingStrengthEnabled;
    }

    public boolean isReinitializeVariableFilterEnabled() {
        return this.reinitializeVariableFilterEnabled;
    }

    public void setReinitializeVariableFilterEnabled(boolean reinitializeVariableFilterEnabled) {
        this.reinitializeVariableFilterEnabled = reinitializeVariableFilterEnabled;
    }

    public Map<String, MimicRecordingEntitySelector> getMimicRecordingEntitySelectorMap() {
        return this.mimicRecordingEntitySelectorMap;
    }

    public void setMimicRecordingEntitySelectorMap(Map<String, MimicRecordingEntitySelector> mimicRecordingEntitySelectorMap) {
        this.mimicRecordingEntitySelectorMap = mimicRecordingEntitySelectorMap;
    }

    public boolean isInitializedChainedValueFilterEnabled() {
        return this.initializedChainedValueFilterEnabled;
    }

    public void setInitializedChainedValueFilterEnabled(boolean initializedChainedValueFilterEnabled) {
        this.initializedChainedValueFilterEnabled = initializedChainedValueFilterEnabled;
    }

    public HeuristicConfigPolicy createPhaseConfigPolicy() {
        return new HeuristicConfigPolicy(this.environmentMode, this.solutionDescriptor, this.scoreDefinition);
    }

    public void addMimicRecordingEntitySelector(String id, MimicRecordingEntitySelector mimicRecordingEntitySelector) {
        MimicRecordingEntitySelector put = this.mimicRecordingEntitySelectorMap.put(id, mimicRecordingEntitySelector);
        if (put != null) {
            throw new IllegalStateException("Multiple entity selectors have the same id (" + id + ").");
        }
    }

    public MimicRecordingEntitySelector getMimicRecordingEntitySelector(String id) {
        return this.mimicRecordingEntitySelectorMap.get(id);
    }
}

