/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.phase;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamInclude;
import org.optaplanner.core.config.bruteforce.BruteForceSolverPhaseConfig;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicSolverPhaseConfig;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.localsearch.LocalSearchSolverPhaseConfig;
import org.optaplanner.core.config.phase.custom.CustomSolverPhaseConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.phase.AbstractSolverPhase;
import org.optaplanner.core.impl.phase.SolverPhase;
import org.optaplanner.core.impl.solver.termination.PhaseToSolverTerminationBridge;
import org.optaplanner.core.impl.solver.termination.Termination;

@XStreamInclude(value={CustomSolverPhaseConfig.class, BruteForceSolverPhaseConfig.class, ConstructionHeuristicSolverPhaseConfig.class, LocalSearchSolverPhaseConfig.class})
public abstract class SolverPhaseConfig {
    @XStreamAlias(value="termination")
    private TerminationConfig terminationConfig = null;

    public TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public void setTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public abstract SolverPhase buildSolverPhase(int var1, HeuristicConfigPolicy var2, Termination var3);

    protected void configureSolverPhase(AbstractSolverPhase solverPhase, int phaseIndex, HeuristicConfigPolicy configPolicy, Termination solverTermination) {
        solverPhase.setPhaseIndex(phaseIndex);
        TerminationConfig terminationConfig_ = this.terminationConfig == null ? new TerminationConfig() : this.terminationConfig;
        solverPhase.setTermination(terminationConfig_.buildTermination(configPolicy, new PhaseToSolverTerminationBridge(solverTermination)));
    }

    public void inherit(SolverPhaseConfig inheritedConfig) {
        if (this.terminationConfig == null) {
            this.terminationConfig = inheritedConfig.getTerminationConfig();
        } else if (inheritedConfig.getTerminationConfig() != null) {
            this.terminationConfig.inherit(inheritedConfig.getTerminationConfig());
        }
    }
}

