/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ChangeMove
implements Move {
    protected final Object entity;
    protected final PlanningVariableDescriptor variableDescriptor;
    protected final Object toPlanningValue;

    public ChangeMove(Object entity, PlanningVariableDescriptor variableDescriptor, Object toPlanningValue) {
        this.entity = entity;
        this.variableDescriptor = variableDescriptor;
        this.toPlanningValue = toPlanningValue;
    }

    public Object getEntity() {
        return this.entity;
    }

    public Object getToPlanningValue() {
        return this.toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        Object oldPlanningValue = this.variableDescriptor.getValue(this.entity);
        return !ObjectUtils.equals((Object)oldPlanningValue, (Object)this.toPlanningValue);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object oldPlanningValue = this.variableDescriptor.getValue(this.entity);
        return new ChangeMove(this.entity, this.variableDescriptor, oldPlanningValue);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        scoreDirector.beforeVariableChanged(this.entity, this.variableDescriptor.getVariableName());
        this.variableDescriptor.setValue(this.entity, this.toPlanningValue);
        scoreDirector.afterVariableChanged(this.entity, this.variableDescriptor.getVariableName());
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.entity);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ChangeMove) {
            ChangeMove other = (ChangeMove)o;
            return new EqualsBuilder().append(this.entity, other.entity).append((Object)this.variableDescriptor.getVariableName(), (Object)other.variableDescriptor.getVariableName()).append(this.toPlanningValue, other.toPlanningValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.entity).append((Object)this.variableDescriptor.getVariableName()).append(this.toPlanningValue).toHashCode();
    }

    public String toString() {
        return this.entity + " => " + this.toPlanningValue;
    }
}

