/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.variable;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections.IteratorUtils;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.EntityIndependentValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningValueSelectionOrder;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningValueSelectionPromotion;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;

@Deprecated
public class PlanningValueSelector
extends SolverPhaseLifecycleListenerAdapter {
    private ValueRangeDescriptor valueRangeDescriptor;
    private PlanningValueSelectionOrder selectionOrder = PlanningValueSelectionOrder.ORIGINAL;
    private PlanningValueSelectionPromotion selectionPromotion = PlanningValueSelectionPromotion.NONE;
    private boolean roundRobinSelection = false;
    private ScoreDirector scoreDirector;
    private Random workingRandom;
    private Collection<?> cachedPlanningValues = null;

    public PlanningValueSelector(PlanningVariableDescriptor variableDescriptor) {
        this.valueRangeDescriptor = variableDescriptor.getValueRangeDescriptor();
    }

    public void setSelectionOrder(PlanningValueSelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public void setSelectionPromotion(PlanningValueSelectionPromotion selectionPromotion) {
        this.selectionPromotion = selectionPromotion;
    }

    public void setRoundRobinSelection(boolean roundRobinSelection) {
        this.roundRobinSelection = roundRobinSelection;
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        this.scoreDirector = phaseScope.getScoreDirector();
        this.workingRandom = phaseScope.getWorkingRandom();
        this.initSelectedPlanningValueList(phaseScope);
    }

    private void initSelectedPlanningValueList(AbstractSolverPhaseScope phaseScope) {
        if (this.valueRangeDescriptor.isEntityIndependent()) {
            CountableValueRange valueRange = (CountableValueRange)((EntityIndependentValueRangeDescriptor)this.valueRangeDescriptor).extractValueRange(phaseScope.getWorkingSolution());
            this.cachedPlanningValues = IteratorUtils.toList(valueRange.createOriginalIterator(), (int)((int)valueRange.getSize()));
        } else {
            this.cachedPlanningValues = null;
        }
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        this.cachedPlanningValues = null;
    }

    public Iterator<?> iterator(Object planningEntity) {
        if (this.cachedPlanningValues != null) {
            return this.cachedPlanningValues.iterator();
        }
        CountableValueRange valueRange = (CountableValueRange)this.valueRangeDescriptor.extractValueRange(this.scoreDirector.getWorkingSolution(), planningEntity);
        List values = IteratorUtils.toList(valueRange.createOriginalIterator(), (int)((int)valueRange.getSize()));
        return values.iterator();
    }
}

