/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.greatdeluge;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;

public class GreatDelugeAcceptor
extends AbstractAcceptor {
    protected final double waterLevelUpperBoundRate;
    protected final double waterRisingRate;
    protected Score waterLevelScore = null;

    public GreatDelugeAcceptor(double waterLevelUpperBoundRate, double waterRisingRate) {
        this.waterLevelUpperBoundRate = waterLevelUpperBoundRate;
        this.waterRisingRate = waterRisingRate;
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope phaseScope) {
        if (this.waterLevelUpperBoundRate < 1.0) {
            throw new IllegalArgumentException("The greatDelugeWaterLevelUpperBoundRate (" + this.waterLevelUpperBoundRate + ") should be 1.0 or higher.");
        }
        if (this.waterRisingRate <= 0.0 || this.waterRisingRate >= 1.0) {
            throw new IllegalArgumentException("The greatDelugeWaterRisingRate (" + this.waterRisingRate + ") should be between 0.0 and 1.0 (preferably very close to 0.0).");
        }
        this.waterLevelScore = phaseScope.getBestScore().multiply(this.waterLevelUpperBoundRate);
        Object perfectMaximumScore = phaseScope.getScoreDefinition().getPerfectMaximumScore();
        if (this.waterLevelScore.compareTo(perfectMaximumScore) > 0) {
            throw new IllegalArgumentException("The waterLevelScore (" + this.waterLevelScore + ") should not be higher than the perfectMaximumScore(" + perfectMaximumScore + ").");
        }
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        return moveScope.getScore().compareTo(this.waterLevelScore) >= 0;
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        if (stepScope.getStepIndex() == stepScope.getPhaseScope().getBestSolutionStepIndex()) {
            this.waterLevelScore = stepScope.getPhaseScope().getBestScore().multiply(this.waterLevelUpperBoundRate);
        } else {
            Score perfectMaximumScore = stepScope.getPhaseScope().getScoreDefinition().getPerfectMaximumScore();
            Object waterLevelAugend = perfectMaximumScore.subtract((Score)this.waterLevelScore).multiply(this.waterRisingRate);
            this.waterLevelScore = this.waterLevelScore.add(waterLevelAugend);
        }
    }
}

