/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import java.util.List;
import org.optaplanner.core.impl.phase.scope.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractCompositeTermination;
import org.optaplanner.core.impl.solver.termination.Termination;

public class OrCompositeTermination
extends AbstractCompositeTermination {
    public OrCompositeTermination(List<Termination> terminationList) {
        super(terminationList);
    }

    public OrCompositeTermination(Termination ... terminations) {
        super(terminations);
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        for (Termination termination : this.terminationList) {
            if (!termination.isSolverTerminated(solverScope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPhaseTerminated(AbstractSolverPhaseScope phaseScope) {
        for (Termination termination : this.terminationList) {
            if (!termination.isPhaseTerminated(phaseScope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        double timeGradient = 0.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculateSolverTimeGradient(solverScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.max(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope phaseScope) {
        double timeGradient = 0.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculatePhaseTimeGradient(phaseScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.max(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }
}

