/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.curriculumcourse.domain.Course;
import org.optaplanner.examples.curriculumcourse.domain.Curriculum;
import org.optaplanner.examples.curriculumcourse.domain.Day;
import org.optaplanner.examples.curriculumcourse.domain.Lecture;
import org.optaplanner.examples.curriculumcourse.domain.Period;
import org.optaplanner.examples.curriculumcourse.domain.Room;
import org.optaplanner.examples.curriculumcourse.domain.Teacher;
import org.optaplanner.examples.curriculumcourse.domain.Timeslot;
import org.optaplanner.examples.curriculumcourse.domain.UnavailablePeriodPenalty;
import org.optaplanner.examples.curriculumcourse.domain.solver.CourseConflict;
import org.optaplanner.persistence.xstream.XStreamScoreConverter;

@PlanningSolution
@XStreamAlias(value="CourseSchedule")
public class CourseSchedule
extends AbstractPersistable
implements Solution<HardSoftScore> {
    private String name;
    private List<Teacher> teacherList;
    private List<Curriculum> curriculumList;
    private List<Course> courseList;
    private List<Day> dayList;
    private List<Timeslot> timeslotList;
    private List<Period> periodList;
    private List<Room> roomList;
    private List<UnavailablePeriodPenalty> unavailablePeriodPenaltyList;
    private List<Lecture> lectureList;
    @XStreamConverter(value=XStreamScoreConverter.class, types={HardSoftScoreDefinition.class})
    private HardSoftScore score;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Teacher> getTeacherList() {
        return this.teacherList;
    }

    public void setTeacherList(List<Teacher> teacherList) {
        this.teacherList = teacherList;
    }

    public List<Curriculum> getCurriculumList() {
        return this.curriculumList;
    }

    public void setCurriculumList(List<Curriculum> curriculumList) {
        this.curriculumList = curriculumList;
    }

    public List<Course> getCourseList() {
        return this.courseList;
    }

    public void setCourseList(List<Course> courseList) {
        this.courseList = courseList;
    }

    public List<Day> getDayList() {
        return this.dayList;
    }

    public void setDayList(List<Day> dayList) {
        this.dayList = dayList;
    }

    public List<Timeslot> getTimeslotList() {
        return this.timeslotList;
    }

    public void setTimeslotList(List<Timeslot> timeslotList) {
        this.timeslotList = timeslotList;
    }

    @ValueRangeProvider(id="periodRange")
    public List<Period> getPeriodList() {
        return this.periodList;
    }

    public void setPeriodList(List<Period> periodList) {
        this.periodList = periodList;
    }

    @ValueRangeProvider(id="roomRange")
    public List<Room> getRoomList() {
        return this.roomList;
    }

    public void setRoomList(List<Room> roomList) {
        this.roomList = roomList;
    }

    public List<UnavailablePeriodPenalty> getUnavailablePeriodPenaltyList() {
        return this.unavailablePeriodPenaltyList;
    }

    public void setUnavailablePeriodPenaltyList(List<UnavailablePeriodPenalty> unavailablePeriodPenaltyList) {
        this.unavailablePeriodPenaltyList = unavailablePeriodPenaltyList;
    }

    @PlanningEntityCollectionProperty
    public List<Lecture> getLectureList() {
        return this.lectureList;
    }

    public void setLectureList(List<Lecture> lectureList) {
        this.lectureList = lectureList;
    }

    @Override
    public HardSoftScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(HardSoftScore score) {
        this.score = score;
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        ArrayList<Comparable<AbstractPersistable>> facts = new ArrayList<Comparable<AbstractPersistable>>();
        facts.addAll(this.teacherList);
        facts.addAll(this.curriculumList);
        facts.addAll(this.courseList);
        facts.addAll(this.dayList);
        facts.addAll(this.timeslotList);
        facts.addAll(this.periodList);
        facts.addAll(this.roomList);
        facts.addAll(this.unavailablePeriodPenaltyList);
        facts.addAll(this.precalculateCourseConflictList());
        return facts;
    }

    private List<CourseConflict> precalculateCourseConflictList() {
        ArrayList<CourseConflict> courseConflictList = new ArrayList<CourseConflict>();
        for (Course leftCourse : this.courseList) {
            for (Course rightCourse : this.courseList) {
                if (leftCourse.getId() >= rightCourse.getId()) continue;
                int conflictCount = 0;
                if (leftCourse.getTeacher().equals(rightCourse.getTeacher())) {
                    ++conflictCount;
                }
                for (Curriculum curriculum : leftCourse.getCurriculumList()) {
                    if (!rightCourse.getCurriculumList().contains(curriculum)) continue;
                    ++conflictCount;
                }
                if (conflictCount <= 0) continue;
                courseConflictList.add(new CourseConflict(leftCourse, rightCourse, conflictCount));
            }
        }
        return courseConflictList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof CourseSchedule)) {
            return false;
        }
        CourseSchedule other = (CourseSchedule)o;
        if (this.lectureList.size() != other.lectureList.size()) {
            return false;
        }
        Iterator<Lecture> it = this.lectureList.iterator();
        Iterator<Lecture> otherIt = other.lectureList.iterator();
        while (it.hasNext()) {
            Lecture otherLecture;
            Lecture lecture = it.next();
            if (lecture.solutionEquals(otherLecture = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (Lecture lecture : this.lectureList) {
            hashCodeBuilder.append(lecture.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

