/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.solver;

import org.optaplanner.core.impl.domain.variable.listener.PlanningVariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;

public class VehicleUpdatingVariableListener
implements PlanningVariableListener<Customer> {
    @Override
    public void beforeEntityAdded(ScoreDirector scoreDirector, Customer customer) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector scoreDirector, Customer customer) {
        this.updateVehicle(scoreDirector, customer);
    }

    @Override
    public void beforeVariableChanged(ScoreDirector scoreDirector, Customer customer) {
    }

    @Override
    public void afterVariableChanged(ScoreDirector scoreDirector, Customer customer) {
        this.updateVehicle(scoreDirector, customer);
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector scoreDirector, Customer customer) {
    }

    @Override
    public void afterEntityRemoved(ScoreDirector scoreDirector, Customer customer) {
    }

    protected void updateVehicle(ScoreDirector scoreDirector, Customer sourceCustomer) {
        Standstill previousStandstill = sourceCustomer.getPreviousStandstill();
        Vehicle vehicle = previousStandstill == null ? null : previousStandstill.getVehicle();
        for (Customer shadowCustomer = sourceCustomer; shadowCustomer != null && shadowCustomer.getVehicle() != vehicle; shadowCustomer = shadowCustomer.getNextCustomer()) {
            scoreDirector.beforeVariableChanged(shadowCustomer, "vehicle");
            shadowCustomer.setVehicle(vehicle);
            scoreDirector.afterVariableChanged(shadowCustomer, "vehicle");
        }
    }
}

