<?xml version="1.0" encoding="UTF-8"?>
<plannerBenchmark>
  <benchmarkDirectory>local/data/general/template</benchmarkDirectory>
  <warmUpSecondsSpentLimit>30</warmUpSecondsSpentLimit>

  <inheritedSolverBenchmark>
    <problemBenchmarks>
      <problemStatisticType>BEST_SCORE</problemStatisticType>
    </problemBenchmarks>
    <solver>
      <termination>
        <minutesSpentLimit>5</minutesSpentLimit>
      </termination>
    </solver>
  </inheritedSolverBenchmark>


<#list ['JDK', 'MERSENNE_TWISTER', 'WELL512A', 'WELL1024A', 'WELL19937C', 'WELL44497B'] as randomType>
  <solverBenchmark>
    <name>Cloud Balancing Late Acceptance ${randomType}</name>
    <problemBenchmarks>
      <xstreamAnnotatedClass>org.optaplanner.examples.cloudbalancing.domain.CloudBalance</xstreamAnnotatedClass>
      <inputSolutionFile>data/cloudbalancing/unsolved/200computers-600processes.xml</inputSolutionFile>
      <inputSolutionFile>data/cloudbalancing/unsolved/800computers-2400processes.xml</inputSolutionFile>
    </problemBenchmarks>
    <solver>
      <solutionClass>org.optaplanner.examples.cloudbalancing.domain.CloudBalance</solutionClass>
      <planningEntityClass>org.optaplanner.examples.cloudbalancing.domain.CloudProcess</planningEntityClass>
      <randomType>${randomType}</randomType>
      <scoreDirectorFactory>
        <scoreDefinitionType>HARD_SOFT</scoreDefinitionType>
        <scoreDrl>/org/optaplanner/examples/cloudbalancing/solver/cloudBalancingScoreRules.drl</scoreDrl>
      </scoreDirectorFactory>
      <constructionHeuristic>
        <constructionHeuristicType>FIRST_FIT_DECREASING</constructionHeuristicType>
        <forager>
          <pickEarlyType>FIRST_NON_DETERIORATING_SCORE</pickEarlyType>
        </forager>
      </constructionHeuristic>
      <localSearch>
        <unionMoveSelector>
          <changeMoveSelector/>
          <swapMoveSelector/>
        </unionMoveSelector>
        <acceptor>
          <lateAcceptanceSize>400</lateAcceptanceSize>
        </acceptor>
        <forager>
          <acceptedCountLimit>4</acceptedCountLimit>
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
  <solverBenchmark>
    <name>Machine Reassignment Tabu Search ${randomType}</name>
    <problemBenchmarks>
      <problemIOClass>org.optaplanner.examples.machinereassignment.persistence.MachineReassignmentProblemIO</problemIOClass>
      <inputSolutionFile>data/machinereassignment/import/model_b_1.txt</inputSolutionFile>
      <inputSolutionFile>data/machinereassignment/import/model_b_10.txt</inputSolutionFile>
    </problemBenchmarks>
    <solver>
      <solutionClass>org.optaplanner.examples.machinereassignment.domain.MachineReassignment</solutionClass>
      <planningEntityClass>org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment</planningEntityClass>
      <randomType>${randomType}</randomType>
      <scoreDirectorFactory>
        <scoreDefinitionType>HARD_SOFT_LONG</scoreDefinitionType>
        <incrementalScoreCalculatorClass>org.optaplanner.examples.machinereassignment.solver.score.MachineReassignmentIncrementalScoreCalculator</incrementalScoreCalculatorClass>
      </scoreDirectorFactory>
      <customSolverPhase>
        <customSolverPhaseCommandClass>org.optaplanner.examples.machinereassignment.solver.solution.initializer.MrOriginalMachineSolutionInitializer</customSolverPhaseCommandClass>
      </customSolverPhase>
      <localSearch>
        <unionMoveSelector>
          <changeMoveSelector/>
          <swapMoveSelector/>
        </unionMoveSelector>
        <acceptor>
          <entityTabuSize>7</entityTabuSize>
        </acceptor>
        <forager>
          <acceptedCountLimit>2000</acceptedCountLimit>
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
  <solverBenchmark>
    <name>Course Scheduling Late Acceptance ${randomType}</name>
    <problemBenchmarks>
      <xstreamAnnotatedClass>org.optaplanner.examples.curriculumcourse.domain.CourseSchedule</xstreamAnnotatedClass>
      <inputSolutionFile>data/curriculumcourse/unsolved/comp07.xml</inputSolutionFile>
      <inputSolutionFile>data/curriculumcourse/unsolved/comp08.xml</inputSolutionFile>
    </problemBenchmarks>
    <solver>
      <solutionClass>org.optaplanner.examples.curriculumcourse.domain.CourseSchedule</solutionClass>
      <planningEntityClass>org.optaplanner.examples.curriculumcourse.domain.Lecture</planningEntityClass>
      <randomType>${randomType}</randomType>
      <scoreDirectorFactory>
        <scoreDefinitionType>HARD_SOFT</scoreDefinitionType>
        <scoreDrl>/org/optaplanner/examples/curriculumcourse/solver/curriculumCourseScoreRules.drl</scoreDrl>
      </scoreDirectorFactory>
      <constructionHeuristic>
        <constructionHeuristicType>FIRST_FIT_DECREASING</constructionHeuristicType>
      </constructionHeuristic>
      <localSearch>
        <unionMoveSelector>
          <changeMoveSelector>
            <valueSelector>
              <variableName>period</variableName>
            </valueSelector>
          </changeMoveSelector>
          <changeMoveSelector>
            <valueSelector>
              <variableName>room</variableName>
            </valueSelector>
          </changeMoveSelector>
          <swapMoveSelector>
            <filterClass>org.optaplanner.examples.curriculumcourse.solver.move.DifferentCourseSwapMoveFilter</filterClass>
          </swapMoveSelector>
        </unionMoveSelector>
        <acceptor>
          <lateAcceptanceSize>600</lateAcceptanceSize>
        </acceptor>
        <forager>
          <acceptedCountLimit>4</acceptedCountLimit>
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
  <solverBenchmark>
    <name>Examination Tabu Search ${randomType}</name>
    <problemBenchmarks>
      <xstreamAnnotatedClass>org.optaplanner.examples.examination.domain.Examination</xstreamAnnotatedClass>
      <inputSolutionFile>data/examination/unsolved/exam_comp_set2.xml</inputSolutionFile>
      <inputSolutionFile>data/examination/unsolved/exam_comp_set3.xml</inputSolutionFile>
    </problemBenchmarks>
    <solver>
      <solutionClass>org.optaplanner.examples.examination.domain.Examination</solutionClass>
      <planningEntityClass>org.optaplanner.examples.examination.domain.Exam</planningEntityClass>
      <randomType>${randomType}</randomType>
      <scoreDirectorFactory>
        <scoreDefinitionType>HARD_SOFT</scoreDefinitionType>
        <scoreDrl>/org/optaplanner/examples/examination/solver/examinationScoreRules.drl</scoreDrl>
      </scoreDirectorFactory>
      <customSolverPhase>
        <customSolverPhaseCommandClass>org.optaplanner.examples.examination.solver.solution.initializer.ExaminationSolutionInitializer</customSolverPhaseCommandClass>
      </customSolverPhase>
      <localSearch>
        <unionMoveSelector>
          <moveListFactory>
            <cacheType>PHASE</cacheType>
            <moveListFactoryClass>org.optaplanner.examples.examination.solver.move.factory.PeriodChangeMoveFactory</moveListFactoryClass>
          </moveListFactory>
          <moveListFactory>
            <cacheType>PHASE</cacheType>
            <moveListFactoryClass>org.optaplanner.examples.examination.solver.move.factory.RoomChangeMoveFactory</moveListFactoryClass>
          </moveListFactory>
          <moveListFactory>
            <cacheType>PHASE</cacheType>
            <moveListFactoryClass>org.optaplanner.examples.examination.solver.move.factory.ExamSwapMoveFactory</moveListFactoryClass>
          </moveListFactory>
        </unionMoveSelector>
        <acceptor>
          <entityTabuSize>10</entityTabuSize>
        </acceptor>
        <forager>
          <acceptedCountLimit>2000</acceptedCountLimit>
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
  <solverBenchmark>
    <name>Nurse Rostering Tabu Search ${randomType}</name>
    <problemBenchmarks>
      <xstreamAnnotatedClass>org.optaplanner.examples.nurserostering.domain.NurseRoster</xstreamAnnotatedClass>
      <inputSolutionFile>data/nurserostering/unsolved/medium01.xml</inputSolutionFile>
      <inputSolutionFile>data/nurserostering/unsolved/medium_hint01.xml</inputSolutionFile>
    </problemBenchmarks>
    <solver>
      <solutionClass>org.optaplanner.examples.nurserostering.domain.NurseRoster</solutionClass>
      <planningEntityClass>org.optaplanner.examples.nurserostering.domain.ShiftAssignment</planningEntityClass>
      <randomType>${randomType}</randomType>
      <scoreDirectorFactory>
        <scoreDefinitionType>HARD_SOFT</scoreDefinitionType>
        <scoreDrl>/org/optaplanner/examples/nurserostering/solver/nurseRosteringScoreRules.drl</scoreDrl>
      </scoreDirectorFactory>
      <constructionHeuristic>
        <constructionHeuristicType>BEST_FIT</constructionHeuristicType>
      </constructionHeuristic>
      <localSearch>
        <unionMoveSelector>
          <moveListFactory>
            <cacheType>PHASE</cacheType>
            <moveListFactoryClass>org.optaplanner.examples.nurserostering.solver.move.factory.EmployeeChangeMoveFactory</moveListFactoryClass>
          </moveListFactory>
          <moveListFactory>
            <cacheType>PHASE</cacheType>
            <moveListFactoryClass>org.optaplanner.examples.nurserostering.solver.move.factory.ShiftAssignmentSwapMoveFactory</moveListFactoryClass>
          </moveListFactory>
          <moveListFactory>
            <cacheType>STEP</cacheType>
            <moveListFactoryClass>org.optaplanner.examples.nurserostering.solver.move.factory.ShiftAssignmentPillarPartSwapMoveFactory</moveListFactoryClass>
          </moveListFactory>
        </unionMoveSelector>
        <acceptor>
          <entityTabuSize>7</entityTabuSize>
        </acceptor>
        <forager>
          <acceptedCountLimit>800</acceptedCountLimit>
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
  <solverBenchmark>
    <name>TravelingTournament Tabu Search ${randomType}</name>
    <problemBenchmarks>
      <xstreamAnnotatedClass>org.optaplanner.examples.travelingtournament.domain.TravelingTournament</xstreamAnnotatedClass>
      <inputSolutionFile>data/travelingtournament/unsolved/1-nl14.xml</inputSolutionFile>
    </problemBenchmarks>
    <solver>
      <solutionClass>org.optaplanner.examples.travelingtournament.domain.TravelingTournament</solutionClass>
      <planningEntityClass>org.optaplanner.examples.travelingtournament.domain.Match</planningEntityClass>
      <randomType>${randomType}</randomType>
      <scoreDirectorFactory>
        <scoreDefinitionType>HARD_SOFT</scoreDefinitionType>
        <scoreDrl>/org/optaplanner/examples/travelingtournament/solver/travelingTournamentScoreRules.drl</scoreDrl>
      </scoreDirectorFactory>
      <localSearch>
        <unionMoveSelector>
          <swapMoveSelector>
            <cacheType>PHASE</cacheType>
            <selectionOrder>SHUFFLED</selectionOrder>
            <filterClass>org.optaplanner.examples.travelingtournament.solver.move.factory.InverseMatchSwapMoveFilter</filterClass>
          </swapMoveSelector>
          <moveListFactory>
            <cacheType>STEP</cacheType>
            <selectionOrder>SHUFFLED</selectionOrder>
            <moveListFactoryClass>org.optaplanner.examples.travelingtournament.solver.move.factory.MatchChainRotationsMoveFactory</moveListFactoryClass>
          </moveListFactory>
        </unionMoveSelector>
        <acceptor>
          <solutionTabuSize>1500</solutionTabuSize>
          <moveTabuSize>7</moveTabuSize>
        </acceptor>
        <forager>
          <!-- Real world problems require to use of <acceptedCountLimit> -->
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
</#list>
</plannerBenchmark>
