/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendable;

import java.util.Arrays;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class BendableScoreHolder
extends AbstractScoreHolder {
    private int[] hardScores;
    private int[] softScores;

    public BendableScoreHolder(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new int[hardLevelsSize];
        this.softScores = new int[softLevelsSize];
    }

    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public int getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    @Deprecated
    public void setHardScore(int hardLevel, int hardScore) {
        this.hardScores[hardLevel] = hardScore;
    }

    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public int getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    @Deprecated
    public void setSoftScore(int softLevel, int softScore) {
        this.softScores[softLevel] = softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, final int hardLevel, final int weight) {
        int n = hardLevel;
        this.hardScores[n] = this.hardScores[n] + weight;
        this.registerIntConstraintMatch(kcontext, hardLevel, weight, new Runnable(){

            @Override
            public void run() {
                int[] nArray = BendableScoreHolder.this.hardScores;
                int n = hardLevel;
                nArray[n] = nArray[n] - weight;
            }
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, final int softLevel, final int weight) {
        int n = softLevel;
        this.softScores[n] = this.softScores[n] + weight;
        this.registerIntConstraintMatch(kcontext, this.getHardLevelsSize() + softLevel, weight, new Runnable(){

            @Override
            public void run() {
                int[] nArray = BendableScoreHolder.this.softScores;
                int n = softLevel;
                nArray[n] = nArray[n] - weight;
            }
        });
    }

    @Override
    public Score extractScore() {
        return new BendableScore(Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }
}

