/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint.primlong;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.primlong.LongConstraintMatch;

public class LongConstraintMatchTotal
extends ConstraintMatchTotal {
    protected final Set<LongConstraintMatch> constraintMatchSet = new HashSet<LongConstraintMatch>();
    protected long weightTotal = 0L;

    public LongConstraintMatchTotal(String constraintPackage, String constraintName, int scoreLevel) {
        super(constraintPackage, constraintName, scoreLevel);
    }

    public Set<LongConstraintMatch> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    public long getWeightTotal() {
        return this.weightTotal;
    }

    @Override
    public Number getWeightTotalAsNumber() {
        return this.weightTotal;
    }

    public LongConstraintMatch addConstraintMatch(RuleContext kcontext, long weight) {
        this.weightTotal += weight;
        List<Object> justificationList = this.extractJustificationList(kcontext);
        LongConstraintMatch constraintMatch = new LongConstraintMatch(this.constraintPackage, this.constraintName, this.scoreLevel, justificationList, weight);
        boolean added = this.constraintMatchSet.add(constraintMatch);
        if (!added) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not add constraintMatch (" + constraintMatch + ") to its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
        return constraintMatch;
    }

    public void removeConstraintMatch(LongConstraintMatch constraintMatch) {
        this.weightTotal -= constraintMatch.getWeight();
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not remove constraintMatch (" + constraintMatch + ") from its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }
}

