/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.descriptor;

import java.beans.PropertyDescriptor;
import java.util.Arrays;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;

public class CustomShadowVariableDescriptor
extends ShadowVariableDescriptor {
    protected Class<? extends VariableListener> variableListenerClass;

    public CustomShadowVariableDescriptor(EntityDescriptor entityDescriptor, PropertyDescriptor propertyDescriptor) {
        super(entityDescriptor, propertyDescriptor);
    }

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        CustomShadowVariable shadowVariableAnnotation = this.variablePropertyAccessor.getReadMethod().getAnnotation(CustomShadowVariable.class);
        this.variableListenerClass = shadowVariableAnnotation.variableListenerClass();
        Object[] sources = shadowVariableAnnotation.sources();
        if (sources.length < 1) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variablePropertyAccessor.getName() + ") with sources (" + Arrays.toString(sources) + ") which is empty.");
        }
    }

    @Override
    public void linkShadowSources(DescriptorPolicy descriptorPolicy) {
        CustomShadowVariable.Source[] sources;
        CustomShadowVariable shadowVariableAnnotation = this.variablePropertyAccessor.getReadMethod().getAnnotation(CustomShadowVariable.class);
        SolutionDescriptor solutionDescriptor = this.entityDescriptor.getSolutionDescriptor();
        for (CustomShadowVariable.Source source : sources = shadowVariableAnnotation.sources()) {
            EntityDescriptor sourceEntityDescriptor;
            Class<?> sourceEntityClass = source.entityClass();
            if (sourceEntityClass.equals(CustomShadowVariable.Source.NullEntityClass.class)) {
                sourceEntityDescriptor = this.entityDescriptor;
            } else {
                sourceEntityDescriptor = solutionDescriptor.getEntityDescriptor(sourceEntityClass);
                if (sourceEntityDescriptor == null) {
                    throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variablePropertyAccessor.getName() + ") with a sourceEntityClass (" + sourceEntityClass + ") which is not a valid planning entity.");
                }
            }
            String sourceVariableName = source.variableName();
            GenuineVariableDescriptor sourceVariableDescriptor = sourceEntityDescriptor.getGenuineVariableDescriptor(sourceVariableName);
            if (sourceVariableDescriptor == null) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variablePropertyAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a valid planning variable on entityClass (" + sourceEntityDescriptor.getEntityClass() + ").");
            }
            sourceVariableDescriptor.registerShadowVariableDescriptor(this);
        }
    }

    @Override
    public VariableListener buildVariableListener() {
        return ConfigUtils.newInstance(this, "variableListenerClass", this.variableListenerClass);
    }
}

