/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.SolverConfig;

public class XStreamXmlSolverFactory
extends SolverFactory {
    private XStream xStream = XStreamXmlSolverFactory.buildXStream();
    private SolverConfig solverConfig = null;

    public static XStream buildXStream() {
        XStream xStream = new XStream();
        xStream.setMode(1002);
        xStream.aliasSystemAttribute("xStreamId", "id");
        xStream.aliasSystemAttribute("xStreamRef", "reference");
        xStream.processAnnotations(SolverConfig.class);
        return xStream;
    }

    public void addXStreamAnnotations(Class ... xStreamAnnotations) {
        this.xStream.processAnnotations(xStreamAnnotations);
    }

    public XStreamXmlSolverFactory configure(String solverConfigResource) {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(solverConfigResource);
        if (in == null) {
            String errorMessage = "The solverConfigResource (" + solverConfigResource + ") does not exist in the classpath.";
            if (solverConfigResource.startsWith("/")) {
                errorMessage = errorMessage + "\nAs from 6.1, a classpath resource should not start with a slash (/). A solverConfigResource now adheres to ClassLoader.getResource(String). Remove the leading slash from the solverConfigResource if you're upgrading from 6.0.";
            }
            throw new IllegalArgumentException(errorMessage);
        }
        try {
            return this.configure(in);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("Unmarshalling of solverConfigResource (" + solverConfigResource + ") fails.", e);
        }
    }

    public XStreamXmlSolverFactory configure(File solverConfigFile) {
        try {
            return this.configure(new FileInputStream(solverConfigFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The solverConfigFile (" + solverConfigFile + ") was not found.", e);
        }
    }

    public XStreamXmlSolverFactory configure(InputStream in) {
        XStreamXmlSolverFactory xStreamXmlSolverFactory;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in, "UTF-8");
            xStreamXmlSolverFactory = this.configure(reader);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This vm does not support UTF-8 encoding.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)in);
        return xStreamXmlSolverFactory;
    }

    public XStreamXmlSolverFactory configure(Reader reader) {
        this.solverConfig = (SolverConfig)this.xStream.fromXML(reader);
        return this;
    }

    @Override
    public SolverConfig getSolverConfig() {
        if (this.solverConfig == null) {
            throw new IllegalStateException("The solverConfig (" + this.solverConfig + ") is null," + " call configure(...) first.");
        }
        return this.solverConfig;
    }

    @Override
    public Solver buildSolver() {
        if (this.solverConfig == null) {
            throw new IllegalStateException("The solverConfig (" + this.solverConfig + ") is null," + " call configure(...) first.");
        }
        return this.solverConfig.buildSolver();
    }
}

