/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.solver.score;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class CloudBalancingMapBasedEasyScoreCalculator
implements EasyScoreCalculator<CloudBalance> {
    public HardSoftScore calculateScore(CloudBalance cloudBalance) {
        int computerListSize = cloudBalance.getComputerList().size();
        HashMap<CloudComputer, Integer> cpuPowerUsageMap = new HashMap<CloudComputer, Integer>(computerListSize);
        HashMap<CloudComputer, Integer> memoryUsageMap = new HashMap<CloudComputer, Integer>(computerListSize);
        HashMap<CloudComputer, Integer> networkBandwidthUsageMap = new HashMap<CloudComputer, Integer>(computerListSize);
        for (CloudComputer computer : cloudBalance.getComputerList()) {
            cpuPowerUsageMap.put(computer, 0);
            memoryUsageMap.put(computer, 0);
            networkBandwidthUsageMap.put(computer, 0);
        }
        HashSet<CloudComputer> usedComputerSet = new HashSet<CloudComputer>(computerListSize);
        this.visitProcessList(cpuPowerUsageMap, memoryUsageMap, networkBandwidthUsageMap, usedComputerSet, cloudBalance.getProcessList());
        int hardScore = this.sumHardScore(cpuPowerUsageMap, memoryUsageMap, networkBandwidthUsageMap);
        int softScore = this.sumSoftScore(usedComputerSet);
        return HardSoftScore.valueOf(hardScore, softScore);
    }

    private void visitProcessList(Map<CloudComputer, Integer> cpuPowerUsageMap, Map<CloudComputer, Integer> memoryUsageMap, Map<CloudComputer, Integer> networkBandwidthUsageMap, Set<CloudComputer> usedComputerSet, List<CloudProcess> processList) {
        for (CloudProcess process : processList) {
            CloudComputer computer = process.getComputer();
            if (computer == null) continue;
            int cpuPowerUsage = cpuPowerUsageMap.get(computer) + process.getRequiredCpuPower();
            cpuPowerUsageMap.put(computer, cpuPowerUsage);
            int memoryUsage = memoryUsageMap.get(computer) + process.getRequiredMemory();
            memoryUsageMap.put(computer, memoryUsage);
            int networkBandwidthUsage = networkBandwidthUsageMap.get(computer) + process.getRequiredNetworkBandwidth();
            networkBandwidthUsageMap.put(computer, networkBandwidthUsage);
            usedComputerSet.add(computer);
        }
    }

    private int sumHardScore(Map<CloudComputer, Integer> cpuPowerUsageMap, Map<CloudComputer, Integer> memoryUsageMap, Map<CloudComputer, Integer> networkBandwidthUsageMap) {
        CloudComputer computer;
        int hardScore = 0;
        for (Map.Entry<CloudComputer, Integer> usageEntry : cpuPowerUsageMap.entrySet()) {
            computer = usageEntry.getKey();
            int cpuPowerAvailable = computer.getCpuPower() - usageEntry.getValue();
            if (cpuPowerAvailable >= 0) continue;
            hardScore += cpuPowerAvailable;
        }
        for (Map.Entry<CloudComputer, Integer> usageEntry : memoryUsageMap.entrySet()) {
            computer = usageEntry.getKey();
            int memoryAvailable = computer.getMemory() - usageEntry.getValue();
            if (memoryAvailable >= 0) continue;
            hardScore += memoryAvailable;
        }
        for (Map.Entry<CloudComputer, Integer> usageEntry : networkBandwidthUsageMap.entrySet()) {
            computer = usageEntry.getKey();
            int networkBandwidthAvailable = computer.getNetworkBandwidth() - usageEntry.getValue();
            if (networkBandwidthAvailable >= 0) continue;
            hardScore += networkBandwidthAvailable;
        }
        return hardScore;
    }

    private int sumSoftScore(Set<CloudComputer> usedComputerSet) {
        int softScore = 0;
        for (CloudComputer usedComputer : usedComputerSet) {
            softScore -= usedComputer.getCost();
        }
        return softScore;
    }
}

