/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.swingui;

import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.optaplanner.examples.common.swingui.latitudelongitude.LatitudeLongitudeTranslator;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.swingui.VehicleRoutingPanel;
import org.optaplanner.examples.vehiclerouting.swingui.VehicleRoutingSchedulePainter;

public class VehicleRoutingWorldPanel
extends JPanel {
    private final VehicleRoutingPanel vehicleRoutingPanel;
    private VehicleRoutingSchedulePainter schedulePainter = new VehicleRoutingSchedulePainter();

    public VehicleRoutingWorldPanel(VehicleRoutingPanel vehicleRoutingPanel) {
        this.vehicleRoutingPanel = vehicleRoutingPanel;
        this.schedulePainter = new VehicleRoutingSchedulePainter();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                VehicleRoutingSolution schedule = VehicleRoutingWorldPanel.this.vehicleRoutingPanel.getSchedule();
                if (schedule != null) {
                    VehicleRoutingWorldPanel.this.resetPanel(schedule);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LatitudeLongitudeTranslator translator = VehicleRoutingWorldPanel.this.schedulePainter.getTranslator();
                if (translator != null) {
                    double longitude = translator.translateXToLongitude(e.getX());
                    double latitude = translator.translateYToLatitude(e.getY());
                    VehicleRoutingWorldPanel.this.vehicleRoutingPanel.insertLocationAndCustomer(longitude, latitude);
                }
            }
        });
    }

    public void resetPanel(VehicleRoutingSolution schedule) {
        this.schedulePainter.reset(schedule, this.getSize(), this);
        this.repaint();
    }

    public void updatePanel(VehicleRoutingSolution schedule) {
        this.resetPanel(schedule);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        BufferedImage canvas = this.schedulePainter.getCanvas();
        if (canvas != null) {
            g.drawImage(canvas, 0, 0, this);
        }
    }
}

