/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.swingui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.lang.ObjectUtils;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.machinereassignment.domain.MachineReassignment;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.domain.MrResource;
import org.optaplanner.examples.machinereassignment.swingui.MrMachinePanel;

public class MachineReassignmentPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/optaplanner/examples/machinereassignment/swingui/machineReassignmentLogo.png";
    private JPanel machineListPanel;
    private MrMachinePanel unassignedPanel;
    private JLabel tooBigLabel = null;
    private Map<MrMachine, MrMachinePanel> machineToPanelMap;

    public MachineReassignmentPanel() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.createMachineListPanel();
        JPanel headerPanel = new JPanel();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(headerPanel).addComponent(this.machineListPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(headerPanel, -2, -2, -2).addComponent(this.machineListPanel, -2, -2, -2));
    }

    private void createMachineListPanel() {
        this.machineListPanel = new JPanel(new GridLayout(0, 1));
        this.unassignedPanel = new MrMachinePanel(this, Collections.<MrResource>emptyList(), null);
        this.machineListPanel.add(this.unassignedPanel);
        this.machineToPanelMap = new LinkedHashMap<MrMachine, MrMachinePanel>();
        this.machineToPanelMap.put(null, this.unassignedPanel);
    }

    private MachineReassignment getMachineReassignment() {
        return (MachineReassignment)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        for (MrMachinePanel machinePanel : this.machineToPanelMap.values()) {
            if (machinePanel.getMachine() == null) continue;
            this.machineListPanel.remove(machinePanel);
        }
        this.machineToPanelMap.clear();
        this.machineToPanelMap.put(null, this.unassignedPanel);
        this.unassignedPanel.clearProcessAssignments();
        this.updatePanel(solution);
    }

    @Override
    public void updatePanel(Solution solution) {
        MachineReassignment machineReassignment = (MachineReassignment)solution;
        List<MrResource> resourceList = machineReassignment.getResourceList();
        this.unassignedPanel.setResourceList(resourceList);
        if (machineReassignment.getMachineList().size() > 1000) {
            if (this.tooBigLabel == null) {
                this.tooBigLabel = new JLabel("The dataset is too big to show.");
                this.machineListPanel.add(this.tooBigLabel);
            }
        } else {
            if (this.tooBigLabel != null) {
                this.machineListPanel.remove(this.tooBigLabel);
                this.tooBigLabel = null;
            }
            LinkedHashSet<MrMachine> deadMachineSet = new LinkedHashSet<MrMachine>(this.machineToPanelMap.keySet());
            deadMachineSet.remove(null);
            for (MrMachine machine : machineReassignment.getMachineList()) {
                deadMachineSet.remove(machine);
                MrMachinePanel machinePanel = this.machineToPanelMap.get(machine);
                if (machinePanel == null) {
                    machinePanel = new MrMachinePanel(this, resourceList, machine);
                    this.machineListPanel.add(machinePanel);
                    this.machineToPanelMap.put(machine, machinePanel);
                }
                machinePanel.clearProcessAssignments();
            }
            this.unassignedPanel.clearProcessAssignments();
            for (MrProcessAssignment processAssignment : machineReassignment.getProcessAssignmentList()) {
                MrMachine machine = processAssignment.getMachine();
                MrMachinePanel machinePanel = this.machineToPanelMap.get(machine);
                machinePanel.addProcessAssignment(processAssignment);
            }
            for (MrMachine deadMachine : deadMachineSet) {
                MrMachinePanel deadMachinePanel = this.machineToPanelMap.remove(deadMachine);
                this.machineListPanel.remove(deadMachinePanel);
            }
            for (MrMachinePanel machinePanel : this.machineToPanelMap.values()) {
                machinePanel.update();
            }
        }
    }

    public void deleteMachine(final MrMachine machine) {
        this.logger.info("Scheduling delete of machine ({}).", (Object)machine);
        this.solutionBusiness.doProblemFactChange(new ProblemFactChange(){

            @Override
            public void doChange(ScoreDirector scoreDirector) {
                MachineReassignment machineReassignment = (MachineReassignment)scoreDirector.getWorkingSolution();
                for (MrProcessAssignment processAssignment : machineReassignment.getProcessAssignmentList()) {
                    if (!ObjectUtils.equals((Object)processAssignment.getMachine(), (Object)machine)) continue;
                    scoreDirector.beforeEntityRemoved(processAssignment);
                    processAssignment.setMachine(null);
                    scoreDirector.afterEntityRemoved(processAssignment);
                }
                machineReassignment.setMachineList(new ArrayList<MrMachine>(machineReassignment.getMachineList()));
                Iterator<MrMachine> it = machineReassignment.getMachineList().iterator();
                while (it.hasNext()) {
                    MrMachine workingMachine = it.next();
                    if (!ObjectUtils.equals((Object)workingMachine, (Object)machine)) continue;
                    scoreDirector.beforeProblemFactRemoved(workingMachine);
                    it.remove();
                    scoreDirector.beforeProblemFactRemoved(workingMachine);
                    break;
                }
            }
        });
        this.updatePanel(this.solutionBusiness.getSolution());
    }

    private class MrProcessAssignmentAction
    extends AbstractAction {
        private MrProcessAssignment processAssignment;

        public MrProcessAssignmentAction(MrProcessAssignment processAssignment) {
            super("=>");
            this.processAssignment = processAssignment;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<MrMachine> machineList = MachineReassignmentPanel.this.getMachineReassignment().getMachineList();
            JComboBox<Object> machineListField = new JComboBox<Object>(machineList.toArray());
            machineListField.setSelectedItem(this.processAssignment.getMachine());
            int result = JOptionPane.showConfirmDialog(MachineReassignmentPanel.this.getRootPane(), machineListField, "Select machine", 2);
            if (result == 0) {
                MrMachine toMrMachine = (MrMachine)machineListField.getSelectedItem();
                MachineReassignmentPanel.this.solutionBusiness.doChangeMove(this.processAssignment, "machine", toMrMachine);
                MachineReassignmentPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

