/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.domain.solver;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;
import org.optaplanner.examples.tsp.domain.Visit;

public class DomicileDistanceVisitDifficultyWeightFactory
implements SelectionSorterWeightFactory<TravelingSalesmanTour, Visit> {
    @Override
    public Comparable createSorterWeight(TravelingSalesmanTour tour, Visit visit) {
        Domicile domicile = tour.getDomicile();
        long domicileDistance = visit.getDistanceTo(domicile);
        return new DomicileDistanceVisitDifficultyWeight(visit, domicileDistance);
    }

    public static class DomicileDistanceVisitDifficultyWeight
    implements Comparable<DomicileDistanceVisitDifficultyWeight> {
        private final Visit visit;
        private final long domicileDistance;

        public DomicileDistanceVisitDifficultyWeight(Visit visit, long domicileDistance) {
            this.visit = visit;
            this.domicileDistance = domicileDistance;
        }

        @Override
        public int compareTo(DomicileDistanceVisitDifficultyWeight other) {
            return new CompareToBuilder().append(this.domicileDistance, other.domicileDistance).append(this.visit.getCity().getLatitude(), other.visit.getCity().getLatitude()).append((Object)this.visit.getId(), (Object)other.visit.getId()).toComparison();
        }
    }
}

