/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class PillarSwapMove
implements Move {
    protected final Collection<GenuineVariableDescriptor> variableDescriptors;
    protected final List<Object> leftPillar;
    protected final List<Object> rightPillar;

    public PillarSwapMove(Collection<GenuineVariableDescriptor> variableDescriptors, List<Object> leftPillar, List<Object> rightPillar) {
        this.variableDescriptors = variableDescriptors;
        this.leftPillar = leftPillar;
        this.rightPillar = rightPillar;
    }

    public List<Object> getLeftPillar() {
        return this.leftPillar;
    }

    public List<Object> getRightPillar() {
        return this.rightPillar;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptors) {
            Object rightValue;
            Object leftValue = variableDescriptor.getValue(this.leftPillar.get(0));
            if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = variableDescriptor.getValue(this.rightPillar.get(0))))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new PillarSwapMove(this.variableDescriptors, this.rightPillar, this.leftPillar);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptors) {
            Object oldRightValue;
            Object oldLeftValue = variableDescriptor.getValue(this.leftPillar.get(0));
            if (ObjectUtils.equals((Object)oldLeftValue, (Object)(oldRightValue = variableDescriptor.getValue(this.rightPillar.get(0))))) continue;
            for (Object leftEntity : this.leftPillar) {
                scoreDirector.beforeVariableChanged(variableDescriptor, leftEntity);
                variableDescriptor.setValue(leftEntity, oldRightValue);
                scoreDirector.afterVariableChanged(variableDescriptor, leftEntity);
            }
            for (Object rightEntity : this.rightPillar) {
                scoreDirector.beforeVariableChanged(variableDescriptor, rightEntity);
                variableDescriptor.setValue(rightEntity, oldLeftValue);
                scoreDirector.afterVariableChanged(variableDescriptor, rightEntity);
            }
        }
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        ArrayList<Object> entities = new ArrayList<Object>(this.leftPillar.size() + this.rightPillar.size());
        entities.addAll(this.leftPillar);
        entities.addAll(this.rightPillar);
        return entities;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(this.variableDescriptors.size() * 2);
        for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptors) {
            values.add(variableDescriptor.getValue(this.leftPillar.get(0)));
            values.add(variableDescriptor.getValue(this.rightPillar.get(0)));
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PillarSwapMove) {
            PillarSwapMove other = (PillarSwapMove)o;
            return new EqualsBuilder().append(this.variableDescriptors, other.variableDescriptors).append(this.leftPillar, other.leftPillar).append(this.rightPillar, other.rightPillar).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.variableDescriptors).append(this.leftPillar).append(this.rightPillar).toHashCode();
    }

    public String toString() {
        return this.leftPillar + " <=> " + this.rightPillar;
    }
}

