/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.optaplanner.examples.cloudbalancing.app.CloudBalancingApp;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.examples.common.swingui.TangoColorFactory;
import org.optaplanner.examples.curriculumcourse.app.CurriculumCourseApp;
import org.optaplanner.examples.dinnerparty.app.DinnerPartyApp;
import org.optaplanner.examples.examination.app.ExaminationApp;
import org.optaplanner.examples.machinereassignment.app.MachineReassignmentApp;
import org.optaplanner.examples.nqueens.app.NQueensApp;
import org.optaplanner.examples.nurserostering.app.NurseRosteringApp;
import org.optaplanner.examples.pas.app.PatientAdmissionScheduleApp;
import org.optaplanner.examples.projectjobscheduling.app.ProjectJobSchedulingApp;
import org.optaplanner.examples.tennis.app.TennisApp;
import org.optaplanner.examples.travelingtournament.app.TravelingTournamentApp;
import org.optaplanner.examples.tsp.app.TspApp;
import org.optaplanner.examples.vehiclerouting.app.VehicleRoutingApp;

public class OptaPlannerExamplesApp
extends JFrame {
    private JTextArea descriptionTextArea;

    public static void main(String[] args) {
        CommonApp.prepareSwingEnvironment();
        OptaPlannerExamplesApp optaPlannerExamplesApp = new OptaPlannerExamplesApp();
        optaPlannerExamplesApp.pack();
        optaPlannerExamplesApp.setLocationRelativeTo(null);
        optaPlannerExamplesApp.setVisible(true);
    }

    private static String determineOptaPlannerExamplesVersion() {
        String optaPlannerExamplesVersion = OptaPlannerExamplesApp.class.getPackage().getImplementationVersion();
        if (optaPlannerExamplesVersion == null) {
            optaPlannerExamplesVersion = "";
        }
        return optaPlannerExamplesVersion;
    }

    public OptaPlannerExamplesApp() {
        super("OptaPlanner examples " + OptaPlannerExamplesApp.determineOptaPlannerExamplesVersion());
        this.setIconImage(SolverAndPersistenceFrame.OPTA_PLANNER_ICON.getImage());
        this.setContentPane(this.createContentPane());
        this.setDefaultCloseOperation(3);
    }

    private Container createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout(10, 10));
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel titleLabel = new JLabel("Which example do you want to see?", 0);
        titleLabel.setFont(titleLabel.getFont().deriveFont(20.0f));
        contentPane.add((Component)titleLabel, "North");
        JScrollPane examplesScrollPane = new JScrollPane(this.createExamplesPanel());
        examplesScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        examplesScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        contentPane.add((Component)examplesScrollPane, "Center");
        contentPane.add((Component)this.createDescriptionPanel(), "South");
        return contentPane;
    }

    private JPanel createExamplesPanel() {
        JPanel examplesPanel = new JPanel();
        examplesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GroupLayout layout = new GroupLayout(examplesPanel);
        examplesPanel.setLayout(layout);
        JPanel basicExamplesPanel = this.createBasicExamplesPanel();
        JPanel realExamplesPanel = this.createRealExamplesPanel();
        JPanel difficultExamplesPanel = this.createDifficultExamplesPanel();
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(basicExamplesPanel).addGap(10).addComponent(realExamplesPanel).addGap(10).addComponent(difficultExamplesPanel));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent(basicExamplesPanel).addComponent(realExamplesPanel).addComponent(difficultExamplesPanel));
        return examplesPanel;
    }

    private JPanel createBasicExamplesPanel() {
        JPanel panel = new JPanel(new GridLayout(5, 1, 5, 5));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Basic examples");
        titledBorder.setTitleColor(TangoColorFactory.CHAMELEON_3);
        panel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add(this.createExampleButton(new NQueensApp()));
        panel.add(this.createExampleButton(new CloudBalancingApp()));
        panel.add(this.createExampleButton(new TspApp()));
        panel.add(this.createExampleButton(new DinnerPartyApp()));
        panel.add(this.createExampleButton(new TennisApp()));
        return panel;
    }

    private JPanel createRealExamplesPanel() {
        JPanel panel = new JPanel(new GridLayout(5, 1, 5, 5));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Real examples");
        titledBorder.setTitleColor(TangoColorFactory.BUTTER_3);
        panel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add(this.createExampleButton(new CurriculumCourseApp()));
        panel.add(this.createExampleButton(new MachineReassignmentApp()));
        panel.add(this.createExampleButton(new VehicleRoutingApp()));
        panel.add(this.createExampleButton(new ProjectJobSchedulingApp()));
        panel.add(this.createExampleButton(new PatientAdmissionScheduleApp()));
        return panel;
    }

    private JPanel createDifficultExamplesPanel() {
        JPanel panel = new JPanel(new GridLayout(5, 1, 5, 5));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Difficult examples");
        titledBorder.setTitleColor(TangoColorFactory.SCARLET_3);
        panel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add(this.createExampleButton(new ExaminationApp()));
        panel.add(this.createExampleButton(new NurseRosteringApp()));
        panel.add(this.createExampleButton(new TravelingTournamentApp()));
        panel.add(new JPanel());
        return panel;
    }

    private JButton createExampleButton(final CommonApp commonApp) {
        String iconResource = commonApp.getIconResource();
        Icon icon = iconResource == null ? new EmptyIcon() : new ImageIcon(this.getClass().getResource(iconResource));
        JButton button = new JButton(new AbstractAction(commonApp.getName(), icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                commonApp.init(OptaPlannerExamplesApp.this, false);
            }
        });
        button.setHorizontalAlignment(2);
        button.setHorizontalTextPosition(4);
        button.setVerticalTextPosition(0);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                OptaPlannerExamplesApp.this.descriptionTextArea.setText(commonApp.getDescription());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                OptaPlannerExamplesApp.this.descriptionTextArea.setText("");
            }
        });
        return button;
    }

    private JButton createDisabledExampleButton(CommonApp commonApp) {
        JButton exampleButton = this.createExampleButton(commonApp);
        exampleButton.setEnabled(false);
        return exampleButton;
    }

    private JPanel createDescriptionPanel() {
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)new JLabel("Description"), "North");
        this.descriptionTextArea = new JTextArea(8, 80);
        this.descriptionTextArea.setEditable(false);
        descriptionPanel.add((Component)new JScrollPane(this.descriptionTextArea, 22, 31), "Center");
        return descriptionPanel;
    }

    private static class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public int getIconWidth() {
            return 64;
        }

        @Override
        public int getIconHeight() {
            return 64;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }
}

