/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.solver.move.CloudBalancingMoveHelper;

public class CloudComputerChangeMove
implements Move {
    private CloudProcess cloudProcess;
    private CloudComputer toCloudComputer;

    public CloudComputerChangeMove(CloudProcess cloudProcess, CloudComputer toCloudComputer) {
        this.cloudProcess = cloudProcess;
        this.toCloudComputer = toCloudComputer;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.cloudProcess.getComputer(), (Object)this.toCloudComputer);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new CloudComputerChangeMove(this.cloudProcess, this.cloudProcess.getComputer());
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        CloudBalancingMoveHelper.moveCloudComputer(scoreDirector, this.cloudProcess, this.toCloudComputer);
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.cloudProcess);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toCloudComputer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CloudComputerChangeMove) {
            CloudComputerChangeMove other = (CloudComputerChangeMove)o;
            return new EqualsBuilder().append((Object)this.cloudProcess, (Object)other.cloudProcess).append((Object)this.toCloudComputer, (Object)other.toCloudComputer).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.cloudProcess).append((Object)this.toCloudComputer).toHashCode();
    }

    public String toString() {
        return this.cloudProcess + " => " + this.toCloudComputer;
    }
}

