/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.dinnerparty.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.dinnerparty.domain.DinnerParty;
import org.optaplanner.examples.dinnerparty.domain.Gender;
import org.optaplanner.examples.dinnerparty.domain.Guest;
import org.optaplanner.examples.dinnerparty.domain.Hobby;
import org.optaplanner.examples.dinnerparty.domain.HobbyPractician;
import org.optaplanner.examples.dinnerparty.domain.Job;
import org.optaplanner.examples.dinnerparty.domain.JobType;
import org.optaplanner.examples.dinnerparty.domain.Seat;
import org.optaplanner.examples.dinnerparty.domain.SeatDesignation;
import org.optaplanner.examples.dinnerparty.domain.Table;
import org.optaplanner.examples.dinnerparty.persistence.DinnerPartyDao;

public class DinnerPartyImporter
extends AbstractTxtSolutionImporter {
    public static void main(String[] args) {
        new DinnerPartyImporter().convertAll();
    }

    public DinnerPartyImporter() {
        super(new DinnerPartyDao());
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new DinnerPartyInputBuilder();
    }

    public static class DinnerPartyInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        @Override
        public Solution readSolution() throws IOException {
            DinnerParty dinnerParty = new DinnerParty();
            dinnerParty.setId(0L);
            this.readTableListAndSeatList(dinnerParty);
            this.readJobListGuestListAndHobbyPracticianList(dinnerParty);
            this.createSeatDesignationList(dinnerParty);
            BigInteger possibleSolutionSize = BigInteger.valueOf(dinnerParty.getGuestList().size()).pow(dinnerParty.getSeatDesignationList().size());
            this.logger.info("DinnerParty {} has {} jobs, {} guests, {} hobby practicians, {} tables and {} seats with a search space of {}.", new Object[]{this.getInputId(), dinnerParty.getJobList().size(), dinnerParty.getGuestList().size(), dinnerParty.getHobbyPracticianList().size(), dinnerParty.getTableList().size(), dinnerParty.getSeatList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return dinnerParty;
        }

        private void readTableListAndSeatList(DinnerParty dinnerParty) throws IOException {
            int tableListSize = this.readIntegerValue("Tables:");
            int seatsPerTable = this.readIntegerValue("SeatsPerTable:");
            ArrayList<Table> tableList = new ArrayList<Table>(tableListSize);
            ArrayList<Seat> seatList = new ArrayList<Seat>(tableListSize * seatsPerTable);
            for (int i = 0; i < tableListSize; ++i) {
                Table table = new Table();
                table.setId(Long.valueOf(i));
                table.setTableIndex(i);
                ArrayList<Seat> tableSeatList = new ArrayList<Seat>(seatsPerTable);
                Seat firstSeat = null;
                Seat previousSeat = null;
                for (int j = 0; j < seatsPerTable; ++j) {
                    Seat seat = new Seat();
                    seat.setId(Long.valueOf(i * seatsPerTable + j));
                    seat.setTable(table);
                    seat.setSeatIndexInTable(j);
                    if (previousSeat != null) {
                        seat.setLeftSeat(previousSeat);
                        previousSeat.setRightSeat(seat);
                    } else {
                        firstSeat = seat;
                    }
                    tableSeatList.add(seat);
                    seatList.add(seat);
                    previousSeat = seat;
                }
                firstSeat.setLeftSeat(previousSeat);
                previousSeat.setRightSeat(firstSeat);
                table.setSeatList(tableSeatList);
                tableList.add(table);
            }
            dinnerParty.setTableList(tableList);
            dinnerParty.setSeatList(seatList);
        }

        private void readJobListGuestListAndHobbyPracticianList(DinnerParty dinnerParty) throws IOException {
            this.readConstantLine("Code,Name,JobType,Job,Gender,Hobby1,Hobby2,Hobby3");
            this.readConstantLine("-------------------------------------------------");
            int guestSize = dinnerParty.getSeatList().size();
            ArrayList<Guest> guestList = new ArrayList<Guest>(guestSize);
            ArrayList<HobbyPractician> hobbyPracticianList = new ArrayList<HobbyPractician>(guestSize * 3);
            HashMap<String, Job> jobMap = new HashMap<String, Job>(JobType.values().length * 5);
            int jobNextId = 0;
            int hobbyPracticianJobId = 0;
            for (int i = 0; i < guestSize; ++i) {
                Guest guest = new Guest();
                guest.setId(Long.valueOf(i));
                String[] lineTokens = this.splitByCommaAndTrim(this.bufferedReader.readLine(), 6, null);
                guest.setCode(lineTokens[0]);
                guest.setName(lineTokens[1]);
                JobType jobType = JobType.valueOfCode(lineTokens[2]);
                String jobName = lineTokens[3];
                String jobMapKey = (Object)((Object)jobType) + "/" + jobName;
                Job job = (Job)jobMap.get(jobMapKey);
                if (job == null) {
                    job = new Job();
                    job.setId(Long.valueOf(jobNextId));
                    ++jobNextId;
                    job.setJobType(jobType);
                    job.setName(jobName);
                    jobMap.put(jobMapKey, job);
                }
                guest.setJob(job);
                guest.setGender(Gender.valueOfCode(lineTokens[4]));
                ArrayList<HobbyPractician> hobbyPracticianOfGuestList = new ArrayList<HobbyPractician>(lineTokens.length - 5);
                for (int j = 5; j < lineTokens.length; ++j) {
                    HobbyPractician hobbyPractician = new HobbyPractician();
                    hobbyPractician.setId(Long.valueOf(hobbyPracticianJobId));
                    ++hobbyPracticianJobId;
                    hobbyPractician.setGuest(guest);
                    hobbyPractician.setHobby(Hobby.valueOfCode(lineTokens[j]));
                    hobbyPracticianOfGuestList.add(hobbyPractician);
                    hobbyPracticianList.add(hobbyPractician);
                }
                guest.setHobbyPracticianList(hobbyPracticianOfGuestList);
                guestList.add(guest);
            }
            dinnerParty.setJobList(new ArrayList<Job>(jobMap.values()));
            dinnerParty.setGuestList(guestList);
            dinnerParty.setHobbyPracticianList(hobbyPracticianList);
        }

        private void createSeatDesignationList(DinnerParty dinnerParty) {
            List<Guest> guestList = dinnerParty.getGuestList();
            ArrayList<SeatDesignation> seatDesignationList = new ArrayList<SeatDesignation>(guestList.size());
            long id = 0L;
            for (Guest guest : guestList) {
                SeatDesignation seatDesignation = new SeatDesignation();
                seatDesignation.setId(id);
                ++id;
                seatDesignation.setGuest(guest);
                seatDesignationList.add(seatDesignation);
            }
            dinnerParty.setSeatDesignationList(seatDesignationList);
        }
    }
}

