/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

@XStreamAlias(value="problemBenchmarks")
public class ProblemBenchmarksConfig {
    private Class<SolutionFileIO> solutionFileIOClass = null;
    @XStreamImplicit(itemFieldName="xStreamAnnotatedClass")
    private List<Class> xStreamAnnotatedClassList = null;
    private Boolean writeOutputSolutionEnabled = null;
    @XStreamImplicit(itemFieldName="inputSolutionFile")
    private List<File> inputSolutionFileList = null;
    @XStreamImplicit(itemFieldName="problemStatisticType")
    private List<ProblemStatisticType> problemStatisticTypeList = null;

    public Class<SolutionFileIO> getSolutionFileIOClass() {
        return this.solutionFileIOClass;
    }

    public void setSolutionFileIOClass(Class<SolutionFileIO> solutionFileIOClass) {
        this.solutionFileIOClass = solutionFileIOClass;
    }

    public List<Class> getXStreamAnnotatedClassList() {
        return this.xStreamAnnotatedClassList;
    }

    public void setXStreamAnnotatedClassList(List<Class> xStreamAnnotatedClassList) {
        this.xStreamAnnotatedClassList = xStreamAnnotatedClassList;
    }

    public Boolean getWriteOutputSolutionEnabled() {
        return this.writeOutputSolutionEnabled;
    }

    public void setWriteOutputSolutionEnabled(Boolean writeOutputSolutionEnabled) {
        this.writeOutputSolutionEnabled = writeOutputSolutionEnabled;
    }

    public List<File> getInputSolutionFileList() {
        return this.inputSolutionFileList;
    }

    public void setInputSolutionFileList(List<File> inputSolutionFileList) {
        this.inputSolutionFileList = inputSolutionFileList;
    }

    public List<ProblemStatisticType> getProblemStatisticTypeList() {
        return this.problemStatisticTypeList;
    }

    public void setProblemStatisticTypeList(List<ProblemStatisticType> problemStatisticTypeList) {
        this.problemStatisticTypeList = problemStatisticTypeList;
    }

    public List<ProblemBenchmarkResult> buildProblemBenchmarkList(PlannerBenchmarkResult plannerBenchmark, SolverBenchmarkResult solverBenchmarkResult) {
        this.validate(solverBenchmarkResult);
        SolutionFileIO solutionFileIO = this.buildSolutionFileIO();
        ArrayList<ProblemBenchmarkResult> problemBenchmarkResultList = new ArrayList<ProblemBenchmarkResult>(this.inputSolutionFileList.size());
        List<ProblemBenchmarkResult> unifiedProblemBenchmarkResultList = plannerBenchmark.getUnifiedProblemBenchmarkResultList();
        for (File inputSolutionFile : this.inputSolutionFileList) {
            ProblemBenchmarkResult problemBenchmarkResult;
            if (!inputSolutionFile.exists()) {
                throw new IllegalArgumentException("The inputSolutionFile (" + inputSolutionFile + ") does not exist.");
            }
            ProblemBenchmarkResult newProblemBenchmarkResult = this.buildProblemBenchmark(plannerBenchmark, solutionFileIO, inputSolutionFile);
            int index = unifiedProblemBenchmarkResultList.indexOf(newProblemBenchmarkResult);
            if (index < 0) {
                problemBenchmarkResult = newProblemBenchmarkResult;
                unifiedProblemBenchmarkResultList.add(problemBenchmarkResult);
            } else {
                problemBenchmarkResult = unifiedProblemBenchmarkResultList.get(index);
            }
            this.addSingleBenchmark(solverBenchmarkResult, problemBenchmarkResult);
            problemBenchmarkResultList.add(problemBenchmarkResult);
        }
        return problemBenchmarkResultList;
    }

    private void validate(SolverBenchmarkResult solverBenchmarkResult) {
        if (ConfigUtils.isEmptyCollection(this.inputSolutionFileList)) {
            throw new IllegalArgumentException("Configure at least 1 <inputSolutionFile> for the solverBenchmarkResult (" + solverBenchmarkResult.getName() + ") directly or indirectly by inheriting it.");
        }
    }

    private SolutionFileIO buildSolutionFileIO() {
        if (this.solutionFileIOClass != null && this.xStreamAnnotatedClassList != null) {
            throw new IllegalArgumentException("Cannot use solutionFileIOClass (" + this.solutionFileIOClass + ") and xStreamAnnotatedClassList (" + this.xStreamAnnotatedClassList + ") together.");
        }
        if (this.solutionFileIOClass != null) {
            return (SolutionFileIO)ConfigUtils.newInstance((Object)this, (String)"solutionFileIOClass", this.solutionFileIOClass);
        }
        Class[] xStreamAnnotatedClasses = this.xStreamAnnotatedClassList != null ? this.xStreamAnnotatedClassList.toArray(new Class[this.xStreamAnnotatedClassList.size()]) : new Class[]{};
        return new XStreamSolutionFileIO(xStreamAnnotatedClasses);
    }

    private ProblemBenchmarkResult buildProblemBenchmark(PlannerBenchmarkResult plannerBenchmark, SolutionFileIO solutionFileIO, File inputSolutionFile) {
        ProblemBenchmarkResult problemBenchmarkResult = new ProblemBenchmarkResult(plannerBenchmark);
        String name = FilenameUtils.getBaseName((String)inputSolutionFile.getName());
        problemBenchmarkResult.setName(name);
        problemBenchmarkResult.setSolutionFileIO(solutionFileIO);
        problemBenchmarkResult.setWriteOutputSolutionEnabled(this.writeOutputSolutionEnabled == null ? false : this.writeOutputSolutionEnabled);
        problemBenchmarkResult.setInputSolutionFile(inputSolutionFile);
        ArrayList<ProblemStatistic> problemStatisticList = new ArrayList<ProblemStatistic>(this.problemStatisticTypeList == null ? 0 : this.problemStatisticTypeList.size());
        if (this.problemStatisticTypeList != null) {
            for (ProblemStatisticType problemStatisticType : this.problemStatisticTypeList) {
                problemStatisticList.add(problemStatisticType.buildProblemStatistic(problemBenchmarkResult));
            }
        }
        problemBenchmarkResult.setProblemStatisticList(problemStatisticList);
        problemBenchmarkResult.setSingleBenchmarkResultList(new ArrayList<SingleBenchmarkResult>());
        return problemBenchmarkResult;
    }

    private void addSingleBenchmark(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult) {
        SingleBenchmarkResult singleBenchmarkResult = new SingleBenchmarkResult(solverBenchmarkResult, problemBenchmarkResult);
        singleBenchmarkResult.initSingleStatisticMap();
        solverBenchmarkResult.getSingleBenchmarkResultList().add(singleBenchmarkResult);
        problemBenchmarkResult.getSingleBenchmarkResultList().add(singleBenchmarkResult);
    }

    public void inherit(ProblemBenchmarksConfig inheritedConfig) {
        this.solutionFileIOClass = (Class)ConfigUtils.inheritOverwritableProperty(this.solutionFileIOClass, inheritedConfig.getSolutionFileIOClass());
        this.xStreamAnnotatedClassList = ConfigUtils.inheritMergeableListProperty(this.xStreamAnnotatedClassList, inheritedConfig.getXStreamAnnotatedClassList());
        this.writeOutputSolutionEnabled = (Boolean)ConfigUtils.inheritOverwritableProperty((Object)this.writeOutputSolutionEnabled, (Object)inheritedConfig.getWriteOutputSolutionEnabled());
        this.inputSolutionFileList = ConfigUtils.inheritMergeableListProperty(this.inputSolutionFileList, inheritedConfig.getInputSolutionFileList());
        this.problemStatisticTypeList = ConfigUtils.inheritMergeableListProperty(this.problemStatisticTypeList, inheritedConfig.getProblemStatisticTypeList());
    }
}

