/*
 * Copyright 2013 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.optaplanner.benchmark.api;

import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;

/**
 * If at least one of the {@link SingleBenchmarkResult}s of a {@link PlannerBenchmark} fail,
 * the {@link PlannerBenchmark} throws this exception
 * after all {@link SingleBenchmarkResult}s are finished and the benchmark report has been written.
 */
public class PlannerBenchmarkException extends RuntimeException {

    public PlannerBenchmarkException(String message, Throwable cause) {
        super(message, cause);
    }

}
